/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.SGASet;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.server.Server;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.server.services.sgaservice.SGAService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tecgraf.javautils.core.filter.IFilter;

public class SchedulerResourcesController {
    private SchedulerService service;
    private final SGAService sgaService;
    private boolean control;
    private String backupFilePath;
    private ConcurrentHashMap<String, CommandResources> commands;
    private ConcurrentHashMap<String, SGAResources> sgas;

    SchedulerResourcesController(boolean control, String backupFilePath) {
        this.control = control;
        this.backupFilePath = backupFilePath;
        this.service = SchedulerService.getInstance();
        this.sgaService = SGAService.getInstance();
        this.commands = new ConcurrentHashMap();
        this.sgas = new ConcurrentHashMap();
        this.registerListener();
        this.loadUsedResources();
    }

    private void registerListener() {
        MessageService messageService = MessageService.getInstance();
        messageService.setServerMessageListener(new IMessageListener(){

            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    SchedulerResourcesController.this.removeCommandResources(cmdId);
                }
            }
        }, (IFilter<Message>)new BodyTypeFilter(CommandNotification.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadUsedResources() {
        if (!this.control) {
            return;
        }
        File backupFile = new File(this.backupFilePath);
        if (!backupFile.exists()) {
            Server.logWarningMessage("Arquivo de backup n\u00e3o encontrado. Recursos de comandos em execu\u00e7\u00e3o n\u00e3o recuperados na inicializa\u00e7\u00e3o do servidor.");
            return;
        }
        ObjectInputStream input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(this.backupFilePath));
            Object obj = null;
            while ((obj = input.readObject()) != null) {
                String cmdId = (String)obj;
                Map resourcesContents = (Map)input.readObject();
                this.addCommandResources(cmdId, resourcesContents);
            }
        }
        catch (EOFException eofe) {
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao carregar os recursos de comandos.", e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {
                    Server.logSevereMessage("Erro ao fechar stream de leitura dos recursos de comandos.", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveUsedResources() {
        ObjectOutput output = null;
        try {
            output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.backupFilePath)));
            for (String cmdId : this.commands.keySet()) {
                output.writeObject(cmdId);
                CommandResources resources = this.commands.get(cmdId);
                output.writeObject(resources.getContent());
            }
        }
        catch (IOException ioe) {
            Server.logSevereMessage("Erro ao gravar os recursos de comandos.", ioe);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ioe) {
                Server.logSevereMessage("Erro ao fechar stream de grava\u00e7\u00e3o dos recursos de comandos.", ioe);
            }
        }
    }

    void makeReservation(CommandInfo cmd) {
        if (!this.control) {
            return;
        }
        try {
            AlgorithmConfigurator configurator = cmd.getConfigurator();
            float cpu = configurator.getCpuAmount();
            float mem = configurator.getMemoryAmount();
            this.addCommandResources(cmd.getId(), cmd.getSGAName(), cpu, mem);
        }
        catch (RemoteException re) {
            Server.logSevereMessage(String.format("Erro ao adicionar o comando %s \u00e0 lista de recursos do sga %s.", cmd.getId(), cmd.getSGAName()), re);
        }
    }

    private void addCommandResources(String cmdId, Map<String, Object> resources) {
        this.addCommandResources(cmdId, new CommandResources(resources));
    }

    private void addCommandResources(String cmdId, String sgaName, float cpu, float mem) {
        this.addCommandResources(cmdId, new CommandResources(cpu, mem, sgaName));
        this.saveUsedResources();
    }

    private void addCommandResources(String cmdId, CommandResources resources) {
        String sgaName = resources.getSGAName();
        Server.logFineMessage("Adicionando recursos " + cmdId + " ao sga " + sgaName);
        this.commands.put(cmdId, resources);
        SGAResources sgaResources = this.sgas.get(sgaName);
        if (sgaResources != null) {
            sgaResources.addCpuAmount(resources.getCpuAmount());
            sgaResources.addMemoryAmount(resources.getMemoryAmount());
        }
    }

    private void removeCommandResources(String cmdId) {
        Server.logFineMessage("Removendo recursos " + cmdId);
        if (!this.commands.containsKey(cmdId)) {
            return;
        }
        CommandResources resources = this.commands.remove(cmdId);
        if (resources == null) {
            Server.logSevereMessage(String.format("Erro ao remover o comando %s da lista de recursos.", cmdId));
            return;
        }
        this.saveUsedResources();
        SGAResources sgaResources = this.sgas.get(resources.getSGAName());
        if (sgaResources != null) {
            sgaResources.subCpuAmount(resources.getCpuAmount());
            sgaResources.subMemoryAmount(resources.getMemoryAmount());
        }
    }

    boolean checkControllerResources(SGASet sgaSet, float cpuAmount, float memoryAmount) {
        if (!this.control) {
            return true;
        }
        if (cpuAmount <= 0.0f && memoryAmount <= 0.0f) {
            return true;
        }
        Server.logFineMessage("Verificando recursos:");
        String sgaName = sgaSet.getName();
        SGAResources sgaResources = this.sgas.get(sgaName);
        if (sgaResources == null) {
            sgaResources = new SGAResources();
            this.sgas.put(sgaName, sgaResources);
            for (String cmdId : this.commands.keySet()) {
                CommandInfo command;
                CommandResources resources = this.commands.get(cmdId);
                if (!sgaName.equals(resources.getSGAName()) || (command = this.sgaService.getSGACommand(sgaName, cmdId)) == null) continue;
                sgaResources.addCpuAmount(resources.getCpuAmount());
                sgaResources.addMemoryAmount(resources.getMemoryAmount());
            }
            return true;
        }
        float freeCPU = (float)sgaSet.getNumProcessors() - sgaResources.getCpuTotalAmount();
        float freeMem = (float)sgaSet.getRAMMemoryInfoMb() - sgaResources.getMemoryTotalAmount();
        Server.logFineMessage("=======================\nController");
        Server.logFineMessage("=======================");
        Server.logFineMessage("cpuAmount =" + cpuAmount);
        Server.logFineMessage("freeCPU =" + freeCPU);
        Server.logFineMessage("memoryAmount =" + memoryAmount);
        Server.logFineMessage("freeMem =" + freeMem);
        return cpuAmount <= freeCPU && memoryAmount <= freeMem;
    }

    class SGAResources {
        private float cpuTotalAmount = 0.0f;
        private float memoryTotalAmount = 0.0f;

        SGAResources() {
        }

        float getCpuTotalAmount() {
            return this.cpuTotalAmount;
        }

        void addCpuAmount(float cpuAmount) {
            this.cpuTotalAmount += cpuAmount;
            Server.logFineMessage("ADD cpuTotalAmount =" + this.cpuTotalAmount);
        }

        void subCpuAmount(float cpuAmount) {
            this.cpuTotalAmount -= cpuAmount;
            Server.logFineMessage("SUB cpuTotalAmount =" + this.cpuTotalAmount);
        }

        float getMemoryTotalAmount() {
            return this.memoryTotalAmount;
        }

        void addMemoryAmount(float memoryAmount) {
            this.memoryTotalAmount += memoryAmount;
            Server.logFineMessage("ADD memoryTotalAmount =" + this.memoryTotalAmount);
        }

        void subMemoryAmount(float memoryAmount) {
            this.memoryTotalAmount -= memoryAmount;
            Server.logFineMessage("SUB memoryTotalAmount =" + this.memoryTotalAmount);
        }
    }

    class CommandResources {
        private static final String CPU_AMOUNT = "CPU_AMOUNT";
        private static final String MEMORY_AMOUNT = "MEMORY_AMOUNT";
        private static final String SGA_NAME = "SGA_NAME";
        private float cpuAmount;
        private float memoryAmount;
        private String sgaName;

        CommandResources(float cpuAmount, float memoryAmount, String sgaName) {
            this.cpuAmount = cpuAmount;
            this.memoryAmount = memoryAmount;
            this.sgaName = sgaName;
        }

        CommandResources(Map<String, Object> map) {
            this.cpuAmount = ((Float)map.get(CPU_AMOUNT)).floatValue();
            this.memoryAmount = ((Float)map.get(MEMORY_AMOUNT)).floatValue();
            this.sgaName = (String)map.get(SGA_NAME);
        }

        float getCpuAmount() {
            return this.cpuAmount;
        }

        float getMemoryAmount() {
            return this.memoryAmount;
        }

        String getSGAName() {
            return this.sgaName;
        }

        Map<String, Object> getContent() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(CPU_AMOUNT, Float.valueOf(this.cpuAmount));
            map.put(MEMORY_AMOUNT, Float.valueOf(this.memoryAmount));
            map.put(SGA_NAME, this.sgaName);
            return map;
        }
    }
}

