/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.commandpersistenceservice;

import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.exception.ServiceFailureException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.Priority;
import csbase.logic.ProjectFileInfo;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.MonitoredFile;
import csbase.logic.algorithms.commands.CommandPersistenceNotification;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.serializer.DefaultAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.FlowAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.IAlgorithmConfigurationSerializer;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.plugin.service.commandpersistenceservice.ICommandInfo;
import csbase.server.plugin.service.commandpersistenceservice.ICommandStatusListener;
import csbase.server.services.commandpersistenceservice.CommandPersistenceCleanupThread;
import csbase.server.services.commandpersistenceservice.CommandPropertyParser;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.projectservice.ServerFileLockListener;
import csbase.util.messages.Message;
import csbase.util.messages.MessageBroker;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import tecgraf.javautils.core.io.FileUtils;

public final class CommandPersistenceService
extends Service
implements CommandPersistenceServiceInterface {
    private static final String ENCODING = "ISO-8859-1";
    private static ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static final String OUT_LOG = "out.log";
    private static final String EXIT_CODE_LOG = "exit_code.log";
    private static final String WARNINGS_LOG = "warnings.log";
    private static final String FLOW_GUILTY_NODE_LOG = "flow_guilty_id.log";
    private static final String SCRIPT_FILE_TYPE = "SCRIPT";
    private static final int LOCK_EXCLUSIVE_TIMEOUT = 4000;
    private static final int LOCK_SHARED_TIMEOUT = 1000;
    private static final String COMMANDS_DIRECTORY_NAME_PROPERTY = "commandsDirectoryName";
    private String commandsDirectoryName;
    private static final String LOGS_DIRECTORY_NAME = "logs";
    private static final String COMMAND_PROPERTIES_FILE_NAME = "cmd.properties";
    private static final String DEFAULT_CONFIGURATION_FILE_NAME = "cmd.parameters";
    private static final String DEFAULT_CONFIGURATION_FILE_TYPE = "PARAMETERS";
    private static final String FLOW_CONFIGURATION_FILE_NAME = "cmd.flx";
    private static final String FLOW_CONFIGURATION_FILE_TYPE = "FLX";
    private List<ICommandStatusListener> statusListenerList = new ArrayList<ICommandStatusListener>();
    private CommandPersistenceCleanupThread cleanupThread = null;
    private MessageService messageService;

    public static void createService() throws ServerException {
        new CommandPersistenceService();
    }

    public static CommandPersistenceService getInstance() {
        return (CommandPersistenceService)Service.getInstance("CommandPersistenceService");
    }

    private void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Server.logSevereMessage(e.getMessage(), e);
            }
        }
    }

    private void createProjectFiles(Object projectId, CommandInfo command, String configurationFileName, String configurationFileType) throws OperationFailureException {
        AlgorithmConfigurator configurator;
        try {
            configurator = command.getConfigurator();
        }
        catch (RemoteException e) {
            throw new IllegalArgumentException(String.format("N\u00e3o foi poss\u00edvel determinar um nome para o arquivo de metadados do configurador do comando %s.\n", command.getId()));
        }
        String commandId = command.getId();
        String commandDirectoryName = this.getCommandDirectoryName(commandId);
        LinkedList<ProjectFileInfo> projectFileInfos = new LinkedList<ProjectFileInfo>();
        this.checkCommandRepositoryDirectory(projectId);
        projectFileInfos.add(new ProjectFileInfo(new String[]{this.commandsDirectoryName, commandDirectoryName}, "DIRECTORY_TYPE"));
        projectFileInfos.add(new ProjectFileInfo(new String[]{this.commandsDirectoryName, commandDirectoryName, configurationFileName}, configurationFileType));
        projectFileInfos.add(new ProjectFileInfo(new String[]{this.commandsDirectoryName, commandDirectoryName, COMMAND_PROPERTIES_FILE_NAME}, "TEXT"));
        projectFileInfos.add(new ProjectFileInfo(new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME}, "DIRECTORY_TYPE"));
        String outputFilePath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME, OUT_LOG});
        FileURLValue outputFile = new FileURLValue(outputFilePath, "LOG");
        configurator.setStandardOutputFile(outputFile);
        for (FileURLValue stdout : configurator.getStandardOutputFiles()) {
            projectFileInfos.add(new ProjectFileInfo(stdout.getPathAsArray(), stdout.getType()));
        }
        String warningFilePath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME, WARNINGS_LOG});
        FileURLValue warningFile = new FileURLValue(warningFilePath, "LOG");
        configurator.setWarningsFile(warningFile);
        for (FileURLValue warningsFile : configurator.getWarningsFiles()) {
            projectFileInfos.add(new ProjectFileInfo(warningsFile.getPathAsArray(), warningsFile.getType()));
        }
        if (configurator.hasExitCode()) {
            String exitCodeLogFilePath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME, EXIT_CODE_LOG});
            FileURLValue exitCodeLogFile = new FileURLValue(exitCodeLogFilePath, "LOG");
            configurator.setExitCodeLogFile(exitCodeLogFile);
            for (FileURLValue exitLog : configurator.getExitCodeLogFiles()) {
                projectFileInfos.add(new ProjectFileInfo(exitLog.getPathAsArray(), exitLog.getType()));
            }
            if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)configurator;
                String guiltyNodeLog = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME, FLOW_GUILTY_NODE_LOG});
                FileURLValue guiltyNodeLogFile = new FileURLValue(guiltyNodeLog, "LOG");
                flowConfigurator.setGuiltyNodeLog(guiltyNodeLogFile);
                projectFileInfos.add(new ProjectFileInfo(guiltyNodeLogFile.getPathAsArray(), guiltyNodeLogFile.getType()));
            }
        }
        ProjectService projectService = ProjectService.getInstance();
        String[] root = new String[]{};
        projectService.createFiles(projectId, root, projectFileInfos);
    }

    private void checkCommandRepositoryDirectory(Object projectId) {
        ProjectService projectService = ProjectService.getInstance();
        String[] cmdsDirPath = new String[]{this.commandsDirectoryName};
        projectService.createDirectory(projectId, cmdsDirPath);
    }

    public String[] getCommandDirectory(String commandId) {
        return new String[]{this.commandsDirectoryName, this.getCommandDirectoryName(commandId)};
    }

    public String[] getLogDirectory(String commandId) {
        String commandDirectoryName = this.getCommandDirectoryName(commandId);
        return new String[]{this.commandsDirectoryName, commandDirectoryName, LOGS_DIRECTORY_NAME};
    }

    private String getCommandDirectoryName(String commandId) {
        return FileUtils.fixDirectoryName((String)commandId);
    }

    private String getCommandId(String commandDirectoryName) {
        String id = commandDirectoryName.replaceAll("^([^_]+)_([^_]+)_(.*)$", "$1@$2.$3");
        return id.replaceAll("_", "-");
    }

    public CommandInfo getCommandInfo(Object projectId, String commandId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Par\u00e2metro commandId nulo.");
        }
        String[] commandDirectory = this.getCommandDirectory(commandId);
        return this.readCommandInfo(projectId, commandDirectory);
    }

    public Set<CommandInfo> getCommandInfos(Object projectId) {
        return this.getStatusCommandInfos(projectId, null, true);
    }

    public Set<CommandInfo> getStatusCommandInfos(Object projectId, List<CommandStatus> statusFilter, boolean include) {
        if (projectId == null) {
            throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
        }
        HashSet<CommandInfo> cmdsInfo = new HashSet<CommandInfo>();
        List<String[]> cmdDirectories = this.getCommandsDirectories(projectId);
        for (String[] cmdDirectory : cmdDirectories) {
            CommandInfo commandInfo = this.readCommandInfo(projectId, cmdDirectory);
            boolean includeCommand = statusFilter == null || include && statusFilter.contains(commandInfo.getStatus()) || !include && !statusFilter.contains(commandInfo.getStatus());
            if (!includeCommand) continue;
            cmdsInfo.add(commandInfo);
        }
        return Collections.unmodifiableSet(cmdsInfo);
    }

    public long requestCommandInfos(final Object projectId, final long desiredResponseTime) {
        if (projectId == null) {
            throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
        }
        if (1L > desiredResponseTime) {
            throw new IllegalArgumentException("Par\u00e2metro avgResponseTime tem que ser maior que 0.");
        }
        final MessageBroker broker = Server.getInstance().getMessageBroker();
        final String caller = CommandPersistenceService.getUser().getLogin();
        final List<String[]> cmdDirectories = this.getCommandsDirectories(projectId);
        final Object userId = Service.getUser().getId();
        threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Service.setUserId(userId);
                    int index = 0;
                    long now = System.currentTimeMillis();
                    while (index < cmdDirectories.size()) {
                        long end = now + desiredResponseTime;
                        HashSet<CommandInfo> cmdsInfo = new HashSet<CommandInfo>();
                        while (index < cmdDirectories.size() && now < end) {
                            String[] cmdDirectory = (String[])cmdDirectories.get(index);
                            CommandInfo commandInfo = CommandPersistenceService.this.readCommandInfo(projectId, cmdDirectory);
                            cmdsInfo.add(commandInfo);
                            now = System.currentTimeMillis();
                            ++index;
                        }
                        if (cmdsInfo.size() <= 0) continue;
                        try {
                            long total = cmdDirectories.size();
                            long missing = total - (long)index;
                            CommandPersistenceServiceInterface.CommandInfosRetrived data = new CommandPersistenceServiceInterface.CommandInfosRetrived(cmdsInfo, missing, total);
                            Message message = new Message((Serializable)data);
                            broker.send(message, 0L, new String[]{caller});
                        }
                        catch (Exception e) {
                            String message = "Erro ao enviar as informa\u00e7\u00f5es de comandos ao usu\u00e1rio.";
                            Server.logSevereMessage("Erro ao enviar as informa\u00e7\u00f5es de comandos ao usu\u00e1rio.", e);
                        }
                    }
                }
                finally {
                    Service.setUserId(null);
                }
            }
        }).start();
        return cmdDirectories.size();
    }

    private List<String[]> getCommandsDirectories(Object projectId) {
        ClientProjectFile[] cmdsDirs;
        ProjectService projectService = ProjectService.getInstance();
        ArrayList<String[]> result = new ArrayList<String[]>();
        String[] cmdsDirPath = new String[]{this.commandsDirectoryName};
        if (!projectService.existsFile(projectId, cmdsDirPath)) {
            return result;
        }
        for (ClientProjectFile cmdDir : cmdsDirs = projectService.getChildren(projectId, cmdsDirPath)) {
            if (!cmdDir.isDirectory()) continue;
            result.add(cmdDir.getPath());
        }
        return result;
    }

    private String getMessage(String keySuffix, Object ... args) {
        String className = CommandPersistenceService.class.getSimpleName();
        String key = className + "." + keySuffix;
        String format = this.getString(key);
        return String.format(format, args);
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public void initService() throws ServerException {
        this.createCleanupThread();
        this.messageService = MessageService.getInstance();
    }

    public void notifyUsers(Collection<Object> allUsers, CommandPersistenceNotification notification) {
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(notification.getProjectId());
            this.messageService.send(new Message((Serializable)notification), users);
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Erro ao notificar usu\u00e1rios sobre o comando " + notification.getCommandId() + ".", e);
        }
    }

    public AlgorithmConfigurator readAlgorithmConfigurator(Object projectId, String commandId) {
        InputStream inputStream;
        Object lockId;
        String[] algConfFilePath;
        ProjectService projectService;
        block12: {
            AlgorithmConfigurator algorithmConfigurator;
            block13: {
                AlgorithmConfigurator configurator;
                DefaultAlgorithmConfigurationSerializer algConfSerializer;
                if (projectId == null) {
                    throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
                }
                if (commandId == null) {
                    throw new IllegalArgumentException("Par\u00e2metro commandId nulo.");
                }
                String[] cmdDir = this.getCommandDirectory(commandId);
                projectService = ProjectService.getInstance();
                if (projectService.existsFile(projectId, algConfFilePath = this.extendPath(cmdDir, DEFAULT_CONFIGURATION_FILE_NAME))) {
                    algConfSerializer = new DefaultAlgorithmConfigurationSerializer();
                } else {
                    algConfFilePath = this.extendPath(cmdDir, FLOW_CONFIGURATION_FILE_NAME);
                    if (!projectService.existsFile(projectId, algConfFilePath)) {
                        String path = this.path2Text(cmdDir);
                        String err = this.getMessage("error_configuration_file_not_found", path);
                        throw new ServiceFailureException(err);
                    }
                    algConfSerializer = new FlowAlgorithmConfigurationSerializer();
                }
                lockId = null;
                inputStream = null;
                ServerFileLockListener lockListener = new ServerFileLockListener();
                lockId = projectService.acquireSharedLock(projectId, algConfFilePath, lockListener, 1000L);
                if (!lockListener.getLock()) break block12;
                inputStream = projectService.getInputStream(projectId, algConfFilePath);
                algorithmConfigurator = configurator = algConfSerializer.read(inputStream);
                this.close(inputStream);
                if (lockId == null) break block13;
                projectService.releaseLock(projectId, algConfFilePath, lockId);
            }
            return algorithmConfigurator;
        }
        try {
            try {
                String message = this.getMessage("error.get.shared.lock.config", commandId);
                throw new ServiceFailureException(message);
            }
            catch (AlgorithmConfigurationSerializerException e) {
                String path = this.path2Text(algConfFilePath);
                String message = this.getMessage("error_create_configurator", path);
                throw new ServiceFailureException(message, (Throwable)e);
            }
            catch (AlgorithmNotFoundException e) {
                throw new ServiceFailureException(e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.close(inputStream);
            if (lockId != null) {
                projectService.releaseLock(projectId, algConfFilePath, lockId);
            }
            throw throwable;
        }
    }

    private CommandInfo readCommandInfo(Object projectId, String[] commandDirectory) {
        try {
            return this.readCommandInfoProperties(projectId, commandDirectory);
        }
        catch (Exception e) {
            String path = this.path2Text(commandDirectory);
            String message = this.getMessage("error_read_command_dir", path);
            Server.logSevereMessage(message, e);
            String commandId = this.getCommandId(commandDirectory[commandDirectory.length - 1]);
            return this.createSystemFailureCommand(projectId, commandId);
        }
    }

    private void validateCommandInfoDirectory(Object projectId, String[] cmdDir) throws OperationFailureException {
        String[] propFile;
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId, propFile = this.extendPath(cmdDir, COMMAND_PROPERTIES_FILE_NAME))) {
            String path = this.path2Text(cmdDir);
            String err = this.getMessage("error_command_properties_not_found", path, COMMAND_PROPERTIES_FILE_NAME);
            throw new OperationFailureException(err);
        }
        if (projectService.fileSize(projectId, propFile) == 0L) {
            String path = this.path2Text(cmdDir);
            String err = this.getMessage("error_command_properties_is_empty", path, COMMAND_PROPERTIES_FILE_NAME);
            throw new OperationFailureException(err);
        }
        String[] paramFile = this.extendPath(cmdDir, DEFAULT_CONFIGURATION_FILE_NAME);
        if (!projectService.existsFile(projectId, paramFile)) {
            paramFile = this.extendPath(cmdDir, FLOW_CONFIGURATION_FILE_NAME);
        }
        if (!projectService.existsFile(projectId, paramFile)) {
            String path = this.path2Text(cmdDir);
            String err = this.getMessage("error_configuration_file_not_found", path);
            throw new OperationFailureException(err);
        }
        if (projectService.fileSize(projectId, paramFile) == 0L) {
            String path = this.path2Text(cmdDir);
            String err = this.getMessage("error_configuration_file_is_empty", path);
            throw new OperationFailureException(err);
        }
    }

    private CommandInfo createSystemFailureCommand(Object projectId, String commandId) {
        return new CommandInfo(commandId, 0, false, projectId, null, null, Priority.getDefault(), CommandStatus.SYSTEM_FAILURE, (CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.NOT_FINISHED, false), null);
    }

    private CommandInfo readCommandInfoProperties(Object projectId, String[] cmdDir) throws OperationFailureException {
        Object lockId;
        InputStream inputStream;
        String[] propFilePath;
        ProjectService projectService;
        block7: {
            CommandInfo commandInfo;
            block8: {
                projectService = ProjectService.getInstance();
                propFilePath = this.extendPath(cmdDir, COMMAND_PROPERTIES_FILE_NAME);
                inputStream = null;
                lockId = null;
                ServerFileLockListener lockListener = new ServerFileLockListener();
                lockId = projectService.acquireSharedLock(projectId, propFilePath, lockListener, 1000L);
                if (!lockListener.getLock()) break block7;
                this.validateCommandInfoDirectory(projectId, cmdDir);
                inputStream = projectService.getInputStream(projectId, propFilePath);
                CommandInfo command = this.readCommandInfoPropertiesFromStream(projectId, inputStream);
                command.setPersistencyPath(cmdDir);
                commandInfo = command;
                this.close(inputStream);
                if (lockId == null) break block8;
                projectService.releaseLock(projectId, propFilePath, lockId);
            }
            return commandInfo;
        }
        try {
            try {
                String path = this.path2Text(propFilePath);
                String message = this.getMessage("error.get.shared.lock", path);
                throw new OperationFailureException(message);
            }
            catch (IOException e) {
                String path = this.path2Text(propFilePath);
                String message = this.getMessage("error_read_file", path);
                throw new OperationFailureException(message, (Throwable)e);
            }
            catch (ParseException e) {
                String path = this.path2Text(propFilePath);
                String message = this.getMessage("error_file_format", path);
                throw new OperationFailureException(message, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.close(inputStream);
            if (lockId != null) {
                projectService.releaseLock(projectId, propFilePath, lockId);
            }
            throw throwable;
        }
    }

    private CommandInfo readCommandInfoPropertiesFromStream(Object projectId, InputStream inputStream) throws ParseException, IOException {
        String platformFilter;
        String sgaName;
        String description;
        CommandPropertyParser parser = new CommandPropertyParser();
        parser.loadProperties(inputStream);
        String id = parser.getId();
        String userId = parser.getUserId();
        Date submittedDate = parser.getSubmittedDate();
        int globalPosition = parser.getGlobalPosition();
        boolean mailAtEnd = parser.getMailAtEnd();
        Priority priority = parser.getPriority();
        CommandStatus status = parser.getStatus();
        CommandFinalizationInfo finalizationInfo = parser.getFinalizationInfo();
        String tip = parser.getTip();
        CommandInfo commandInfo = new CommandInfo(id, globalPosition, mailAtEnd, projectId, submittedDate, (Object)userId, priority, status, finalizationInfo, tip);
        Integer wallTimeSec = parser.getWallTimeSec();
        if (wallTimeSec != null) {
            commandInfo.setWallTimeSec(wallTimeSec);
        }
        if ((description = parser.getDescription()) != null) {
            commandInfo.setDescription(description);
        }
        if ((sgaName = parser.getSGAName()) != null) {
            commandInfo.setSGAName(sgaName);
        }
        if ((platformFilter = parser.getPlatformFilter()) != null) {
            commandInfo.setPlatformFilter(platformFilter);
        }
        List<MonitoredFile> monitoredFiles = parser.getMonitoredFiles();
        commandInfo.setMonitoredFiles(monitoredFiles);
        boolean isAutomatic = parser.getIsAutomatic();
        ExecutionType executionType = parser.getExecutionType();
        switch (executionType) {
            case MULTIPLE: {
                if (isAutomatic) {
                    int executionCount = parser.getExecutionCountForMultipleExecution();
                    commandInfo.configureMultipleExecution(executionCount);
                    break;
                }
                int executionCountPerSGA = parser.getExecutionCountPerSGAForMultipleExecution();
                List<String> selectedSGAsNames = parser.getSelectedSGAsNames();
                commandInfo.configureMultipleExecution(selectedSGAsNames, executionCountPerSGA);
                break;
            }
            case SIMPLE: {
                if (isAutomatic) {
                    commandInfo.configureSimpleExecution();
                    break;
                }
                String selectedSgaName = parser.getSelectedSGAName();
                commandInfo.configureSimpleExecution(selectedSgaName);
                break;
            }
            default: {
                String fmt = "Tipo de execu\u00e7\u00e3o inv\u00e1lido no arquivo de persist\u00eancia %s.";
                String err = String.format("Tipo de execu\u00e7\u00e3o inv\u00e1lido no arquivo de persist\u00eancia %s.", executionType);
                throw new IllegalStateException(err);
            }
        }
        return commandInfo;
    }

    public boolean removeCommandInfo(Object projectId, String commandId) {
        String[] cmdDirectory;
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId, cmdDirectory = this.getCommandDirectory(commandId))) {
            return false;
        }
        projectService.removeFile(projectId, cmdDirectory);
        Collection<Object> allUsers = projectService.getAllUsers(projectId);
        allUsers.add(projectService.getOwnerId(projectId));
        this.notifyUsers(allUsers, new CommandPersistenceNotification(this.getSenderName(), projectId, commandId, CommandPersistenceNotification.Type.REMOVED));
        return true;
    }

    public boolean[] removeCommandInfos(List<Object> projectIds, List<String> commandIds) {
        boolean[] result = new boolean[commandIds.size()];
        Arrays.fill(result, false);
        for (int inx = 0; inx < commandIds.size(); ++inx) {
            result[inx] = this.removeCommandInfo(projectIds.get(inx), commandIds.get(inx));
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveAlgorithmConfiguration(CommandInfo command, String configurationFileName, IAlgorithmConfigurationSerializer configurationSerializer) throws OperationFailureException {
        String commandId;
        String[] cmdDirectory;
        Object projectId;
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId = command.getProjectId(), cmdDirectory = this.getCommandDirectory(commandId = command.getId()))) {
            String tag = "error_command_directory_not_found";
            String message = this.getMessage(tag, commandId);
            throw new OperationFailureException(message);
        }
        String[] configFilePath = this.extendPath(cmdDirectory, configurationFileName);
        if (!projectService.existsFile(projectId, configFilePath)) {
            String tag = "error_file_not_found";
            String path = this.path2Text(cmdDirectory);
            String message = this.getMessage(tag, path, configurationFileName);
            throw new OperationFailureException(message);
        }
        OutputStream output = null;
        Object lockId = null;
        try {
            ServerFileLockListener lockListener = new ServerFileLockListener();
            lockId = projectService.acquireExclusiveLock(projectId, configFilePath, lockListener, 4000L);
            if (!lockListener.getLock()) {
                String path = this.path2Text(configFilePath);
                String message = this.getMessage("error.get.exclusive.lock", path);
                throw new OperationFailureException(message);
            }
            output = projectService.getOutputStream(projectId, configFilePath);
            AlgorithmConfigurator configurator = command.getConfigurator();
            configurationSerializer.write(configurator, output);
            this.close(output);
            if (lockId == null) return;
            projectService.releaseLock(projectId, configFilePath, lockId);
            return;
        }
        catch (AlgorithmConfigurationSerializerException e) {
            try {
                String fmt = this.getMessage("error.parse_configuration_file", new Object[0]);
                String err = String.format(fmt, commandId, configurationFileName);
                throw new OperationFailureException(err);
                catch (RemoteException e2) {
                    fmt = this.getMessage("error.no_configurator", new Object[0]);
                    err = String.format(fmt, commandId, configurationFileName);
                    throw new OperationFailureException(err);
                }
            }
            catch (Throwable throwable) {
                this.close(output);
                if (lockId == null) throw throwable;
                projectService.releaseLock(projectId, configFilePath, lockId);
                throw throwable;
            }
        }
    }

    public void saveCommandInfo(CommandInfo command) throws OperationFailureException {
        FlowAlgorithmConfigurationSerializer configurationSerializer;
        String configurationFileType;
        String configurationFileName;
        AlgorithmConfigurator configurator;
        if (command == null) {
            throw new IllegalArgumentException("Par\u00e2metro command nulo.");
        }
        String cmdId = command.getId();
        try {
            configurator = command.getConfigurator();
        }
        catch (RemoteException e) {
            String fmt = "N\u00e3o foi poss\u00edvel obter o configurador do comando %s.\n";
            throw new IllegalArgumentException(String.format("N\u00e3o foi poss\u00edvel obter o configurador do comando %s.\n", cmdId));
        }
        String errorMsg = String.format("N\u00e3o foi poss\u00edvel determinar o arquivo de metadados do configurador do comando %s.\n", cmdId);
        switch (configurator.getConfiguratorType()) {
            case SIMPLE: {
                if (configurator.getAlgorithmName() != null && configurator.getAlgorithmVersionId() != null) {
                    configurationFileName = DEFAULT_CONFIGURATION_FILE_NAME;
                    configurationFileType = DEFAULT_CONFIGURATION_FILE_TYPE;
                    configurationSerializer = new DefaultAlgorithmConfigurationSerializer();
                    break;
                }
                throw new IllegalArgumentException(errorMsg);
            }
            case FLOW: {
                configurationFileName = FLOW_CONFIGURATION_FILE_NAME;
                configurationFileType = FLOW_CONFIGURATION_FILE_TYPE;
                configurationSerializer = new FlowAlgorithmConfigurationSerializer();
                break;
            }
            default: {
                throw new IllegalArgumentException(errorMsg);
            }
        }
        Object projectId = command.getProjectId();
        try {
            this.createProjectFiles(projectId, command, configurationFileName, configurationFileType);
        }
        catch (OperationFailureException ofe) {
            String fmt = "Erro ao criar arquivos de persist\u00eancia do comando [%s].\n";
            Server.logSevereMessage(String.format(fmt, cmdId), ofe);
            throw ofe;
        }
        catch (ServiceFailureException ofe) {
            String msg = String.format("Erro ao criar arquivos de persist\u00eancia do comando [%s].\n", cmdId);
            Server.logSevereMessage(msg, ofe);
            throw new OperationFailureException(msg, (Throwable)ofe);
        }
        try {
            this.saveCommandInfoProperties(command);
            this.saveAlgorithmConfiguration(command, configurationFileName, (IAlgorithmConfigurationSerializer)configurationSerializer);
        }
        catch (OperationFailureException ofe) {
            try {
                this.removeCommandInfo(projectId, cmdId);
            }
            catch (ServiceFailureException sfe) {
                String fmt = "Erro ao remover arquivos de persist\u00eancia do comando %s.\n";
                Server.logSevereMessage(String.format(fmt, cmdId), sfe);
            }
            throw ofe;
        }
        ProjectService projectService = ProjectService.getInstance();
        Collection<Object> allUsers = projectService.getAllUsers(projectId);
        allUsers.add(projectService.getOwnerId(projectId));
        CommandPersistenceNotification notif = new CommandPersistenceNotification(this.getSenderName(), projectId, cmdId, CommandPersistenceNotification.Type.SAVED);
        this.notifyUsers(allUsers, notif);
        this.notifyStatusListeners(command, command.getStatus());
    }

    private void saveCommandInfoProperties(CommandInfo command) throws OperationFailureException {
        block8: {
            String commandId;
            String[] cmdDir;
            Object projectId;
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(projectId = command.getProjectId(), cmdDir = this.getCommandDirectory(commandId = command.getId()))) {
                String key = "error_command_directory_not_found";
                String message = this.getMessage(key, commandId);
                throw new ServiceFailureException(message);
            }
            String[] propFilePath = this.extendPath(cmdDir, COMMAND_PROPERTIES_FILE_NAME);
            if (!projectService.existsFile(projectId, propFilePath)) {
                String path = this.path2Text(cmdDir);
                String message = this.getMessage("error_file_not_found", path, COMMAND_PROPERTIES_FILE_NAME);
                throw new OperationFailureException(message);
            }
            command.setPersistencyPath(cmdDir);
            Object lockId = null;
            try {
                ServerFileLockListener lockListener = new ServerFileLockListener();
                lockId = projectService.acquireExclusiveLock(projectId, propFilePath, lockListener, 4000L);
                if (!lockListener.getLock()) {
                    String path = this.path2Text(propFilePath);
                    String message = this.getMessage("error.get.exclusive.lock", path);
                    throw new OperationFailureException(message);
                }
                this.saveCommandInfoPropertiesToStream(propFilePath, command);
                if (lockId == null) break block8;
                projectService.releaseLock(projectId, propFilePath, lockId);
            }
            catch (IOException e) {
                try {
                    String path = this.path2Text(propFilePath);
                    String message = this.getMessage("error_write_command_properties", commandId, path);
                    throw new OperationFailureException(message, (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (lockId != null) {
                        projectService.releaseLock(projectId, propFilePath, lockId);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCommandInfoPropertiesToStream(String[] propFilePath, CommandInfo command) throws IOException, OperationFailureException {
        CommandPropertyParser parser = new CommandPropertyParser();
        String commandId = command.getId();
        parser.setId(commandId);
        parser.setUserId(command.getUserId());
        parser.setSubmittedDate(command.getSubmittedDate());
        parser.setWallTimeSec(command.getWallTimeSec());
        parser.setGlobalPosition(command.getGlobalPosition());
        parser.setMailAtEnd(command.isMailAtEnd());
        parser.setPriority(command.getPriority());
        parser.setStatus(command.getStatus());
        parser.setFinalizationInfo(command.getFinalizationInfo());
        parser.setDescription(command.getDescription());
        parser.setSGAName(command.getSGAName());
        parser.setPlatformFilter(command.getPlatformFilter());
        parser.setTip(command.getTip());
        parser.setMonitoredFiles(command.getMonitoredFiles());
        boolean isAutomatic = command.isAutomatic();
        parser.setIsAutomatic(isAutomatic);
        ExecutionType executionType = command.getExecutionType();
        parser.setExecutionType(executionType);
        switch (executionType) {
            case MULTIPLE: {
                if (isAutomatic) {
                    parser.setExecutionCountForMultipleExecution(command.getExecutionCountForMultipleExecution());
                    break;
                }
                parser.setExecutionCountPerSGAForMultipleExecution(command.getExecutionCountPerSGAForMultipleExecution());
                parser.setSelectedSGAsNames(command.getSelectedSGAsNames());
                break;
            }
            case SIMPLE: {
                if (isAutomatic) break;
                parser.setSelectedSGAsNames(command.getSelectedSGAsNames());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Tipo de execu\u00e7\u00e3o inv\u00e1lido no arquivo de persist\u00eancia %s.", executionType));
            }
        }
        try (OutputStream outputStream = null;){
            ProjectService projectService = ProjectService.getInstance();
            Object projectId = command.getProjectId();
            outputStream = projectService.getOutputStream(projectId, propFilePath);
            parser.saveProperties(outputStream);
        }
    }

    @Override
    public void shutdownService() {
        if (this.cleanupThread != null) {
            this.cleanupThread.shutdown();
        }
    }

    public void updateCommandDescription(Object projectId, String commandId, String description) {
        if (projectId == null) {
            throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Par\u00e2metro commandId nulo.");
        }
        CommandInfo command = this.getCommandInfo(projectId, commandId);
        command.setDescription(description);
        this.updateCommandInfo(command);
        ProjectService projectService = ProjectService.getInstance();
        Collection<Object> allUsers = projectService.getAllUsers(projectId);
        allUsers.add(projectService.getOwnerId(projectId));
        this.notifyUsers(allUsers, new CommandPersistenceNotification(this.getSenderName(), projectId, commandId, CommandPersistenceNotification.Type.UPDATED));
    }

    public void addCommandStatusListener(ICommandStatusListener listener) {
        this.statusListenerList.add(listener);
    }

    public void removeAllCommandStatusListener() {
        this.statusListenerList.clear();
    }

    public void updateCommandInfo(CommandInfo command) {
        if (command == null) {
            throw new IllegalArgumentException("Par\u00e2metro command nulo.");
        }
        String commandId = command.getId();
        try {
            this.saveCommandInfoProperties(command);
        }
        catch (OperationFailureException e) {
            String message = this.getMessage("error_save_command_info", commandId);
            throw new ServiceFailureException(message, (Throwable)e);
        }
    }

    public void updateCommandStatus(CommandInfo command) {
        CommandStatus status = command.getStatus();
        try {
            this.updateCommandInfo(command);
        }
        finally {
            this.notifyStatusListeners(command, status);
        }
    }

    private void notifyStatusListeners(final CommandInfo command, final CommandStatus status) {
        if (this.statusListenerList == null || this.statusListenerList.isEmpty()) {
            return;
        }
        for (ICommandStatusListener listener : this.statusListenerList) {
            listener.statusChanged(new ICommandInfo(){

                public String getCommandId() {
                    return command.getId();
                }

                public String getDescription() {
                    return command.getDescription();
                }

                public String getProjectId() {
                    return (String)command.getProjectId();
                }

                public ICommandInfo.CommandStatus getStatus() {
                    switch (status) {
                        case DOWNLOADING: {
                            return ICommandInfo.CommandStatus.DOWNLOADING;
                        }
                        case EXECUTING: {
                            return ICommandInfo.CommandStatus.EXECUTING;
                        }
                        case FINISHED: {
                            return ICommandInfo.CommandStatus.FINISHED;
                        }
                        case INIT: {
                            return ICommandInfo.CommandStatus.INIT;
                        }
                        case SCHEDULED: {
                            return ICommandInfo.CommandStatus.SCHEDULED;
                        }
                        case SYSTEM_FAILURE: {
                            return ICommandInfo.CommandStatus.SYSTEM_FAILURE;
                        }
                        case UPLOADING: {
                            return ICommandInfo.CommandStatus.UPLOADING;
                        }
                    }
                    throw new IllegalArgumentException("Tipo do evento inv\u00e1lido: " + status);
                }

                public ICommandInfo.FinalizationType getFinalizationType() {
                    CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                    CommandFinalizationType type = finalizationInfo.getFinalizationType();
                    switch (type) {
                        case END: {
                            return ICommandInfo.FinalizationType.COMPLETED;
                        }
                        case EXECUTION_ERROR: {
                            return ICommandInfo.FinalizationType.ERROR;
                        }
                        case FAILED: {
                            return ICommandInfo.FinalizationType.INIT_FAILURE;
                        }
                        case KILLED: {
                            return ICommandInfo.FinalizationType.KILLED;
                        }
                        case LOST: {
                            return ICommandInfo.FinalizationType.LOST;
                        }
                        case NO_EXIT_CODE: {
                            return ICommandInfo.FinalizationType.NO_CODE;
                        }
                        case SUCCESS: {
                            return ICommandInfo.FinalizationType.SUCCESS;
                        }
                    }
                    throw new IllegalArgumentException("Tipo do evento inv\u00e1lido: " + type);
                }

                public Integer getExitCode() {
                    CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                    return finalizationInfo.getExitCode();
                }

                public Integer getGuiltyNodeId() {
                    CommandFinalizationInfo finalizationInfo = command.getFinalizationInfo();
                    CommandFinalizationInfo.FinalizationInfoType infoType = finalizationInfo.getInfoType();
                    if (infoType.equals((Object)CommandFinalizationInfo.FinalizationInfoType.EXTENDED)) {
                        ExtendedCommandFinalizationInfo extendedInfo = (ExtendedCommandFinalizationInfo)finalizationInfo;
                        return extendedInfo.getGuiltyNodeId();
                    }
                    return null;
                }

                public MonitoredFile[] getMonitoredFiles() {
                    List list = command.getMonitoredFiles();
                    return list.toArray(new MonitoredFile[list.size()]);
                }
            });
        }
    }

    private CommandPersistenceService() throws ServerException {
        super("CommandPersistenceService");
        ClientRemoteLocator.commandPersistenceService = this;
        this.commandsDirectoryName = this.getStringProperty(COMMANDS_DIRECTORY_NAME_PROPERTY);
        this.commandsDirectoryName = this.commandsDirectoryName.trim();
        if (this.commandsDirectoryName.startsWith(".")) {
            String substring = this.commandsDirectoryName.substring(1);
            this.commandsDirectoryName = '.' + FileUtils.fixDirectoryName((String)substring);
        } else {
            this.commandsDirectoryName = FileUtils.fixDirectoryName((String)this.commandsDirectoryName);
        }
    }

    public String[][] getCommandScripts(String commandId, Object projectId) throws OperationFailureException {
        String[] cmdDirPath;
        if (projectId == null) {
            throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
        }
        if (commandId == null) {
            throw new IllegalArgumentException("Par\u00e2metro commandId nulo.");
        }
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId, cmdDirPath = this.getCommandDirectory(commandId))) {
            throw new OperationFailureException(this.getMessage("error_command_directory_not_found", commandId));
        }
        ClientProjectFile[] scripts = projectService.getChildren(projectId, cmdDirPath);
        String[][] paths = new String[scripts.length][];
        for (int i = 0; i < scripts.length; ++i) {
            paths[i] = scripts[i].getPath();
        }
        return paths;
    }

    public void saveCommandScript(String fileName, String commandId, Object projectId, String commandLine) throws OperationFailureException {
        block12: {
            String[] cmdDirPath;
            if (fileName == null) {
                throw new IllegalArgumentException("Par\u00e2metro fileName nulo.");
            }
            if (commandId == null) {
                throw new IllegalArgumentException("Par\u00e2metro commandId nulo.");
            }
            if (projectId == null) {
                throw new IllegalArgumentException("Par\u00e2metro projectId nulo.");
            }
            if (commandLine == null) {
                throw new IllegalArgumentException("Par\u00e2metro commandLine nulo.");
            }
            ProjectService projectService = ProjectService.getInstance();
            if (!projectService.existsFile(projectId, cmdDirPath = this.getCommandDirectory(commandId))) {
                String message = this.getMessage("error_command_directory_not_found", commandId);
                throw new OperationFailureException(message);
            }
            projectService.createFile(projectId, cmdDirPath, fileName, SCRIPT_FILE_TYPE);
            String[] filePath = projectService.getChild(projectId, cmdDirPath, fileName).getPath();
            if (!projectService.existsFile(projectId, filePath)) {
                String path = this.path2Text(cmdDirPath);
                String message = this.getMessage("error_file_not_found", path, fileName);
                throw new OperationFailureException(message);
            }
            OutputStream output = null;
            Object lockId = null;
            try {
                ServerFileLockListener lockListener = new ServerFileLockListener();
                lockId = projectService.acquireExclusiveLock(projectId, filePath, lockListener, 4000L);
                if (!lockListener.getLock()) {
                    String path = this.path2Text(filePath);
                    String message = this.getMessage("error.get.exclusive.lock", path);
                    throw new ServiceFailureException(message);
                }
                output = projectService.getOutputStream(projectId, filePath);
                output.write(commandLine.getBytes(ENCODING));
                this.close(output);
                if (lockId == null) break block12;
                projectService.releaseLock(projectId, filePath, lockId);
            }
            catch (IOException e) {
                try {
                    String path = this.path2Text(filePath);
                    String message = this.getMessage("error_write_script_file", path, commandId);
                    throw new OperationFailureException(message, (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(output);
                    if (lockId != null) {
                        projectService.releaseLock(projectId, filePath, lockId);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void createUniqueCommandDirectory(Object projectId, String commandId) {
        this.checkCommandRepositoryDirectory(projectId);
        ProjectService projectService = ProjectService.getInstance();
        projectService.createFile(projectId, new String[]{this.getCommandsDirectoryName()}, this.getCommandDirectoryName(commandId), "DIRECTORY_TYPE");
    }

    public String getCommandsDirectoryName() {
        return this.commandsDirectoryName;
    }

    private void createCleanupThread() throws ServerException {
        this.cleanupThread = new CommandPersistenceCleanupThread();
        this.cleanupThread.start();
    }

    private String path2Text(String[] path) {
        StringBuffer text = new StringBuffer("");
        for (String part : path) {
            text.append(part).append("/");
        }
        return text.substring(0, text.length() - 1);
    }

    private String[] extendPath(String[] path, String part) {
        String[] newPath = new String[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = part;
        return newPath;
    }

    @Override
    protected Service[] getInitializationDependencies() {
        return new Service[]{ProjectService.getInstance()};
    }

    public void appendToFile(CommandInfo cmd, String filename, String chunk) {
        String[] path = new String[]{this.commandsDirectoryName, this.getCommandDirectoryName(cmd.getId()), LOGS_DIRECTORY_NAME, filename};
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(cmd.getProjectId(), path)) {
            Service.setUserId(cmd.getUserId());
            projectService.createFile(cmd.getProjectId(), new String[]{this.commandsDirectoryName, this.getCommandDirectoryName(cmd.getId()), LOGS_DIRECTORY_NAME}, filename, null);
            Service.setUserId(null);
        }
        String filePath = projectService.getAbsolutePath(cmd.getProjectId(), path);
        try (FileWriter fw = new FileWriter(filePath, true);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(chunk.toCharArray());
        }
        catch (IOException e) {
            Server.logWarningMessage(MessageFormat.format("Erro ao escrever no arquivo {0} do comando {1}.", filePath, cmd.getId()));
        }
    }
}

