/*
 * ServerException.java
 * $Author: rodrigoh $
 * $Revision: 35834 $  - $Date: 2005-08-08 13:55:52 -0300 (Mon, 08 Aug 2005) $
 */
package csbase.server;

import java.text.MessageFormat;

/**
 * A classe <code>ServerException</code> representa uma exceo do servidor
 */
public class ServerException extends Exception {
  /**
   * Constri uma exceo contendo sua descrio.
   *
   * @param message a descrio do erro
   */
  public ServerException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo sua descrio.
   *
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   *
   * @see MessageFormat
   */
  public ServerException(String pattern, Object[] arguments) {
    super(MessageFormat.format(pattern, arguments));
  }

  /**
   * Constri uma exceo contendo a causa/exceo original
   *
   * @param exception a exceo original
   */
  public ServerException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original
   *
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public ServerException(String message, Throwable exception) {
    super(message, exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   *
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   * @param exception a exceo original
   *
   * @see MessageFormat
   */
  public ServerException(
    String pattern, Object[] arguments, Throwable exception) {
    super(MessageFormat.format(pattern, arguments), exception);
  }
}
