/**
 * $Id: Monitor.java 141623 2013-06-04 18:04:01Z fpina $
 */

package csbase.server.services.diagnosticservice.monitors;

import java.util.Locale;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;

/**
 * Interface que representa um monitor de recurso.
 * 
 * @author Tecgraf
 */
public interface Monitor {
  /**
   * Obtm o nome do recurso monitorado. Esse nome  chave para recuperar os
   * monitores.
   * 
   * @return nome do recurso monitorado
   */
  public String getResourceName();

  /**
   * Adiciona uma validao que deve ser feita pelo monitor durante a obteno
   * do estado do recurso. A validao ser a ltima a ser feita.
   * 
   * @param validation a validao
   */
  public void addValidation(Validation validation);

  /**
   * Adiciona na posio indicada uma validao que deve ser feita pelo monitor
   * durante a obteno do estado do recurso. A posio com valor 0 indica que o
   * a validao deve ser a primeira a ser feita.
   * 
   * @param pos a posio onde a validao ser adicionada
   * @param validation a validao
   */
  public void addValidation(int pos, Validation validation);

  /**
   * Adiciona uma propriedade que  usada na monitorao do recurso.
   * 
   * @param name nome da propriedade
   * @param value valor da propriedade
   * @param source origem da propriedade
   */
  public void addProperty(String name, String value, String source);

  /**
   * Obtm o estado do recurso monitorado usando as validaes adicionadas ao
   * monitor. Para obter o estado, o monitor realiza as validaes na mesma
   * orderm na qual elas foram adicionadas.
   * Se uma validao no for satisfeita (diferente de OK) as 
   * validaes subsequentes no sero feitas.
   * 
   * @param locale o locale usado para traduo de textos
   * @return o estado do recurso monitorado
   * @throws ResourceException se ocorrer um erro durante as validaes do
   *         recurso monitorado.
   */
  public Status checkResource(Locale locale) throws ResourceException;
}
