/*
 * $Id: ClientConnectionSpy.java 110914 2010-10-05 14:48:11Z cassino $
 */

package csbase.server.services.loginservice;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;

import csbase.server.Server;

/**
 * Objeto remoto criado para cada sesso do usurio, com a finalidade de
 * monitorar a conexo com o cliente. Sempre que a comunicao com o cliente 
 * interrompida, ele envia um aviso ao <code>LoginService</code>.<br>
 * A referncia desse objeto deve existir no cliente enquanto o servidor estiver
 * sendo utilizado.
 * 
 * @author Tecgraf/PUC-Rio.
 */
class ClientConnectionSpy extends RemoteObject implements Remote, Unreferenced {
  /**
   * Chave da sesso.
   */
  private final Object sessionKey;

  /**
   * Cria e exporta o espio da conexo.
   * 
   * @param sessionKey Chave da sesso.
   * 
   * @throws RemoteException Falha ao exportar objeto.
   */
  public ClientConnectionSpy(final Object sessionKey) throws RemoteException {
    this.sessionKey = sessionKey;
    int port = Server.getInstance().getRMIExportPort();
    UnicastRemoteObject.exportObject(this, port);
  }

  /**
   * Avisa ao <code>LoginService</code> que a comunicao com o cliente foi
   * interrompida. Faz o unexport do espio.
   */
  @Override
  public void unreferenced() {
    try {
      UnicastRemoteObject.unexportObject(this, true);
    }
    catch (final RemoteException e) {
      //Nada a ser feito.
    }
    LoginService.getInstance().warnConnectionLost(sessionKey);
  }
}
