package csbase.server.services.administrationservice;

import java.util.List;

import csbase.logic.Role;
import csbase.logic.RoleInfo;

/**
 * Implementao padro do DAO de perfil. Utiliza armazenamento em arquivo
 * (serializao de objetos).
 * 
 * @see DefaultAdministrationDAOFactory
 * @author Jorge Alexandre
 * 
 */
public class DefaultRoleDAO implements RoleDAO {

  private RoleIO roleRepository;

  public DefaultRoleDAO() {
    this.roleRepository = new RoleIO();
  }

  public Role createRole(RoleInfo info) throws DAOException {
    Role role;
    try {
      role = roleRepository.writeNew(info);
    }
    catch (Exception e) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "]";
      throw new DAOException(e, operationInfo);
    }
    if (role == null) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "]";
      throw new DAOException("Falha em RoleIO.writeNew", operationInfo);
    }
    return role;
  }

  public void deleteRole(Object id) throws DAOException {
    try {
      roleRepository.delete(id);
    }
    catch (Exception e) {
      throw new DAOException(e, "id: " + id);
    }
  }

  public Role modifyRole(Object id, RoleInfo info) throws DAOException {
    Role role;
    try {
      role = roleRepository.write(id, info);
    }
    catch (Exception e) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "] - para o usurio: " + id;
      throw new DAOException(e, operationInfo);
    }
    if (role == null) {
      String operationInfo = "[name: " + info.name + ", desc: "
        + info.description + "] - para o usurio: " + id;
      throw new DAOException("Falha em RoleIO.write", operationInfo);
    }
    return role;
  }

  public List<Role> readAllRoles() throws DAOException {
    try {
      return roleRepository.readAll();
    }
    catch (Exception e) {
      throw new DAOException(e);
    }
  }

  public Role readRole(Object id) throws DAOException {
    try {
      return roleRepository.read(id);
    }
    catch (Exception e) {
      throw new DAOException(e);
    }
  }

}
