/*
 * AlgorithmUploadObserver.java
 *
 * $Author: rodrigoh $ $Revision: 175720 $ - $Date: 2007-03-19 15:39:56 -0300
 * (Mon, 19 Mar 2007) $
 */
package csbase.server.services.algorithmservice;

import java.util.Observable;
import java.util.Observer;

import csbase.server.services.httpservice.UploadResult;

// #TODO A remover quando todos sistemas CSBase forem assinados (TODA A CLASSE)
/**
 * Observador do HttpService. Chama o AlgoService quando o upload de algum
 * configurador ou executavel finaliza.
 *
 * @author clinio
 */
class AlgorithmObserver implements Observer {

  final static int UPLOAD_CONFIG = 1;
  final static int UPLOAD_EXEC = 2;
  final static int UPLOAD_HTML = 3;
  final static int UPLOAD_RELEASE_NOTES = 4;
  private Object algoId;
  private Object versionId;
  private String platform;
  private int type;
  /** Usuario que solicitou o upload */
  private Object userId;

  public AlgorithmObserver(Object algoId, Object versionId, int type,
    Object userId) {
    this(algoId, versionId, null, userId);
    this.type = type;
  }

  public AlgorithmObserver(Object algoId, Object versionId, String platform,
    Object userId) {
    this.algoId = algoId;
    this.versionId = versionId;
    this.platform = platform;
    this.userId = userId;
    type = UPLOAD_EXEC;
  }

  @Override
  public void update(Observable o, Object arg) {
    AlgorithmService service = AlgorithmService.getInstance();
    UploadResult result = (UploadResult) arg;
    if (type == UPLOAD_CONFIG) {
      service.updateConfigurator(algoId, versionId, result.getFilePath(),
        userId);
    }
    else if (type == UPLOAD_EXEC) {
      service.updateExecutable(algoId, versionId, platform, result
        .getFilePath(), userId);
    }
    else if (type == UPLOAD_HTML) {
      service.updateDoc(algoId, versionId, result.getFilePath(), userId);
    }
    else if (type == UPLOAD_RELEASE_NOTES) {
      service.updateDoc(algoId, versionId, result.getFilePath(), userId);
    }
  }

}
