package csbase.server.services.opendreamsservice.opendreams.v1_04;

import org.omg.PortableServer.POA;

import tecgraf.openbus.DRMAA.AuthorizationException;
import tecgraf.openbus.DRMAA.InternalException;
import tecgraf.openbus.DRMAA.Session;
import tecgraf.openbus.DRMAA.SessionHelper;
import tecgraf.openbus.opendreams.IOpenDreamsPOA;
import csbase.server.Server;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Implementa a idl <code>IOpenDreams</code>.
 * 
 * Recupera a sesso ativa associada a um determinado usurio e a um projeto
 * csbase. Se a sesso ainda no existir, cria a sesso.
 * 
 * @author Tecgraf PUC-Rio
 */
public class OpenDreams extends IOpenDreamsPOA {
  /**
   * Referncia para a sesso do opendreams
   */
  private Session session;
  /**
   * Referncia para o gerenciador das sesses
   */
  private SessionManager sessionManagement;

  /**
   * Constri o objeto que implementa a interface <code>IOpenDremas</code>.
   * 
   */
  public OpenDreams() {
    sessionManagement = new SessionManager();
  }

  /**
   * Obtm a sesso passando apenas o nome do projeto. O owner do projeto  o
   * usurio da credencial. {@inheritDoc}
   */
  @Override
  public Session getSession(String projectName) throws AuthorizationException,
    InternalException {
    org.omg.CORBA.Object obj;
    try {
      String currentUser = OpenBusService.getInstance().initCSBaseAccess();
      try {
        POA poa = OpenBusService.getInstance().getRootPOA();
        obj =
          poa.servant_to_reference(sessionManagement.getSession(currentUser,
            projectName));
      }
      catch (Throwable e) {
        String msg =
          "Erro na recuperao da sesso do usurio " + currentUser
            + " para o projeto " + projectName;
        Server.logSevereMessage(msg, e);
        throw new InternalException(OpenDreams.formatMessage(e, msg));
      }
      session = SessionHelper.narrow(obj);
    }
    finally {
      OpenBusService.getInstance().finishCSBaseAccess();
    }
    return session;
  }

  /**
   * Cria uma mensagem formatada com o texto de uma mensagem junto com
   * informaes mais detalhadas sobre a prpria exceo.
   * 
   * @param e a exceo que ocorreu
   * @param msg uma mensagem descritiva do contexto da exceo
   * @return um texto formatado
   */
  public static String formatMessage(Throwable e, String msg) {
    StringBuffer message = new StringBuffer(msg);
    message.append(": " + e.getMessage());
    message.append("\nCaused by:\n");
    StackTraceElement[] stackTrace = e.getStackTrace();
    for (int i = 0; i < stackTrace.length; i++) {
      message.append(stackTrace[i].toString() + "\n");
    }
    return message.toString();
  }
}
