/*
 * $Id$
 */
package csbase.server.services.projectservice;

import java.io.Serializable;

import csbase.logic.FileUpdateNotification.Result;

/**
 * Representa um atualizador de arquivo de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ProjectFileUpdater {
  /**
   * Atualiza um arquivo de projeto.
   * 
   * @param fileLocation A localizao do arquivo.
   * @param userData Informaes relativas ao usurio que est solicitando a
   *        atualizao.
   * @param extraUserData dado extra 
   * 
   * @return O resultado da atualizao.
   */
  Result update(UpdatableFileLocation fileLocation, Serializable userData,
    Serializable extraUserData);
}
