/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.Platform;
import csbase.logic.PlatformInfo;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.PlatformDAO;
import csbase.server.services.administrationservice.PlatformIO;
import java.io.IOException;
import java.util.List;

public class DefaultPlatformDAO
implements PlatformDAO {
    private PlatformIO platformRepository = new PlatformIO();

    @Override
    public Platform createPlatform(PlatformInfo info) throws DAOException {
        Platform platform;
        try {
            platform = this.platformRepository.writeNew(info);
        }
        catch (IOException e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "]";
            throw new DAOException(e, operationInfo);
        }
        if (platform == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "]";
            throw new DAOException("Falha em PlatformIO.writeNew", operationInfo);
        }
        return platform;
    }

    @Override
    public void deletePlatform(Object id) throws DAOException {
        try {
            this.platformRepository.delete(id);
        }
        catch (IOException e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public Platform modifyPlatform(Object id, PlatformInfo info) throws DAOException {
        Platform platform;
        try {
            platform = this.platformRepository.write(id, info);
        }
        catch (IOException e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "] - para o usu\u00e1rio: " + id;
            throw new DAOException(e, operationInfo);
        }
        if (platform == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "] - para o usu\u00e1rio: " + id;
            throw new DAOException("Falha em PlatformIO.write", operationInfo);
        }
        return platform;
    }

    @Override
    public List<Platform> readAllPlatforms() throws DAOException {
        try {
            return this.platformRepository.readAll();
        }
        catch (IOException e) {
            throw new DAOException(e);
        }
    }

    @Override
    public Platform readPlatform(Object id) throws DAOException {
        try {
            return this.platformRepository.read(id);
        }
        catch (IOException e) {
            throw new DAOException(e, "id: " + id);
        }
    }
}

