/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sharedobjectservice;

import csbase.exception.ServiceFailureException;
import csbase.logic.SharedObject;
import csbase.logic.User;
import csbase.remote.SharedObjectServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import tecgraf.javautils.core.io.FileUtils;

public class SharedObjectService
extends Service
implements SharedObjectServiceInterface {
    public static final String OBJECTS_SUBDIR_NAME = "shared-objects";
    private static final String CATEGORY = "category";
    private static final String OWNER_USER_ID = "ownerUserId";
    private static final String NAME = "name";
    private static final String ALLOWED_READING_USERS_ID = "allowedUsersId";
    private static final String ALLOWED_WRITING_USERS_ID = "allowedWritingUsersId";
    private static final String CREATED = "created";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String CONTENTS = "contents";
    private static final String GLOBAL = "global";
    private FileTree catsTree;
    private Hashtable<String, Hashtable<Object, Hashtable<Object, SharedObject>>> catsTable;
    private Hashtable<String, Hashtable<Object, SharedObject>> globalTable;

    public static void createService() throws ServerException {
        new SharedObjectService();
    }

    protected SharedObjectService() throws ServerException {
        super("SharedObjectService");
    }

    public static SharedObjectService getInstance() {
        return (SharedObjectService)SharedObjectService.getInstance("SharedObjectService");
    }

    private Object readObjectFrom(File soFile, ContentType contentType, boolean throwException) {
        if (!soFile.exists()) {
            return null;
        }
        Object o = null;
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(soFile)));){
            for (int n = contentType.contentIndex; n > 0; --n) {
                o = in.readObject();
            }
        }
        catch (Exception e) {
            if (throwException) {
                String msg = String.format("Erro ao ler shared object %s [%s]", SharedObjectService.debugFileToString(soFile), contentType.name());
                throw new ServiceFailureException(msg, (Throwable)e);
            }
            Server.logSevereMessage("Erro ao ler: " + soFile.getPath(), e);
            return null;
        }
        return o;
    }

    private static String debugFileToString(File soFile) {
        String[] pathComponents = soFile.getPath().split(File.separator);
        int last = pathComponents.length - 1;
        return String.format("%s > %s > %s", pathComponents[last - 2], pathComponents[last - 1], pathComponents[last]);
    }

    private static String debugSOToString(SharedObject so) {
        return String.format("%s > %s > %s", so.getCategory(), SharedObject.getUserId((Object)so.getId()), so.getName());
    }

    private Hashtable<String, Object> sharedObject2Hash(SharedObject object) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        table.put(CATEGORY, object.getCategory());
        table.put(OWNER_USER_ID, object.getOwnerUserId());
        table.put(NAME, object.getName());
        table.put(ALLOWED_READING_USERS_ID, object.getUsersRO());
        table.put(ALLOWED_WRITING_USERS_ID, object.getUsersRW());
        table.put(CREATED, object.getCreated());
        table.put(LAST_MODIFIED, object.getLastModified());
        table.put(GLOBAL, new Boolean(object.isGlobal()));
        return table;
    }

    private SharedObject hash2SharedObject(Hashtable<?, ?> table) {
        SharedObject object = null;
        try {
            String category = (String)table.get(CATEGORY);
            Object ownerUserId = table.get(OWNER_USER_ID);
            String name = (String)table.get(NAME);
            Object[] allowedReadingUsersId = (Object[])table.get(ALLOWED_READING_USERS_ID);
            Object[] allowedWritingUsersId = (Object[])table.get(ALLOWED_WRITING_USERS_ID);
            if (allowedWritingUsersId == null) {
                allowedWritingUsersId = new Object[]{};
            }
            boolean global = (Boolean)table.get(GLOBAL);
            object = new SharedObject(category, ownerUserId, name, global, allowedReadingUsersId, allowedWritingUsersId, null);
            object.setCreated((Date)table.get(CREATED));
            object.setLastModified((Date)table.get(LAST_MODIFIED));
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na convers\u00e3o.", e);
            return null;
        }
        return object;
    }

    private void unregisterSharedObject(Hashtable<?, ?> usrsTable, Object userId, Object id, SharedObject object) {
        Hashtable objsTable = (Hashtable)usrsTable.get(userId);
        if (objsTable == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o cadastrado: " + userId);
        }
        objsTable.remove(id);
    }

    private void unregisterSharedObject(SharedObject object) {
        Hashtable<Object, Hashtable<Object, SharedObject>> usrsTable;
        if (object.isGlobal()) {
            this.unregisterGlobalObject(object);
        }
        if ((usrsTable = this.catsTable.get(object.getCategory())) == null) {
            throw new ServiceFailureException("Categoria n\u00e3o cadastrada: " + object.getCategory());
        }
        Object id = object.getId();
        this.unregisterSharedObject(usrsTable, object.getOwnerUserId(), id, object);
        Object[] usersId = object.getAllUsers();
        for (int i = 0; i < usersId.length; ++i) {
            this.unregisterSharedObject(usrsTable, usersId[i], id, object);
        }
    }

    private void unregisterGlobalObject(SharedObject object) {
        Hashtable<Object, SharedObject> objsTable = this.globalTable.get(object.getCategory());
        if (objsTable == null) {
            throw new ServiceFailureException("Categoria n\u00e3o cadastrada: " + object.getCategory());
        }
        Object id = object.getId();
        objsTable.remove(id);
    }

    private void registerSharedObject(Hashtable<Object, Hashtable<Object, SharedObject>> usrsTable, Object userId, SharedObject object) {
        Object id;
        SharedObject oldObject;
        Hashtable<Object, Object> objsTable = usrsTable.get(userId);
        if (objsTable == null) {
            objsTable = new Hashtable();
            usrsTable.put(userId, objsTable);
        }
        if ((oldObject = (SharedObject)objsTable.get(id = object.getId())) != null && userId.equals(oldObject.getOwnerUserId())) {
            this.unregisterSharedObject(oldObject);
        }
        objsTable.put(id, object);
    }

    private void registerSharedObject(SharedObject object) {
        Hashtable<Object, Hashtable<Object, Object>> usrsTable = this.catsTable.get(object.getCategory());
        if (usrsTable == null) {
            usrsTable = new Hashtable();
            this.catsTable.put(object.getCategory(), usrsTable);
        }
        Object objectOwner = object.getOwnerUserId();
        this.registerSharedObject(usrsTable, objectOwner, object);
        Object[] usersId = object.getAllUsers();
        for (int i = 0; i < usersId.length; ++i) {
            if (usersId[i].equals(objectOwner)) continue;
            this.registerSharedObject(usrsTable, usersId[i], object);
        }
        if (object.isGlobal()) {
            this.registerGlobalObject(object);
        }
    }

    private void registerGlobalObject(SharedObject object) {
        Hashtable<Object, Object> objsTable = this.globalTable.get(object.getCategory());
        if (objsTable == null) {
            objsTable = new Hashtable();
            this.globalTable.put(object.getCategory(), objsTable);
        }
        Object id = object.getId();
        objsTable.put(id, object);
    }

    private void readSharedObjectsStructure(File rootDir) {
        this.catsTable = new Hashtable();
        this.globalTable = new Hashtable();
        File[] catFiles = rootDir.listFiles();
        for (int i = 0; i < catFiles.length; ++i) {
            if (!catFiles[i].isDirectory()) {
                catFiles[i].delete();
                continue;
            }
            File[] usrFiles = catFiles[i].listFiles();
            boolean catUsed = false;
            for (int j = 0; j < usrFiles.length; ++j) {
                block16: {
                    if (!usrFiles[j].isDirectory()) {
                        usrFiles[j].delete();
                        continue;
                    }
                    String userName = usrFiles[j].getName();
                    try {
                        if (User.getUserByLogin((String)userName) == null) {
                            Server.logWarningMessage(String.format("categoria=%s: usuario %s inexistente. Removendo objetos...", catFiles[i].getName(), userName));
                            if (this.deleteUserDir(usrFiles[j])) continue;
                            Server.logWarningMessage("Erro removendo objetos de " + userName);
                        }
                        break block16;
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Erro em User.getUser para " + userName, e);
                    }
                    continue;
                }
                File[] objFiles = usrFiles[j].listFiles();
                boolean usrUsed = false;
                for (int k = 0; k < objFiles.length; ++k) {
                    User owner;
                    SharedObject object;
                    block17: {
                        if (!objFiles[k].isFile()) {
                            objFiles[k].delete();
                            continue;
                        }
                        Object o = this.readObjectFrom(objFiles[k], ContentType.HASHTABLE, false);
                        if (!(o instanceof Hashtable)) {
                            Server.logWarningMessage("Arquivo " + objFiles[k] + " n\u00e3o possui Hashtable: " + o);
                            continue;
                        }
                        Hashtable table = (Hashtable)o;
                        object = this.hash2SharedObject(table);
                        if (object == null) {
                            Server.logWarningMessage("Arquivo " + objFiles[k] + " possui Hashtable incorreta.");
                            continue;
                        }
                        owner = null;
                        Object ownerId = object.getOwnerUserId();
                        try {
                            owner = User.getUser((Object)ownerId);
                            if (owner == null) {
                                Server.logWarningMessage(String.format("Desconsiderando %s: usuario inexistente (%s)", objFiles[k], ownerId.toString()));
                            }
                            break block17;
                        }
                        catch (Exception e) {
                            Server.logSevereMessage("Erro em User.getUser para " + objFiles[k], e);
                        }
                        continue;
                    }
                    if (!object.getCategory().equals(catFiles[i].getName())) {
                        Server.logWarningMessage(String.format("categoria incorreta [%s]: registrada=%s real=%s. Removendo arquivo...", objFiles[k], object.getCategory(), catFiles[i].getName()));
                        objFiles[k].delete();
                        continue;
                    }
                    this.catsTree.putFile(object.getCategory(), catFiles[i]);
                    FileTree usrsTree = this.catsTree.getTree(object.getCategory());
                    usrsTree.putFile(owner.getLogin(), usrFiles[j]);
                    FileTree objsTree = usrsTree.getTree(owner.getLogin());
                    objsTree.putFile(object.getName(), objFiles[k]);
                    this.registerSharedObject(object);
                    usrUsed = true;
                }
                if (!usrUsed) {
                    usrFiles[j].delete();
                    continue;
                }
                catUsed = true;
            }
            if (catUsed) continue;
            catFiles[i].delete();
        }
    }

    private boolean deleteUserDir(File userDir) {
        File[] objectFiles;
        for (File file : objectFiles = userDir.listFiles()) {
            if (file.delete()) continue;
            return false;
        }
        return userDir.delete();
    }

    @Override
    public void initService() throws ServerException {
        Server server = Server.getInstance();
        String persistDirPath = server.getPersistencyRootDirectoryName();
        String sep = File.separator;
        String objectsDirPath = this.getRootPath();
        Server.checkDirectory(objectsDirPath);
        File rootDir = this.getRootDir();
        this.catsTree = new FileTree(rootDir, 3);
        this.readSharedObjectsStructure(rootDir);
    }

    private String getRootPath() {
        Server server = Server.getInstance();
        String persistDirPath = server.getPersistencyRootDirectoryName();
        String sep = File.separator;
        String objectsDirPath = persistDirPath + sep + OBJECTS_SUBDIR_NAME;
        return objectsDirPath;
    }

    private File getRootDir() {
        File rootDir = new File(this.getRootPath());
        return rootDir;
    }

    @Override
    public void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    private File getSharedObjectFile(SharedObject object, boolean checkOwner) {
        User user = Service.getUser();
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        if (checkOwner && !user.getId().equals(object.getOwnerUserId())) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o \u00e9 dono do objeto.");
        }
        FileTree usrsTree = this.catsTree.getTree(object.getCategory());
        User ownerUser = null;
        try {
            ownerUser = User.getUser((Object)object.getOwnerUserId());
        }
        catch (Exception e) {
            throw new ServiceFailureException("N\u00e3o foi poss\u00edvel obter o usu\u00e1rio dono do objeto.", (Throwable)e);
        }
        FileTree objsTree = usrsTree.getTree(ownerUser.getLogin());
        return objsTree.getFile(object.getName());
    }

    private synchronized void writeSharedObjectFile(SharedObject so) {
        File objFile = this.getSharedObjectFile(so, false);
        objFile.getParentFile().mkdirs();
        try (ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(objFile)));){
            out.writeObject(this.sharedObject2Hash(so));
            out.writeObject(so.getContents());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao gravar: " + objFile.getPath(), e);
            throw new ServiceFailureException("Erro ao gravar shared object: " + SharedObjectService.debugSOToString(so), (Throwable)e);
        }
    }

    private Object readSharedObjectContent(SharedObject object) {
        return this.readObjectFrom(this.getSharedObjectFile(object, false), ContentType.CONTENT, true);
    }

    private synchronized void removeSharedObjectFile(SharedObject object) {
        User user = Service.getUser();
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        FileTree usrsTree = this.catsTree.getTree(object.getCategory());
        FileTree objsTree = usrsTree.getTree(user.getLogin());
        objsTree.remove(object.getName());
        if (objsTree.isEmpty()) {
            usrsTree.remove(user.getLogin());
        }
        if (usrsTree.isEmpty()) {
            this.catsTree.remove(object.getCategory());
        }
    }

    private SharedObject getSharedObjectRef(String category, Object userId, String name) {
        Hashtable<Object, Hashtable<Object, SharedObject>> usrsTable = this.catsTable.get(category);
        if (usrsTable == null) {
            return null;
        }
        Hashtable<Object, SharedObject> objsTable = usrsTable.get(userId);
        if (objsTable == null) {
            return null;
        }
        Object id = SharedObject.getId((Object)userId, (String)name);
        SharedObject object = objsTable.get(id);
        return object;
    }

    public SharedObject saveSharedObject(SharedObject object) {
        if (object.getCategory() == null || object.getCategory().isEmpty()) {
            throw new ServiceFailureException("Nome de categoria inv\u00e1lido.");
        }
        if (object.getName() == null || object.getName().isEmpty()) {
            throw new ServiceFailureException("Nome de objeto inv\u00e1lido.");
        }
        if (object.getUsersRO() == null || object.getUsersRW() == null) {
            throw new ServiceFailureException("Lista de usu\u00e1rios nula.");
        }
        if (object.getContents() == null) {
            throw new ServiceFailureException("Objeto vazio (conte\u00fado == null).");
        }
        User callerUser = Service.getUser();
        if (callerUser == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        SharedObject oldObject = this.getSharedObjectRef(object.getCategory(), object.getOwnerUserId(), object.getName());
        if (oldObject == null) {
            object.setCreated(new Date());
            object.setOwnerUserId(callerUser.getId());
            object.setLastModified(object.getCreated());
        } else {
            if (!oldObject.userHasAccessRW(callerUser.getId())) {
                throw new ServiceFailureException("Usu\u00e1rio n\u00e3o tem permiss\u00e3o de escrita.");
            }
            object.setCreated(oldObject.getCreated());
            object.setLastModified(new Date());
        }
        this.writeSharedObjectFile(object);
        object.setContents(null);
        this.registerSharedObject(object);
        return object;
    }

    public void removeSharedObject(String category, String name) {
        User user = Service.getUser();
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        SharedObject object = this.getSharedObjectRef(category, user.getId(), name);
        if (object == null) {
            return;
        }
        this.unregisterSharedObject(object);
        this.removeSharedObjectFile(object);
    }

    public SharedObject[] getSharedObjectAttributes(String category) {
        Hashtable<Object, SharedObject> objsTable;
        Hashtable<Object, Hashtable<Object, SharedObject>> usrsTable;
        User user = Service.getUser();
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        Hashtable<Object, SharedObject> resultTable = new Hashtable<Object, SharedObject>();
        Hashtable<Object, SharedObject> globalObjsTable = this.globalTable.get(category);
        if (globalObjsTable != null) {
            resultTable.putAll(globalObjsTable);
        }
        if ((usrsTable = this.catsTable.get(category)) != null && (objsTable = usrsTable.get(user.getLogin())) != null) {
            resultTable.putAll(objsTable);
        }
        SharedObject[] result = new SharedObject[resultTable.size()];
        int i = 0;
        Enumeration e = resultTable.elements();
        while (e.hasMoreElements()) {
            result[i++] = (SharedObject)e.nextElement();
        }
        return result;
    }

    public SharedObject getSharedObject(String category, Object userId, String name) {
        User user = Service.getUser();
        if (user == null) {
            throw new ServiceFailureException("Usu\u00e1rio n\u00e3o identificado.");
        }
        SharedObject object = this.getSharedObjectRef(category, userId, name);
        if (object == null) {
            return null;
        }
        if (!object.isGlobal() && !user.getId().equals(object.getOwnerUserId())) {
            boolean allowedUser = false;
            Object[] usersId = object.getAllUsers();
            for (int i = 0; i < usersId.length; ++i) {
                if (!user.getId().equals(usersId[i])) continue;
                allowedUser = true;
                break;
            }
            if (!allowedUser) {
                return null;
            }
        }
        String cat = object.getCategory();
        Object ownerUserId = object.getOwnerUserId();
        String resultName = object.getName();
        Object[] allowedReadingUsersId = new Object[object.getUsersRO().length];
        for (int i = 0; i < allowedReadingUsersId.length; ++i) {
            allowedReadingUsersId[i] = object.getUsersRO()[i];
        }
        Object[] allowedWritingUsersId = new Object[object.getUsersRW().length];
        for (int i = 0; i < allowedWritingUsersId.length; ++i) {
            allowedWritingUsersId[i] = object.getUsersRW()[i];
        }
        boolean global = object.isGlobal();
        Object content = this.readSharedObjectContent(object);
        SharedObject result = new SharedObject(cat, ownerUserId, resultName, global, allowedReadingUsersId, allowedWritingUsersId, content);
        result.setCreated(object.getCreated());
        result.setLastModified(object.getLastModified());
        return result;
    }

    public boolean removeAllFromUser(Object userId) {
        String login = (String)userId;
        File rootDir = this.getRootDir();
        File[] catFiles = rootDir.listFiles();
        boolean shrRemoved = true;
        for (int i = 0; i < catFiles.length; ++i) {
            File[] usrFiles = catFiles[i].listFiles();
            for (int j = 0; j < usrFiles.length; ++j) {
                String fileName = usrFiles[j].getName();
                if (!login.equalsIgnoreCase(fileName)) continue;
                String fmt = "categoria=%s: usuario %s remo\u00e7\u00e3o de dados do usu\u00e1rio. Removendo objetos...";
                Server.logInfoMessage(String.format("categoria=%s: usuario %s remo\u00e7\u00e3o de dados do usu\u00e1rio. Removendo objetos...", catFiles[i].getName(), login));
                if (this.deleteUserDir(usrFiles[j])) continue;
                Server.logWarningMessage("Erro removendo dados shared-obj de " + login);
                shrRemoved = false;
            }
        }
        return shrRemoved;
    }

    private class FileTree {
        private final File root;
        private final int levels;
        private final Hashtable<String, File> name2File;
        private Hashtable<String, FileTree> name2Tree;

        FileTree(File root, int levels) {
            this.root = root;
            this.levels = levels;
            if (levels < 1) {
                throw new ServiceFailureException("N\u00famero de n\u00edveis inv\u00e1lido: " + levels);
            }
            this.name2File = new Hashtable();
            if (levels > 1) {
                this.name2Tree = new Hashtable();
            }
        }

        boolean isEmpty() {
            return this.name2File.isEmpty();
        }

        void remove(String name) {
            File file = this.name2File.get(name);
            this.name2File.remove(name);
            if (this.name2Tree != null) {
                this.name2Tree.remove(name);
            }
            if (!file.delete()) {
                Server.logWarningMessage("Erro ao remover: " + file);
                return;
            }
        }

        void putFile(String name, File file) {
            if (!file.getParentFile().equals(this.root)) {
                throw new ServiceFailureException("Hierarquia incorreta: root=" + this.root + ", child=" + file);
            }
            this.name2File.put(name, file);
        }

        synchronized File getFile(String name) {
            File file = this.name2File.get(name);
            if (file != null) {
                return file;
            }
            String filename = FileUtils.fixDirectoryName((String)name);
            file = new File(this.root, filename);
            int i = 0;
            while (file.exists()) {
                file = new File(this.root, filename + i);
                ++i;
            }
            if (this.levels > 1 && !file.mkdir()) {
                throw new ServiceFailureException("Erro ao criar: " + file);
            }
            this.putFile(name, file);
            return file;
        }

        FileTree getTree(String name) {
            if (this.levels == 1) {
                throw new ServiceFailureException("N\u00edvel folha em " + name);
            }
            FileTree tree = this.name2Tree.get(name);
            if (tree == null) {
                tree = new FileTree(this.getFile(name), this.levels - 1);
                this.name2Tree.put(name, tree);
            }
            return tree;
        }
    }

    private static enum ContentType {
        HASHTABLE(1),
        CONTENT(2);

        private final int contentIndex;

        private ContentType(int contentIndex) {
            this.contentIndex = contentIndex;
        }
    }
}

