/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.ResourceProperty;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.monitors.Monitor;
import csbase.server.services.diagnosticservice.monitors.Validation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractMonitor
implements Monitor {
    protected String resourceName;
    private List<Validation> validationList;
    private List<ResourceProperty> properties;

    public AbstractMonitor(String resourceName) throws ResourceException {
        if (resourceName == null || resourceName.length() == 0) {
            throw new ResourceException("O nome do resource n\u00e3o pode ser null ou vazio: " + resourceName);
        }
        this.resourceName = resourceName;
        this.validationList = new LinkedList<Validation>();
        this.properties = new LinkedList<ResourceProperty>();
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public synchronized void addValidation(Validation validation) {
        if (validation == null) {
            throw new NullPointerException();
        }
        this.validationList.add(validation);
    }

    @Override
    public synchronized void addValidation(int pos, Validation validation) {
        try {
            this.validationList.add(pos, validation);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void cleanProperties() {
        this.properties.clear();
    }

    @Override
    public synchronized void addProperty(String name, String value, String source) {
        this.properties.add(new ResourceProperty(name, value, source));
    }

    @Override
    public synchronized Status checkResource(Locale locale) throws ResourceException {
        StatusCode result = StatusCode.OK;
        HashMap<String, ValidationStatus> validationResult = new HashMap<String, ValidationStatus>();
        LinkedList<ValidationStatus> validationStatusList = new LinkedList<ValidationStatus>();
        for (Validation validation : this.validationList) {
            String[] requires = validation.requires();
            if (requires != null) {
                boolean dependenciesAreOk = true;
                for (String id : requires) {
                    if (validationResult.get(id) != null && ((ValidationStatus)validationResult.get((Object)id)).code == StatusCode.OK) continue;
                    dependenciesAreOk = false;
                    break;
                }
                if (!dependenciesAreOk) continue;
            }
            ValidationStatus validationStatus = validation.check(locale);
            if (validationStatus.code.equals((Object)StatusCode.ERROR)) {
                result = StatusCode.ERROR;
            }
            if (validationStatus.code.equals((Object)StatusCode.WARNING) && !result.equals((Object)StatusCode.ERROR)) {
                result = StatusCode.WARNING;
            }
            validationStatusList.add(validationStatus);
            validationResult.put(validation.id(), validationStatus);
        }
        return new Status(this.resourceName, result, validationStatusList.toArray(new ValidationStatus[0]), this.properties);
    }
}

