/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.openbus;

import csbase.exception.OperationFailureException;
import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csbase.server.services.openbusservice.OpenBusService;
import java.util.Locale;
import scs.core.ComponentId;
import scs.core.IComponent;

public class OfferIdValidation
implements Validation {
    public static final String NAME = "OfferIdValidation";
    private ComponentId component;
    private String offerId;

    public OfferIdValidation(ComponentId component) {
        this.component = component;
    }

    @Override
    public ValidationStatus check(Locale locale) {
        this.offerId = OpenBusService.getInstance().getRegisteredComponentBusId(this.component);
        boolean isPublished = false;
        if (this.offerId != null) {
            isPublished = this.checkByOfferId();
        }
        if (isPublished) {
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.offermonitor.no.offer.with.id.error", new String[]{this.offerId}, locale));
        }
        return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.offermonitor.offer.with.id.success", new String[]{this.offerId}, locale));
    }

    private boolean checkByOfferId() {
        IComponent service;
        try {
            service = OpenBusService.getInstance().findServiceById(this.offerId);
        }
        catch (OperationFailureException e) {
            return false;
        }
        return service != null;
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return new String[]{"RegistryServiceValidation"};
    }
}

