/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.loginservice;

import csbase.exception.CSBaseException;
import csbase.logic.ServerMonitor;
import csbase.logic.ServerURI;
import csbase.remote.ServerEntryPoint;
import csbase.server.Server;
import java.util.Hashtable;
import java.util.Map;

public final class ReferedServerCache {
    private static ReferedServerCache instance = null;
    private final int maxRetries = 3;
    private final Map<ServerURI, ServerMonitor> referedServers = new Hashtable<ServerURI, ServerMonitor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Map<ServerURI, ServerMonitor> map = this.referedServers;
        synchronized (map) {
            for (ServerMonitor monitor : this.referedServers.values()) {
                try {
                    monitor.stopMonitoring();
                }
                catch (Throwable t) {
                    ServerURI uri = monitor.getURI();
                    Server.logSevereMessage("Erro finalizando monitora\u00e7\u00e3o de " + uri, t);
                }
            }
            this.referedServers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServerEntryPoint getServer(ServerURI serverURI) throws CSBaseException {
        ServerMonitor monitor = null;
        Map<ServerURI, ServerMonitor> map = this.referedServers;
        synchronized (map) {
            monitor = this.referedServers.get(serverURI);
            if (monitor == null) {
                monitor = new ReferedServerMonitor(serverURI);
                this.referedServers.put(serverURI, monitor);
            }
        }
        if (!monitor.isReachable() && monitor.lookup()) {
            monitor.startMonitoring();
        }
        return monitor.getServer();
    }

    public static ReferedServerCache getInstance() {
        if (instance == null) {
            instance = new ReferedServerCache();
        }
        return instance;
    }

    private ReferedServerCache() {
    }

    private final class ReferedServerMonitor
    extends ServerMonitor {
        protected void logError(String msg, Throwable t) {
            Server.logSevereMessage(msg, t);
        }

        protected void logInfo(String msg) {
            Server.logInfoMessage(msg);
        }

        protected void logWarning(String msg) {
            Server.logWarningMessage(msg);
        }

        public ReferedServerMonitor(ServerURI serverURI) {
            super(serverURI, 3);
        }
    }
}

