/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.exception.OperationFailureException;
import csbase.logic.CapacityType;
import csbase.logic.ClientSGAFile;
import csbase.logic.CommandInfo;
import csbase.logic.CommandInfoCache;
import csbase.logic.CommandStatus;
import csbase.logic.FailureFinalizationType;
import csbase.logic.SGAInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.eventlogservice.EventLogService;
import csbase.server.services.sgaservice.Command;
import csbase.server.services.sgaservice.ProjectNotFoundException;
import csbase.server.services.sgaservice.SGAService;
import csbase.server.services.sgaservice.SGAUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import sgaidl.Pair;
import sgaidl.SGACommand;
import sgaidl.SGAControlAction;
import sgaidl.SGADaemonOperations;
import sgaidl.SGAPath;
import sgaidl.SGAProperties;
import tecgraf.javautils.core.io.FileUtils;

class SGA {
    private static final String EXECUTION_COMMANDS_FILENAME_SUFFIX = "-execution-commands.dat";
    private static final int MILLIS = 1000;
    private static final int NO_DATA = -1;
    private Hashtable<Object, Command> commandTable = null;
    private SGAService sgaService = null;
    private SGAInfo[] info = null;
    private String name = null;
    private String csfsHost;
    private int csfsPort;
    private String[] csfsRootDir;
    private boolean hasDiskAccess;
    private String jobsInfo;
    private boolean isCluster;
    private boolean enabled;
    private boolean watchdog;
    private Map<String, String> sgaProperties;
    private SGADaemonOperations remoteReference;
    private long registerTimestamp;
    private boolean exitAcquisitionDataThread = false;
    private static HashMap<Integer, CapacityType> capacityMap = null;
    private final ExecutorService commandExecutor;
    private long updateTimestamp;

    private void logEvent(String[] queue, String info) {
        EventLogService eventService = EventLogService.getInstance();
        int N = queue.length;
        String[] reQueue = new String[N + 1];
        reQueue[0] = "sga";
        for (int i = 0; i < N; ++i) {
            reQueue[i + 1] = queue[i];
        }
        try {
            eventService.addServerInformation(reQueue, new String[]{info});
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha de log de eventos " + e);
        }
    }

    private void setSGAProperties(SGAProperties sgaProperties) {
        String sgaName = this.name;
        this.sgaProperties = SGAUtils.pairToHashMap(sgaProperties.properties);
        char fileSeparator = this.sgaProperties.get("csbase_file_separator").charAt(0);
        String[] projectRootDirectory = FileUtils.splitPath((String)this.sgaProperties.get("csbase_project_root_directory"), (char)fileSeparator);
        String[] algorithmRootDirectory = FileUtils.splitPath((String)this.sgaProperties.get("csbase_algorithm_root_directory"), (char)fileSeparator);
        String[] sandboxRootDirectory = FileUtils.splitPath((String)this.sgaProperties.get("csbase_sandbox_root_directory"), (char)fileSeparator);
        Pair[][] nodesProps = sgaProperties.nodesProperties;
        SGAInfo[] infoTmp = new SGAInfo[nodesProps.length];
        if (infoTmp.length > 1) {
            Server.logInfoMessage("Recebeu dados est\u00e1ticos dos n\u00f3s de: " + sgaName);
        }
        for (int i = 0; i < nodesProps.length; ++i) {
            HashMap<String, String> properties = SGAUtils.pairToHashMap(nodesProps[i]);
            String nodeName = (String)properties.get("csbase_name");
            String platformId = (String)properties.get("csbase_platform_id");
            int numProcessors = Integer.parseInt((String)properties.get("csbase_num_processors"));
            int memoryRam = (int)Double.parseDouble((String)properties.get("csbase_memory_ram_info_mb"));
            int memorySwap = (int)Double.parseDouble((String)properties.get("csbase_memory_swap_info_mb"));
            int clockSpeed = (int)Double.parseDouble((String)properties.get("csbase_clock_speed_mhz"));
            Server.logInfoMessage("Recebeu dados est\u00e1ticos de: " + nodeName);
            infoTmp[i] = new SGAInfo(nodeName, platformId, numProcessors, memoryRam, memorySwap, clockSpeed, fileSeparator, projectRootDirectory, algorithmRootDirectory, sandboxRootDirectory, properties);
            int resourcescounter = 1;
            while (properties.containsKey("csbase_resources." + resourcescounter)) {
                infoTmp[i].addRequirement((String)properties.get("csbase_resources." + resourcescounter));
                ++resourcescounter;
            }
        }
        this.info = infoTmp;
    }

    private void setCSFSProperties() throws ServerException {
        String csfsHostString = this.sgaProperties.get("csbase_csfs_host");
        String csfsPortString = this.sgaProperties.get("csbase_csfs_port");
        String csfsRootDirString = this.sgaProperties.get("csbase_csfs_root_dir");
        try {
            this.csfsHost = csfsHostString == null || csfsHostString.length() == 0 ? null : csfsHostString;
            if (csfsPortString != null && csfsPortString.length() != 0) {
                this.csfsPort = Integer.parseInt(csfsPortString);
            }
            Server.logInfoMessage("Obtendo o endere\u00e7o do CSFS para " + this.name + ": " + this.csfsHost + ":" + this.csfsPort);
        }
        catch (Exception e) {
            this.setAlive(false);
            throw new ServerException("Falha na obten\u00e7\u00e3o do endere\u00e7o do CSFS de : " + this.name, e);
        }
        try {
            this.csfsRootDir = csfsRootDirString == null || csfsRootDirString.length() == 0 ? null : FileUtils.splitPath((String)csfsRootDirString);
            Server.logInfoMessage("Obtendo o CSFSRootDir para " + this.name + " : " + this.csfsRootDir);
        }
        catch (Exception e) {
            this.setAlive(false);
            throw new ServerException("Falha na obten\u00e7\u00e3o do CSFSRootDir de : " + this.name, e);
        }
    }

    public void setTransferRate(long transferRate) {
        this.info[0].setTransferRate(transferRate);
    }

    public void updateSGAInfo(SGAProperties dynamicInfo) {
        this.sgaProperties = SGAUtils.pairToHashMap(dynamicInfo.properties);
        String hasDiskAccessStr = this.sgaProperties.get("csbase_has_disk_access");
        this.hasDiskAccess = hasDiskAccessStr != null && hasDiskAccessStr.equals("csbase_true");
        this.jobsInfo = this.sgaProperties.get("csbase_jobs_info");
        this.sgaService.logSGAMessage("Recebeu dados din\u00e2micos: " + this.getName());
        for (int i = 0; i < dynamicInfo.nodesProperties.length; ++i) {
            int number_of_jobs;
            SGAInfo myinfo = this.info[i];
            HashMap<String, String> data = SGAUtils.pairToHashMap(dynamicInfo.nodesProperties[i]);
            double memory_ram_free_perc = data.get("csbase_memory_ram_free_perc").isEmpty() ? 0.0 : Double.parseDouble(data.get("csbase_memory_ram_free_perc"));
            double memory_swap_free_perc = data.get("csbase_memory_swap_free_perc").isEmpty() ? 0.0 : Double.parseDouble(data.get("csbase_memory_swap_free_perc"));
            double loadAvg1min = data.get("csbase_load_avg_1min_perc").isEmpty() ? 0.0 : Double.parseDouble(data.get("csbase_load_avg_1min_perc"));
            double loadAvg5min = data.get("csbase_load_avg_5min_perc").isEmpty() ? 0.0 : Double.parseDouble(data.get("csbase_load_avg_5min_perc"));
            double loadAvg15min = data.get("csbase_load_avg_15min_perc").isEmpty() ? 0.0 : Double.parseDouble(data.get("csbase_load_avg_15min_perc"));
            int n = number_of_jobs = data.get("csbase_number_of_jobs").isEmpty() ? 0 : Integer.parseInt(data.get("csbase_number_of_jobs"));
            if (memory_ram_free_perc < 0.0 && memory_swap_free_perc < 0.0 && loadAvg1min < 0.0) {
                myinfo.setAlive(false);
            } else {
                myinfo.setAlive(true);
            }
            myinfo.setRAMFreeMemory(memory_ram_free_perc);
            myinfo.setSwapFreeMemory(memory_swap_free_perc);
            myinfo.setCPULoad(loadAvg1min, loadAvg5min, loadAvg15min);
            myinfo.setNumberOfJobs(number_of_jobs);
        }
        this.updateTimestamp = System.currentTimeMillis();
        this.sgaService.logSGAInfo(this.info, "(Recebido do SGA)");
    }

    public String getCSFSHost() {
        return this.csfsHost;
    }

    public int getCSFSPort() {
        return this.csfsPort;
    }

    public String[] getRemoteRootDir() {
        return this.csfsRootDir;
    }

    public List<ClientSGAFile> getChildren(String path) {
        ArrayList<ClientSGAFile> children = new ArrayList<ClientSGAFile>();
        try {
            for (SGAPath pathInfo : this.remoteReference.getPaths(path)) {
                ClientSGAFile file = this.buildClientSGAFile(pathInfo);
                if (file == null) continue;
                children.add(file);
            }
        }
        catch (Exception e) {
            String f = "Erro ao obter as informa\u00e7\u00f5es (sga: %s, path: %s, erro: %s)";
            Server.logSevereMessage(String.format(f, this.name, path, e.getMessage()));
        }
        return children;
    }

    public ClientSGAFile getFile(String path) {
        if (path == null) {
            return null;
        }
        try {
            SGAPath pathInfo = this.remoteReference.getPath(path);
            return this.buildClientSGAFile(pathInfo);
        }
        catch (Exception e) {
            String f = "Erro ao obter as informa\u00e7\u00f5es (sga: %s, path: %s, erro: %s)";
            Server.logSevereMessage(String.format(f, this.name, path, e.getMessage()));
            return null;
        }
    }

    private ClientSGAFile buildClientSGAFile(SGAPath pathInfo) {
        if (!pathInfo.exists) {
            return null;
        }
        String separator = String.valueOf(this.info[0].getFileSeparator());
        ClientSGAFile file = new ClientSGAFile(this.name, pathInfo.path);
        file.setSeparator(separator);
        file.setDir(pathInfo.isDir);
        file.setSymbolicLink(pathInfo.isSymbolicLink);
        file.setCanRead(pathInfo.readable);
        file.setCanWrite(pathInfo.writable);
        file.setCanExecute(pathInfo.executable);
        file.setSize((long)pathInfo.sizeKB * 1024L);
        return file;
    }

    final SGAInfo getInfo(int index) {
        return this.info[index];
    }

    final SGAInfo getInfo(String hostname) {
        if (hostname == null) {
            return null;
        }
        for (SGAInfo node : this.info) {
            if (!hostname.equals(node.getHostName())) continue;
            return node;
        }
        return null;
    }

    final SGAInfo[] getAllInfo() {
        return this.info;
    }

    final int getNumNodes() {
        return this.info.length;
    }

    void stop() {
        String sgaName = this.getName();
        this.exitAcquisitionDataThread = true;
        Server.logInfoMessage("Terminando:" + sgaName);
        this.sgaService = null;
    }

    private void logTriggeredEvent(String eventName) {
        String sgaName = this.getName();
        String[] queue = new String[]{sgaName, "events"};
        this.logEvent(queue, eventName);
    }

    synchronized void shutdownSGA() throws ServerException {
        this.logTriggeredEvent("shutdown");
        String sgaName = this.getName();
        Server.logWarningMessage("Shutdown para:" + sgaName);
        this.resetWatchDog();
        try {
            this.remoteReference.control(SGAControlAction.SHUTDOWN);
        }
        catch (Exception e) {
            throw new ServerException("Falha na desativa\u00e7\u00e3o do SGA " + this.name, e);
        }
        finally {
            this.setAlive(false);
        }
    }

    final synchronized void restartSGA() throws ServerException {
        this.logTriggeredEvent("restart");
        String sgaName = this.getName();
        Server.logWarningMessage("Restart para:" + sgaName);
        try {
            this.remoteReference.control(SGAControlAction.RESTART);
        }
        catch (Exception e) {
            throw new ServerException("Falha na reativa\u00e7\u00e3o do SGA " + this.name, e);
        }
        finally {
            this.setAlive(false);
        }
    }

    final boolean getEnabled() {
        return this.enabled;
    }

    final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    final String getName() {
        return this.name;
    }

    final String getPlatformId() {
        return this.info[0].getPlatformId();
    }

    final boolean isPlatformSupported(Vector<String> platform) {
        for (SGAInfo node : this.info) {
            String nodePlatform = node.getPlatformId();
            if (!platform.contains(nodePlatform)) continue;
            return true;
        }
        return false;
    }

    final String getHostOfPlatform(Vector<String> plats) {
        for (SGAInfo node : this.info) {
            String platform = node.getPlatformId();
            if (!plats.contains(platform)) continue;
            return node.getHostName();
        }
        return null;
    }

    final long getCapacity(CapacityType capacityType) {
        return this.info[0].getCapacity(capacityType);
    }

    final boolean getWatchDog() {
        return this.watchdog;
    }

    final void patWatchDog() {
        this.watchdog = true;
    }

    final void resetWatchDog() {
        this.watchdog = false;
    }

    final boolean isAlive() {
        return this.remoteReference != null;
    }

    final void setAlive(boolean alive) {
        if (alive) {
            return;
        }
        this.remoteReference = null;
        for (SGAInfo node : this.info) {
            node.setAlive(false);
        }
    }

    final boolean hasDiskAccess() {
        return this.hasDiskAccess;
    }

    final String getJobsInfo() {
        return this.jobsInfo;
    }

    public boolean mayExecuteCommand() {
        return this.isAlive() && this.getEnabled() && this.hasDiskAccess();
    }

    final boolean isCluster() {
        return this.isCluster;
    }

    final synchronized boolean ping() {
        try {
            this.remoteReference.ping();
            this.setAlive(true);
        }
        catch (Exception e) {
            this.setAlive(false);
        }
        return this.isAlive();
    }

    final SGADaemonOperations getSGADaemon() {
        return this.remoteReference;
    }

    final synchronized void setRemoteReference(SGADaemonOperations reference) {
        this.remoteReference = reference;
    }

    final synchronized void logAuditEvents() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("000.000");
        df.setDecimalFormatSymbols(dfs);
        int numNodes = this.info.length;
        String sgaName = this.getName();
        for (int i = 0; i < numNodes; ++i) {
            String hName = this.info[i].getHostName();
            String[] cpuQueue = new String[]{sgaName, hName, "cpu-usage"};
            double cpu = this.info[i].getCPULoad1();
            this.logEvent(cpuQueue, df.format(cpu));
            String[] ramQueue = new String[]{sgaName, hName, "ram-usage"};
            double ram = 100.0 - this.info[i].getRAMFreeMemory();
            this.logEvent(ramQueue, df.format(ram));
            String[] swpQueue = new String[]{sgaName, hName, "swp-usage"};
            double swp = 100.0 - this.info[i].getSwapFreeMemory();
            this.logEvent(swpQueue, df.format(swp));
        }
    }

    final synchronized void logAlgorithmHistoryEvents() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("000.000");
        df.setDecimalFormatSymbols(dfs);
        int numNodes = this.info.length;
        String sgaName = this.getName();
        for (int i = 0; i < numNodes; ++i) {
            Enumeration<Command> eCmds = this.commandTable.elements();
            while (eCmds.hasMoreElements()) {
                Command cmd = eCmds.nextElement();
                try {
                    CommandInfo cmdInfo = cmd.createCommandInfo();
                    AlgorithmConfigurator algoConfigurator = cmdInfo.getConfigurator();
                    StringBuffer parametersString = new StringBuffer();
                    HashMap parameterTable = (HashMap)algoConfigurator.getParameterValuesByName();
                    for (String key : parameterTable.keySet()) {
                        parametersString.append(key + "=" + (String)parameterTable.get(key) + " ");
                    }
                    String algorithmName = algoConfigurator.getAlgorithmName();
                    String algorithmVersion = algoConfigurator.getAlgorithmVersionId().toString();
                    String[] historyQueue = new String[]{sgaName, "historic", algorithmName + "-" + algorithmVersion + "-"};
                    double cpuPerc = cmdInfo.getCpuPerc() == null ? -1.0 : cmdInfo.getCpuPerc();
                    double swapPerc = cmdInfo.getSwapMemoryPerc() == null ? -1.0 : cmdInfo.getSwapMemoryPerc();
                    double userTime = cmdInfo.getUserTimeSec() == null ? -1.0 : cmdInfo.getUserTimeSec();
                    double systemTime = cmdInfo.getSystemTimeSec() == null ? -1.0 : cmdInfo.getSystemTimeSec();
                    double ramMemory = cmdInfo.getRAMMemoryMB() == null ? -1.0 : cmdInfo.getRAMMemoryMB();
                    double virtualMemory = cmdInfo.getVirtualMemorySizeMB() == null ? -1.0 : cmdInfo.getVirtualMemorySizeMB();
                    double bytesIn = cmdInfo.getBytesInKB() == null ? -1.0 : cmdInfo.getBytesInKB();
                    double bytesOut = cmdInfo.getBytesOutKB() == null ? -1.0 : cmdInfo.getBytesOutKB();
                    double diskBytesRead = cmdInfo.getDiskBytesReadKB() == null ? -1.0 : cmdInfo.getDiskBytesReadKB();
                    double diskBytesWrite = cmdInfo.getDiskBytesWriteKB() == null ? -1.0 : cmdInfo.getDiskBytesWriteKB();
                    double cpuLoad = this.getCPULoad1();
                    double freeRamMemory = this.getRAMFreeMemory();
                    double cpuCapacity = this.getCapacity(CapacityType.CPU);
                    double diskReadCapacity = this.getCapacity(CapacityType.DISK_READ);
                    double diskWriteCapacity = this.getCapacity(CapacityType.DISK_WRITE);
                    double netCapacity = this.getCapacity(CapacityType.NET);
                    String information = cmd.getId() + "; " + cmd.getUserId().toString() + "; " + parametersString + "; " + df.format(cpuLoad) + "; " + df.format(freeRamMemory) + "; " + df.format(cpuCapacity) + "; " + df.format(diskReadCapacity) + "; " + df.format(diskWriteCapacity) + "; " + df.format(netCapacity) + "; " + df.format(cpuPerc) + "; " + df.format(ramMemory) + "; " + df.format(swapPerc) + "; " + df.format(userTime) + "; " + df.format(systemTime) + "; " + df.format(virtualMemory) + "; " + df.format(bytesIn) + "; " + df.format(bytesOut) + "; " + df.format(diskBytesRead) + "; " + df.format(diskBytesWrite);
                    this.logEvent(historyQueue, information);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Falha na aquisi\u00e7\u00e3o do configurador de comando!", e);
                }
            }
        }
    }

    final double getCPULoad1() {
        return this.info[0].getCPULoad1();
    }

    final double getRAMFreeMemory() {
        return 100.0 - this.info[0].getRAMFreeMemory();
    }

    final Command getCommand(Object cmdId) {
        return this.commandTable.get(cmdId);
    }

    final Command[] getAllCommands() {
        return this.commandTable.values().toArray(new Command[0]);
    }

    synchronized void executeCommand(String hostName, CommandInfo cmd, long expirationInfoDelay, boolean asScript, boolean logCommandLineInfo) throws ProjectNotFoundException {
        final Object userId = Service.getUser().getId();
        final Command command = new Command(hostName, this, cmd, expirationInfoDelay, asScript, logCommandLineInfo);
        final String commId = command.getId();
        this.commandTable.put(commId, command);
        this.saveCommandTable();
        this.commandExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Service.setUserId(userId);
                    command.executeRemoteCommand();
                }
                catch (Throwable e) {
                    Server.logSevereMessage("Erro na execu\u00e7\u00e3o do comando " + commId, e);
                    e.printStackTrace();
                }
                finally {
                    Service.setUserId(null);
                }
            }
        });
    }

    protected void saveCommandTable() {
        ObjectOutput output = null;
        try {
            output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.getBackupFileName())));
            output.writeObject(this.commandTable);
        }
        catch (OperationFailureException ex) {
            Server.logSevereMessage("Erro na valida\u00e7\u00e3o do diret\u00f3rio de persist\u00eancia de comandos.", ex);
        }
        catch (IOException ex) {
            Server.logSevereMessage("Erro ao gravar a tabela de comandos.", ex);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException ex) {
                Server.logSevereMessage("Erro ao fechar stream de grava\u00e7\u00e3o da tabela de hist\u00f3rico.", ex);
            }
        }
    }

    final synchronized boolean commandRetrieved(Object cmdId, SGACommand cmdReference) {
        Command command = this.getCommand(cmdId);
        if (command != null) {
            command.setRemoteReference(cmdReference);
            return true;
        }
        Server.logSevereMessage("Imposs\u00edvel recuperar comando (" + cmdId + ")");
        return false;
    }

    final synchronized boolean killCommand(Object cmdId) {
        Command command = this.getCommand(cmdId);
        if (command != null) {
            if (!command.kill()) {
                return false;
            }
            this.commandTable.remove(cmdId);
            this.saveCommandTable();
        } else {
            Server.logSevereMessage("Imposs\u00edvel finalizar comando (" + cmdId + ")!");
        }
        return true;
    }

    final synchronized void killCommandAnyway(Object cmdId) {
        Command command = this.getCommand(cmdId);
        if (command == null) {
            return;
        }
        command.kill();
        this.commandTable.remove(cmdId);
        this.saveCommandTable();
    }

    final synchronized void failCommand(Object cmdId, FailureFinalizationType cause) {
        Command command = this.getCommand(cmdId);
        switch (cause) {
            case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                CommandInfo info = command.getCommandInfo();
                info.setStatus(CommandStatus.SCHEDULED);
                this.commandTable.remove(cmdId);
                this.saveCommandTable();
                if (info.isAutomatic()) {
                    info.setSGAName(null);
                }
                return;
            }
        }
        if (command != null) {
            this.commandTable.remove(cmdId);
            command.failed(cause);
            this.saveCommandTable();
            this.sgaService.handleCommandInitFailure(command);
        } else {
            Server.logSevereMessage("Comando nao encontrado (" + cmdId + ")!");
        }
    }

    final synchronized void lostCommand(String cmdId) {
        Command command = this.getCommand(cmdId);
        if (command != null) {
            this.commandTable.remove(cmdId);
            command.lost();
            this.saveCommandTable();
        } else {
            Server.logSevereMessage("Comando nao encontrado (" + cmdId + ")!");
        }
    }

    final synchronized void finishCommand(String cmdId) {
        if (this.commandTable.remove(cmdId) != null) {
            this.saveCommandTable();
        } else {
            Server.logSevereMessage("Imposs\u00edvel finalizar comando (" + cmdId + ")!");
        }
    }

    final void updateSGA(SGADaemonOperations reference, SGAProperties properties) throws ServerException {
        this.logTriggeredEvent("re-register");
        this.remoteReference = reference;
        this.registerTimestamp = System.currentTimeMillis();
        this.setSGAProperties(properties);
        this.watchdog = true;
        this.enabled = true;
        this.hasDiskAccess = true;
        this.isCluster = this.info.length > 1;
        Enumeration<Command> eCmds = this.commandTable.elements();
        while (eCmds.hasMoreElements()) {
            Command cmd = eCmds.nextElement();
            cmd.setRemoteReference(null);
        }
        this.setCSFSProperties();
    }

    SGA(SGAService srv, String sgaName, SGADaemonOperations reference, SGAProperties sgaProperties, int cmdExecPoolSize) throws ServerException {
        this.remoteReference = reference;
        this.registerTimestamp = System.currentTimeMillis();
        this.sgaService = srv;
        this.name = sgaName;
        this.setSGAProperties(sgaProperties);
        this.logTriggeredEvent("register");
        this.watchdog = true;
        this.enabled = true;
        this.isCluster = this.info.length > 1;
        this.hasDiskAccess = true;
        this.jobsInfo = null;
        this.loadCommandTable();
        try {
            reference.ping();
        }
        catch (Exception e) {
            this.setAlive(false);
            throw new ServerException("Falha na comunica\u00e7\u00e3o com o SGA: " + this.name, e);
        }
        this.setCSFSProperties();
        this.createCommandDataAcquisitionThread();
        this.commandExecutor = Executors.newFixedThreadPool(cmdExecPoolSize);
    }

    private long updateCommands() {
        Command[] sgaCmds;
        long minupdate = Long.MAX_VALUE;
        for (Command cmd : sgaCmds = this.getAllCommands()) {
            try {
                if (!cmd.isAlive()) continue;
                cmd.update();
                long nupdates = cmd.getNUpdates();
                minupdate = Math.min(minupdate, nupdates);
            }
            catch (ServerException e) {
                String message = e.getMessage();
                Server.logSevereMessage(message, e);
            }
        }
        return minupdate;
    }

    private void createCommandDataAcquisitionThread() {
        int STEP_SECONDS = 2;
        int sgaCommandUpdateInterval = this.sgaService.getCommandsUpdateInterval();
        final long updateSleepTime = sgaCommandUpdateInterval * 1000;
        Thread acquisitionCommandDataThread = new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        if (SGA.access$000(SGA.this)) {
                            Server.logWarningMessage("Finalizando thread de aquisi\u00e7\u00e3o de dados de comandos...");
                            return;
                        }
                        stepSleepTime = 0x7FFFFFFFFFFFFFFFL;
                        ntimes = SGA.access$100(SGA.this);
                        if (ntimes != 0x7FFFFFFFFFFFFFFFL) {
                            stepSleepTime = (ntimes + 1L) * 2L * 1000L;
                        }
                        stepSleepTime = Math.min(stepSleepTime, updateSleepTime);
                        try {
                            Thread.sleep(stepSleepTime);
                        }
                        catch (InterruptedException ie) {
                            Server.logWarningMessage("Aquisi\u00e7\u00e3o de dados de Comandos SGA interrompido!");
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    msg = new Date() + " - Erro na aquisi\u00e7\u00e3o de dados de comandos:";
                    System.err.println(msg);
                    t.printStackTrace(System.err);
                    Server.logSevereMessage(msg, t);
                }
                ** GOTO lbl-1000
            }
        });
        this.exitAcquisitionDataThread = false;
        acquisitionCommandDataThread.setName(this.getClass().getSimpleName() + "::AcquisitionCommandDataThread");
        acquisitionCommandDataThread.start();
    }

    private void createNewCommandTable() {
        this.commandTable = new Hashtable();
        this.saveCommandTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCommandTable() {
        CommandInfoCache.enable();
        Hashtable table = null;
        ObjectInput input = null;
        try {
            File file = new File(this.getBackupFileName());
            if (!file.exists()) {
                this.createNewCommandTable();
                return;
            }
            input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            table = (Hashtable)input.readObject();
            try {
                Iterator entries = table.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    Command command = (Command)entry.getValue();
                    if (command.getStatus() == CommandStatus.SCHEDULED || command.getStatus() == CommandStatus.INIT || command.getStatus() == CommandStatus.UPLOADING) {
                        entries.remove();
                        continue;
                    }
                    Service.setUserId(command.getUserId());
                    command.setService(this.sgaService);
                    command.setSGA(this);
                }
            }
            finally {
                Service.setUserId(null);
            }
            this.commandTable = table;
        }
        catch (OperationFailureException ex) {
            Server.logSevereMessage("Erro na valida\u00e7\u00e3o do diret\u00f3rio de persist\u00eancia de comandos.", ex);
            this.createNewCommandTable();
            return;
        }
        catch (IOException ex) {
            Server.logSevereMessage("Erro ao ler a tabela de comandos.", ex);
            this.createNewCommandTable();
            return;
        }
        catch (ClassNotFoundException ex) {
            Server.logSevereMessage("N\u00e3o foi encontrada nenhuma classe no arquivo especificado.", ex);
            this.createNewCommandTable();
            return;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Server.logSevereMessage("Erro ao fechar stream de leitura da tabela de hist\u00f3rico.", ex);
                this.createNewCommandTable();
                return;
            }
        }
    }

    private String getBackupFileName() throws OperationFailureException {
        return this.sgaService.getCommandsPersistencyDirectoryName() + File.separator + this.name + EXECUTION_COMMANDS_FILENAME_SUFFIX;
    }

    boolean isDir(String path) throws ServerException {
        try {
            SGAPath sgaPath = this.remoteReference.getPath(path);
            if (sgaPath == null) {
                return false;
            }
            return sgaPath.isDir;
        }
        catch (Exception e) {
            this.setAlive(false);
            throw new ServerException("Falha na verifica\u00e7\u00e3o do acesso ao caminho '" + path + "' junto ao SGA " + this.name, e);
        }
    }

    String getProperty(String key) {
        return key == null ? null : this.sgaProperties.get(key);
    }

    public Map<String, String> getAllProperties() {
        return this.sgaProperties;
    }

    public long getRegisterTimestamp() {
        return this.registerTimestamp;
    }

    public long getUpdateTimeStamp() {
        return this.updateTimestamp;
    }

    public boolean hasDataTransferMechanism() {
        return this.sgaProperties.get("csbase_transfer_name") != null || this.getCSFSHost() != null;
    }

    static /* synthetic */ boolean access$000(SGA x0) {
        return x0.exitAcquisitionDataThread;
    }

    static /* synthetic */ long access$100(SGA x0) {
        return x0.updateCommands();
    }
}

