/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.loginservice;

import csbase.logic.User;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class ServerSession {
    private User user;
    private Locale locale;
    private TimeZone timeZone;
    private String app;
    private Map<String, Serializable> properties;
    private Remote control;

    ServerSession(User user, Locale locale) {
        this.user = user;
        this.locale = locale;
        this.timeZone = TimeZone.getDefault();
        this.properties = Collections.synchronizedMap(new HashMap());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperty(String propertyName, Serializable propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void putAllProperties(Map<String, Serializable> newProperties) {
        this.properties.putAll(newProperties);
    }

    public Map<String, Serializable> getPropertes() {
        return this.properties;
    }

    public Remote getControl() {
        return this.control;
    }

    public void setControl(Remote control) {
        this.control = control;
    }
}

