/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice.v1_02;

import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.projectservice.v1_02.ProjectDataService;
import scs.core.ComponentContext;
import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.hierarchical.v1_02.IHierarchicalNavigationDataServicePOA;

public class IHierarchicalNavigationDataServiceServant
extends IHierarchicalNavigationDataServicePOA {
    private final ComponentContext context;

    public IHierarchicalNavigationDataServiceServant(ComponentContext context) {
        this.context = context;
    }

    public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure, DataNotFound, DataAccessDenied, InvalidDataKey {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getChildren(fKey);
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription getParent(byte[] fKey) throws ServiceFailure, DataNotFound, DataAccessDenied, InvalidDataKey {
        Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription dataDescription = service.getParent(fKey);
            return dataDescription;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }

    public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
        String userId = OpenBusService.getInstance().getRequesterUserId();
        Service.setUserId(userId);
        try {
            ProjectDataService service = ProjectDataService.getInstance();
            DataDescription[] dataDescriptionArray = service.getRoots();
            return dataDescriptionArray;
        }
        catch (RuntimeException e) {
            Server.logSevereMessage(e.getMessage(), e);
            throw new ServiceFailure();
        }
        finally {
            Service.setUserId(null);
        }
    }
}

