/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.classadpolicies;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdManager;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdMatchInfo;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdPolicyCommons;
import csbase.server.services.schedulerservice.heuristic.ResourceControllerInterface;
import java.util.LinkedList;
import java.util.List;

public class ClassAdResourceController
implements ResourceControllerInterface {
    ClassAdManager manager = new ClassAdManager();

    @Override
    public SGASet simulateResourceConsumption(CommandInfo cmd, SGASet server) {
        SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceConsumption(cmd, server);
        this.manager.alterSGAAd(updatedSGA);
        return updatedSGA;
    }

    @Override
    public SGASet undoResourceConsumptionSimulation(CommandInfo cmd, SGASet server) {
        SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceRelease(cmd, server);
        this.manager.alterSGAAd(updatedSGA);
        return updatedSGA;
    }

    @Override
    public List<SGASet> getServersThatMeetsRequirements(CommandInfo cmd, List<SGASet> servers) {
        LinkedList<SGASet> matchedSGAs = new LinkedList<SGASet>();
        List<ClassAdMatchInfo> infos = ClassAdPolicyCommons.getMatchedAds(cmd, servers, this.manager);
        for (ClassAdMatchInfo info : infos) {
            matchedSGAs.add(info.getSGA());
        }
        return matchedSGAs;
    }

    @Override
    public List<CommandInfo> getPossibleCommands(List<CommandInfo> commands, SGASet server) {
        List<ClassAdMatchInfo> matches = ClassAdPolicyCommons.getMatchedAds(commands, server, this.manager);
        LinkedList<CommandInfo> cmds = new LinkedList<CommandInfo>();
        for (ClassAdMatchInfo info : matches) {
            cmds.add(info.getCommand());
        }
        return cmds;
    }
}

