/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.logic.SecureKey;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.projectservice.FileLockInterface;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

class SharedFileLock
implements FileLockInterface {
    private final List<SessionReference> lockList = new ArrayList<SessionReference>();

    SharedFileLock(SecureKey sessionKey, Object id) {
        this.newLocker(sessionKey, id);
    }

    @Override
    public int getLockRefCount(SecureKey sessionKey) {
        int refCount = 0;
        ArrayList<SessionReference> cleanupList = new ArrayList<SessionReference>();
        for (SessionReference sessionReference : this.lockList) {
            if (sessionReference.serverRequested) {
                if (sessionKey != null) continue;
                ++refCount;
                continue;
            }
            SecureKey skey = (SecureKey)sessionReference.sessionKeyRef.get();
            if (skey == null) {
                cleanupList.add(sessionReference);
                continue;
            }
            if (!skey.equals((Object)sessionKey)) continue;
            ++refCount;
        }
        this.lockList.removeAll(cleanupList);
        return refCount;
    }

    @Override
    public int getLockRefCount() {
        this.removeExpired();
        return this.lockList.size();
    }

    @Override
    public boolean hasExpired() {
        this.removeExpired();
        return this.lockList.isEmpty();
    }

    private void removeExpired() {
        ArrayList<SessionReference> cleanupList = new ArrayList<SessionReference>();
        for (SessionReference sessionRef : this.lockList) {
            SecureKey ref;
            if (sessionRef.serverRequested || (ref = (SecureKey)sessionRef.sessionKeyRef.get()) != null && LoginService.getInstance().getUserByKey(ref) != null) continue;
            cleanupList.add(sessionRef);
        }
        this.lockList.removeAll(cleanupList);
    }

    @Override
    public FileLockInterface.LockStatus checkLockStatus(SecureKey sessionKey) {
        return this.checkLockStatus(sessionKey.toString());
    }

    private SessionReference findSessionRef(Object lockId) {
        for (SessionReference sessionRef : this.lockList) {
            if (!sessionRef.id.equals(lockId)) continue;
            return sessionRef;
        }
        return null;
    }

    @Override
    public boolean newLocker(SecureKey sessionKey, Object lockId) {
        this.removeExpired();
        if (sessionKey == null) {
            this.lockList.add(new SessionReference(lockId));
        } else {
            this.lockList.add(new SessionReference(new WeakReference<SecureKey>(sessionKey), lockId));
        }
        return true;
    }

    @Override
    public boolean removeLocker(Object lockId) {
        SessionReference ref = this.findSessionRef(lockId);
        if (ref == null) {
            return false;
        }
        this.lockList.remove(ref);
        return true;
    }

    @Override
    public boolean isShared() {
        return true;
    }

    @Override
    public FileLockInterface.LockStatus checkLockStatus(String sessionKey) {
        this.removeExpired();
        for (SessionReference sessionRef : this.lockList) {
            SecureKey ref;
            if (!(sessionRef.serverRequested ? sessionKey == null : (ref = (SecureKey)sessionRef.sessionKeyRef.get()).toString().equals(sessionKey))) continue;
            return FileLockInterface.LockStatus.LOCKED_BY_USER;
        }
        if (this.lockList.isEmpty()) {
            return FileLockInterface.LockStatus.UNLOCKED;
        }
        return FileLockInterface.LockStatus.LOCKED_BY_OTHERS;
    }

    Object[] getIds() {
        Object[] ids = new Object[this.lockList.size()];
        for (int i = 0; i < this.lockList.size(); ++i) {
            ids[i] = this.lockList.get((int)i).id;
        }
        return ids;
    }

    private class SessionReference {
        Object id;
        boolean serverRequested;
        WeakReference<SecureKey> sessionKeyRef;

        SessionReference(WeakReference<SecureKey> sessionKeyRef, Object id) {
            this.id = id;
            this.sessionKeyRef = sessionKeyRef;
            this.serverRequested = false;
        }

        SessionReference(Object id) {
            this.id = id;
            this.serverRequested = true;
        }
    }
}

