/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.restservice;

import csbase.exception.ParseException;
import csbase.logic.ExternalUser;
import csbase.logic.Role;
import csbase.logic.UserInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.administrationservice.AdministrationService;
import csbase.server.services.loginservice.LoginService;
import csbase.server.services.mailservice.MailService;
import csbase.server.services.restservice.RestService;
import ibase.common.v2.NotFoundException;
import ibase.common.v2.User;
import ibase.exception.v2.InternalServiceException;
import ibase.rest.api.authentication.v2.adapter.AuthenticationService;
import ibase.rest.api.authentication.v2.adapter.UnauthorizedException;
import ibase.rest.api.authentication.v2.adapter.UserAlreadyExistsException;
import ibase.rest.api.authentication.v2.adapter.UserNotFoundException;
import java.rmi.RemoteException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CSBaseAuthenticationServiceImpl
implements AuthenticationService {
    private static final String ADMIN_USER = "admin";
    public static final String ATTRIBUTE_USER_EMAIL = "userEmail";
    public static final String ATTRIBUTE_USER_NAME = "userName";
    public static final String ATTRIBUTE_USER_PASSWORD = "userPassword";

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public String parserToken(String token, Map<String, Object> attributes) throws ibase.rest.api.authentication.v2.adapter.ParseException {
        RestService restService = RestService.getInstance();
        try {
            String userId = restService.parserToken(token, attributes);
            if (userId != null) {
                Service.setUserId(new ExternalUser(userId, ExternalUser.ExternalAuthMechanism.REST));
            }
            return userId;
        }
        catch (ParseException e) {
            throw new ibase.rest.api.authentication.v2.adapter.ParseException(e.getMessage());
        }
    }

    public User login(String login, String password) throws UnauthorizedException {
        csbase.logic.User user = LoginService.getInstance().checkLogin(login, password);
        if (user == null) {
            throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.login.error"));
        }
        return new User(user.getLogin(), user.getName(), Arrays.asList(user.getEmails()), Arrays.asList(user.getRoleIds()), null);
    }

    public User acceptNewUser(String userToken) throws UnauthorizedException {
        RestService restService = RestService.getInstance();
        try {
            Hashtable attributes = new Hashtable();
            String userId = restService.parserToken(userToken, attributes);
            String login = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            String email = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            String name = (String)attributes.get(ATTRIBUTE_USER_NAME);
            String password = (String)attributes.get(ATTRIBUTE_USER_PASSWORD);
            AdministrationService adminService = AdministrationService.getInstance();
            csbase.logic.User user = adminService.getUser(login);
            if (user == null) {
                this.createGuestUser(login, name, email, password);
                Object[] roleIds = new Object[]{this.getVisitorRole()};
                return new User(login, name, Arrays.asList(email), Arrays.asList(roleIds), null);
            }
            throw new UnauthorizedException(RestService.getInstance().getFormattedString("RestService.unauthorized.newuser.error", new Object[]{login}));
        }
        catch (ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public User updateUser(User user) throws UnauthorizedException, NotFoundException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            csbase.logic.User csbaseUser = administrationService.getUser(user.login);
            if (csbaseUser == null) {
                User user2 = null;
                return user2;
            }
            String[] currentEmails = csbaseUser.getEmails();
            user.emails.addAll(Arrays.asList(currentEmails));
            UserInfo userInfo = new UserInfo(csbaseUser.getUserInfo().getAttributes());
            userInfo.setAttribute("name", (Object)user.name);
            userInfo.setAttribute("emails", (Object)user.emails.toArray(new String[0]));
            userInfo.setAttribute("photoLink", (Object)user.avatarURL);
            administrationService.modifyUser(user.login, userInfo);
            User user3 = user;
            return user3;
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    public User acceptNewPassword(String userToken, String password) throws UnauthorizedException {
        RestService restService = RestService.getInstance();
        try {
            Hashtable attributes = new Hashtable();
            String userId = restService.parserToken(userToken, attributes);
            String login = (String)attributes.get(ATTRIBUTE_USER_EMAIL);
            AdministrationService adminService = AdministrationService.getInstance();
            csbase.logic.User user = adminService.getUser(login);
            if (user == null) {
                throw new UnauthorizedException(RestService.getInstance().getFormattedString("RestService.unauthorized.newuser.error", new Object[]{login}));
            }
            this.changeUserPassword(login, password);
            return new User(login, user.getName(), Arrays.asList(user.getEmails()), Arrays.asList(user.getRoleIds()), null);
        }
        catch (ParseException e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    public String createToken(String userId, Map<String, Object> attributes, Date expirationDate, Date issuedDate) throws UnauthorizedException {
        try {
            AdministrationService administrationService = AdministrationService.getInstance();
            RestService restService = RestService.getInstance();
            return restService.createToken(userId, attributes, expirationDate, issuedDate);
        }
        catch (Throwable e) {
            throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.login.error"));
        }
    }

    public String createToken(String userId, Map<String, Object> attributes, Date expirationDate) throws UnauthorizedException {
        Instant now = Instant.now();
        return this.createToken(userId, attributes, expirationDate, Date.from(now));
    }

    public void validateNewUserByEmail(String name, String email, String link) throws UnauthorizedException, UserAlreadyExistsException {
        try {
            csbase.logic.User user = csbase.logic.User.getUserByEmail((String)email);
            if (user != null) {
                throw new UserAlreadyExistsException("There is already an user registered with this email.");
            }
            String systemName = Server.getInstance().getSystemName();
            String msg = RestService.getInstance().getFormattedString("RestService.newuser.validation.message", new Object[]{name, systemName, link});
            MailService service = MailService.getInstance();
            String[] recipient = new String[]{email};
            boolean sendEmail = service.sendMail(null, recipient, msg);
            if (!sendEmail) {
                throw new UnauthorizedException(RestService.getInstance().getString("RestService.unauthorized.email.send.error"));
            }
        }
        catch (UserAlreadyExistsException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServiceException(e);
        }
    }

    public void validateNewPasswordByEmail(String email, String link) throws UserNotFoundException, UnauthorizedException {
        try {
            csbase.logic.User user = csbase.logic.User.getUserByEmail((String)email);
            if (user == null) {
                String msg = RestService.getInstance().getFormattedString("RestService.user.not.found", new Object[]{email});
                throw new UserNotFoundException(msg);
            }
            String systemName = Server.getInstance().getSystemName();
            String msg = RestService.getInstance().getFormattedString("RestService.newpassword.validation.message", new Object[]{user.getName(), systemName, link});
            MailService service = MailService.getInstance();
            String[] recipient = new String[]{email};
            boolean sendEmail = service.sendMail(null, recipient, msg);
            if (!sendEmail) {
                throw new InternalServiceException(RestService.getInstance().getString("RestService.unauthorized.email.send.error"));
            }
        }
        catch (UserNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServiceException(e);
        }
    }

    public void notifySupport(String content) {
        MailService service = MailService.getInstance();
        try {
            service.mailSupport(content);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean userExists(String userId) {
        AdministrationService adminService = AdministrationService.getInstance();
        csbase.logic.User user = adminService.getUser(userId);
        return user != null;
    }

    private void createGuestUser(String login, String name, String email, String password) throws UnauthorizedException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            Object roleId = this.getVisitorRole();
            if (roleId == null) {
                throw new UnauthorizedException(RestService.getInstance().getString("RestService.no.visitor.role.login.error"));
            }
            Instant now = Instant.now();
            UserInfo newUserInfo = new UserInfo(login, name, new String[]{email}, new Object[]{roleId}, null, now.toEpochMilli());
            newUserInfo.setAttribute("password", (Object)password);
            administrationService.createUser(newUserInfo);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    private void changeUserPassword(String login, String password) throws UnauthorizedException {
        try {
            Service.setUserId(ADMIN_USER);
            AdministrationService administrationService = AdministrationService.getInstance();
            csbase.logic.User user = administrationService.getUser(login);
            UserInfo userInfo = new UserInfo(user.getUserInfo().getAttributes());
            userInfo.setAttribute("password", (Object)password);
            long current = Calendar.getInstance().getTimeInMillis();
            userInfo.setAttribute("lastPasswordUpdate", (Object)new Long(current));
            userInfo.setAttribute("lastUpdate", (Object)new Long(current));
            administrationService.modifyUser(login, userInfo);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        finally {
            Service.setUserId(null);
        }
    }

    private Object getVisitorRole() {
        Service.setUserId(ADMIN_USER);
        AdministrationService administrationService = AdministrationService.getInstance();
        List<Role> allRoles = administrationService.getAllRoles();
        for (Role r : allRoles) {
            if (!r.getName().equals("VISITOR_ROLE")) continue;
            return r.getId();
        }
        return null;
    }
}

