/**
 * $Id: SGAAuthorization.java 163065 2015-03-27 18:41:34Z fpina $
 */
package csbase.server.services.sgaservice.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.Map;

/**
 *
 *
 * @author Tecgraf/PUC-Rio
 */
public class SGAAuthorization {
  private static final String CERT_TYPE = "X.509";

  /**
   * Mapa com os SGAs autorizados a conectar no servidor CSBase.
   */
  private Map<String, Certificate> authorizedSGAs;

  /**
   * Mapa com os SGAs autenticados atravs do protocolo TLS/SSL.
   */
  private Map<String, Certificate> authenticatedSGAs;

  /**
   * A instncia.
   */
  private static SGAAuthorization instance;

  /**
   * Construtor.
   */
  private SGAAuthorization() {
    authorizedSGAs = new Hashtable<String, Certificate>();
    authenticatedSGAs = new Hashtable<String, Certificate>();
  }

  /**
   * Recupera a instncia (singleton) desta classe.
   *
   * @return a instncia
   */
  public static synchronized SGAAuthorization getInstance() {
    if (instance == null) {
      instance = new SGAAuthorization();
    }
    return instance;
  }

  public void addSGACertificate(String name, String certificateFile)
    throws FileNotFoundException, CertificateException {
    FileInputStream fis = new FileInputStream(certificateFile);
    CertificateFactory cf = CertificateFactory.getInstance(CERT_TYPE);
    authorizedSGAs.put(name, cf.generateCertificate(fis));
  }

  public void validateSGA(String name, Certificate certificate) {
    synchronized (authenticatedSGAs) {
      if (authorizedSGAs.containsKey(name)) {
        authenticatedSGAs.put(name, certificate);
      }
    }
  }

  public boolean checkSGA(String name) {
    if (!authorizedSGAs.containsKey(name)) {
      return false;
    }

    synchronized (authenticatedSGAs) {
      if (!authenticatedSGAs.containsKey(name)) {
        return false;
      }
      Certificate cert = authenticatedSGAs.remove(name);
      return cert.equals(authorizedSGAs.get(name));
    }
  }

}
