package csbase.server.services.schedulerservice.classadpolicies;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;

public class ClassAdPolicy1 implements SchedulerPolicyInterface {

	/*
	 * Primeira implementao de chooseServer: escolhe o melhor SGA (Segundo o
	 * rank) para casa comando, na ordem em que aparecem na lista commands
	 */
	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {
		ClassAdManager manager = new ClassAdManager();
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
		for (CommandInfo cmd : commands) {
			List<SGASet> sgas;

			sgas = ClassAdPolicyCommons.getSGAsSortedByDefaultClassAdRank(cmd,
					servers, manager);

			if (sgas.size() != 0)
				allocation.put(cmd, sgas.get(0));
		}
		return allocation;
	}

}
