package csbase.server.services.schedulerservice.classadpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;

public class ClassAdPolicy5 implements SchedulerPolicyInterface {
	/*
	 * Quinta implementao de chooseServer: escolhe o melhor SGA (Segundo o
	 * rank) para casa comando, na ordem em que aparecem na lista ordenada
	 * segundo o CommandGreedinessComparator e simula utilizao de memria do
	 * SGA.
	 */

	public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands,
			List<SGASet> servers) {

		ClassAdManager manager = new ClassAdManager();
		HashMap<String, SGASet> originalServers = new HashMap<String, SGASet>();
		List<SGASet> simulatedServers = new ArrayList<SGASet>(servers);
		Map<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();

		for (SGASet sga : servers) {
			originalServers.put(sga.getName(), sga);
		}
		Collections.sort(commands,
				Collections.reverseOrder(new CommandGreedinessComparator()));

		for (CommandInfo cmd : commands) {
			List<SGASet> sgas;

			sgas = ClassAdPolicyCommons.getSGAsSortedByDefaultClassAdRank(cmd,
					servers, manager);

			if (sgas.isEmpty())
				continue;
			
			SGASet sga = sgas.get(0);
			allocation.put(cmd, originalServers.get(sga));
			SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceConsumption(cmd, sga);
			simulatedServers.remove(sga);
			simulatedServers.add(updatedSGA);
			manager.alterSGAAd(updatedSGA);
		}
		return allocation;
	}
}
