/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v1_06;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.CommonClientProject;
import csbase.logic.ManifestVersion;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.OpenDreamsService;
import csbase.server.services.opendreamsservice.opendreams.v1_06.AlgorithmTemplate;
import csbase.server.services.opendreamsservice.opendreams.v1_06.AlgorithmTemplateException;
import csbase.server.services.opendreamsservice.opendreams.v1_06.JobInfoQueue;
import csbase.server.services.opendreamsservice.opendreams.v1_06.OpenDreams;
import csbase.server.services.opendreamsservice.opendreams.v1_06.Session;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.SchedulerService;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import csbase.util.messages.filters.BodyTypeFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.openbus.DRMAA.v1_06.AlreadyActiveSessionException;
import tecgraf.openbus.DRMAA.v1_06.AuthorizationException;
import tecgraf.openbus.DRMAA.v1_06.DefaultContactStringException;
import tecgraf.openbus.DRMAA.v1_06.DeniedByDrmException;
import tecgraf.openbus.DRMAA.v1_06.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v1_06.DrmsExitException;
import tecgraf.openbus.DRMAA.v1_06.DrmsInitException;
import tecgraf.openbus.DRMAA.v1_06.ExitTimeoutException;
import tecgraf.openbus.DRMAA.v1_06.InternalException;
import tecgraf.openbus.DRMAA.v1_06.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v1_06.InvalidContactStringException;
import tecgraf.openbus.DRMAA.v1_06.InvalidJobException;
import tecgraf.openbus.DRMAA.v1_06.InvalidJobTemplateException;
import tecgraf.openbus.DRMAA.v1_06.JobInfo;
import tecgraf.openbus.DRMAA.v1_06.JobState;
import tecgraf.openbus.DRMAA.v1_06.JobTemplate;
import tecgraf.openbus.DRMAA.v1_06.NoActiveSessionException;
import tecgraf.openbus.DRMAA.v1_06.NoDefaultContactStringSelectedException;
import tecgraf.openbus.DRMAA.v1_06.OutOfMemoryException;
import tecgraf.openbus.DRMAA.v1_06.TryLaterException;
import tecgraf.openbus.DRMAA.v1_06.Version;
import tecgraf.openbus.opendreams.v1_06.OpenDreamsJobTemplate;
import tecgraf.openbus.opendreams.v1_06.OpenDreamsJobTemplateImpl;

public class OpenDreamsSession
extends Session {
    private CommonClientProject project;
    private String userId;
    private boolean isActive = false;
    private Set<JobTemplate> validJobTemplates;
    private JobInfoQueue jobInfoQueue = new JobInfoQueue();
    private final OpenDreamsService service;
    private Version drmsVersion;
    private String drmsInfo;
    private String drmaaImplementation;
    private String drmsContact;
    private Map<String, OpenDreamsJobTemplate> contexts;
    private Serializable consumerId;

    public OpenDreamsSession() {
        ManifestVersion version = new ManifestVersion(((Object)((Object)this)).getClass());
        this.drmsVersion = new Version(version.getMajorVersion(), version.getMinorVersion());
        this.drmsContact = Server.getInstance().getHostName() + ":" + Server.getInstance().getRegistryPort();
        this.drmsInfo = Server.getInstance().getSystemName();
        this.drmaaImplementation = Server.getInstance().getSystemName() + " " + version.getVersionName();
        this.service = OpenDreamsService.getInstance();
        this.contexts = new Hashtable<String, OpenDreamsJobTemplate>();
        this.registerListener();
    }

    @Override
    public void init(String contactString) throws DefaultContactStringException, NoDefaultContactStringSelectedException, InvalidArgumentException, AlreadyActiveSessionException, InternalException, DrmsInitException, AuthorizationException, DrmCommunicationException, InvalidContactStringException, OutOfMemoryException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: init (" + contactString + ")");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (contactString != null && !contactString.equals("") && !contactString.equals(this.drmsContact)) {
                throw new InvalidContactStringException("N\u00e3o existe um DRMS com nome " + contactString);
            }
            if (this.isActive) {
                throw new AlreadyActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 ativa");
            }
            this.isActive = true;
            this.validJobTemplates = new HashSet<JobTemplate>();
        }
        catch (InvalidContactStringException e) {
            String msg = "Erro na inicializa\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (AlreadyActiveSessionException e) {
            String msg = "Erro na inicializa\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na inicializa\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public void exit() throws OutOfMemoryException, DrmsExitException, AuthorizationException, NoActiveSessionException, InternalException, DrmCommunicationException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: exit");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 fechada");
            }
            this.validJobTemplates.clear();
            this.validJobTemplates = null;
        }
        catch (NoActiveSessionException e) {
            String msg = "Erro na finaliza\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na finaliza\u00e7\u00e3o da sess\u00e3o do usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
            MessageService.getInstance().clearServerMessageListener(this.consumerId);
        }
    }

    @Override
    public JobTemplate createJobTemplate() throws OutOfMemoryException, AuthorizationException, NoActiveSessionException, InternalException, DrmCommunicationException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: createJobTemplate");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 fechada");
            }
            OpenDreamsJobTemplateImpl jt = new OpenDreamsJobTemplateImpl();
            this.validJobTemplates.add((JobTemplate)jt);
            OpenDreamsJobTemplateImpl openDreamsJobTemplateImpl = jt;
            return openDreamsJobTemplateImpl;
        }
        catch (NoActiveSessionException e) {
            String msg = "Erro na cria\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na cria\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public void deleteJobTemplate(JobTemplate jt) throws OutOfMemoryException, InvalidJobTemplateException, AuthorizationException, NoActiveSessionException, InvalidArgumentException, InternalException, DrmCommunicationException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: deleteJobTemplate");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 fechada");
            }
            if (!this.isValidJobTemplate(jt)) {
                throw new InvalidJobTemplateException("N\u00e3o \u00e9 um job template v\u00e1lido");
            }
            this.validJobTemplates.remove(jt);
        }
        catch (NoActiveSessionException e) {
            String msg = "Erro na remo\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (InvalidJobTemplateException e) {
            String msg = "Erro na remo\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (Throwable e) {
            String msg = "Erro na remo\u00e7\u00e3o de um jobtemplate pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public String runJob(JobTemplate jt) throws InvalidArgumentException, InternalException, AuthorizationException, DrmCommunicationException, DeniedByDrmException, InvalidJobTemplateException, NoActiveSessionException, TryLaterException, OutOfMemoryException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: runJob");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (!this.isActive) {
                throw new NoActiveSessionException("A sess\u00e3o j\u00e1 est\u00e1 fechada");
            }
            if (!this.isValidJobTemplate(jt)) {
                throw new InvalidJobTemplateException("N\u00e3o \u00e9 um job template v\u00e1lido");
            }
            if (OpenDreamsJobTemplate.class.isInstance(jt)) {
                String result;
                String string = result = this.execAlgorithm(userId, (OpenDreamsJobTemplate)OpenDreamsJobTemplate.class.cast(jt));
                return string;
            }
            String result = null;
            return result;
        }
        catch (NoActiveSessionException e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (InvalidJobTemplateException e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw e;
        }
        catch (AlgorithmTemplateException e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new DeniedByDrmException(OpenDreams.formatMessage(e, msg));
        }
        catch (Throwable e) {
            String msg = "Erro na submiss\u00e3o do comando pelo usu\u00e1rio " + userId;
            Server.logSevereMessage(msg, e);
            throw new InternalException(OpenDreams.formatMessage(e, msg));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    @Override
    public JobInfo _wait(String jobName, long timeout) throws OutOfMemoryException, AuthorizationException, NoActiveSessionException, ExitTimeoutException, InvalidArgumentException, InternalException, InvalidJobException, DrmCommunicationException {
        String userId = null;
        try {
            Server.logFineMessage("OpenDreamsSession: _wait (" + jobName + ", " + timeout + ")");
            userId = OpenBusService.getInstance().initCSBaseAccess();
            if (jobName.equals("DRMAA_JOB_IDS_SESSION_ANY")) {
                JobInfo jobInfo = this.jobInfoQueue.waitForAnyJob(timeout);
                return jobInfo;
            }
            JobInfo jobInfo = this.jobInfoQueue.waitFor(jobName, timeout);
            return jobInfo;
        }
        catch (ExitTimeoutException e) {
            Server.logSevereMessage("Erro na espara pelo t\u00e9rmino do comando pelo usu\u00e1rio " + userId, e);
            throw e;
        }
        catch (InvalidJobException e) {
            Server.logSevereMessage("Erro na espara pelo t\u00e9rmino do comando pelo usu\u00e1rio " + userId, e);
            throw e;
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na espera pelo t\u00e9rmino do comando pelo usu\u00e1rio " + userId, e);
            throw new InternalException(e.toString());
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobState jobStatus(String jobName) throws OutOfMemoryException, AuthorizationException, NoActiveSessionException, InvalidArgumentException, InternalException, InvalidJobException, DrmCommunicationException {
        Server.logFineMessage("OpenDreamsSession: jobStatus (" + jobName + ")");
        String userId = OpenBusService.getInstance().initCSBaseAccess();
        try {
            JobInfo jobInfo = this.jobInfoQueue.getJobInfo(jobName);
            if (jobInfo.hasExited) {
                JobState jobState = jobInfo.exitStatus == 0 ? JobState.DONE : JobState.FAILED;
                OpenBusService.getInstance().finishCSBaseAccess();
                return jobState;
            }
        }
        catch (InvalidJobException jobInfo) {
            // empty catch block
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do estado do job " + jobName + " pelo usu\u00e1rio " + userId, e);
            throw new InternalException(e.toString());
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        CommandInfo commandInfo = CommandPersistenceService.getInstance().getCommandInfo(this.project.getId(), jobName);
        if (commandInfo == null) {
            throw new InvalidJobException("N\u00e3o foi encontrado um job com o nome especificado: " + jobName);
        }
        CommandStatus status = commandInfo.getStatus();
        if (status == CommandStatus.SCHEDULED) {
            return JobState.QUEUED_ACTIVE;
        }
        if (status == CommandStatus.INIT) return JobState.RUNNING;
        if (status == CommandStatus.UPLOADING) return JobState.RUNNING;
        if (status == CommandStatus.EXECUTING) return JobState.RUNNING;
        if (status == CommandStatus.DOWNLOADING) {
            return JobState.RUNNING;
        }
        if (status != CommandStatus.FINISHED) return JobState.UNDETERMINED;
        CommandFinalizationType finnalizationType = commandInfo.getFinalizationType();
        if (finnalizationType == CommandFinalizationType.UNKNOWN) return JobState.DONE;
        if (finnalizationType == CommandFinalizationType.END) return JobState.DONE;
        if (finnalizationType == CommandFinalizationType.SUCCESS) {
            return JobState.DONE;
        }
        if (finnalizationType == CommandFinalizationType.EXECUTION_ERROR) return JobState.FAILED;
        if (finnalizationType == CommandFinalizationType.FAILED) return JobState.FAILED;
        if (finnalizationType == CommandFinalizationType.KILLED) return JobState.FAILED;
        if (finnalizationType != CommandFinalizationType.NO_EXIT_CODE) return JobState.UNDETERMINED;
        return JobState.FAILED;
    }

    @Override
    public String contact() {
        return this.drmsContact;
    }

    @Override
    public Version version() {
        return this.drmsVersion;
    }

    @Override
    public String drmaaImplementation() {
        return this.drmaaImplementation;
    }

    @Override
    public String drmsInfo() {
        return this.drmsInfo;
    }

    public void setProject(CommonClientProject project) {
        this.project = project;
    }

    public CommonClientProject getProject() {
        return this.project;
    }

    public void setUser(String userId) {
        this.userId = userId;
    }

    private boolean isValidJobTemplate(JobTemplate jt) {
        return this.validJobTemplates.contains(jt);
    }

    private String execAlgorithm(String userId, OpenDreamsJobTemplate jt) throws AlgorithmTemplateException {
        AlgorithmTemplate validator = new AlgorithmTemplate(this.project, userId, jt);
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        if (configurator.getExecutionType().equals((Object)ExecutionType.MULTIPLE)) {
            configurator.setExecutionType(ExecutionType.SIMPLE);
        }
        CommandSubmission submission = new CommandSubmission(configurator, this.project.getId());
        submission.setDescription(jt.jobDescription);
        submission.setPriority(Priority.values()[jt.jobPriority]);
        submission.setEmailList(jt.email);
        submission.setMailAtEnd(!jt.blockEmail);
        Set<CommandInfo> commandInfos = null;
        try {
            commandInfos = SchedulerService.getInstance().submitCommand(submission);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String cmdId = commandInfos.toArray(new CommandInfo[0])[0].getId();
        this.jobInfoQueue.jobSubmited(cmdId);
        this.contexts.put(cmdId, jt);
        return cmdId;
    }

    private void registerListener() {
        MessageService messageService = MessageService.getInstance();
        this.consumerId = messageService.setServerMessageListener(new IMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessagesReceived(Message ... messages) throws Exception {
                for (Message message : messages) {
                    CommandNotification notification = (CommandNotification)message.getBody();
                    String cmdId = (String)notification.getCommandId();
                    OpenDreamsJobTemplate jt = (OpenDreamsJobTemplate)OpenDreamsSession.this.contexts.get(cmdId);
                    if (jt == null) continue;
                    try {
                        Service.setUserId(OpenDreamsSession.this.userId);
                        OpenDreamsSession.this.commandFinished(notification, jt, OpenDreamsSession.this.userId);
                    }
                    catch (Exception e) {
                        Server.logSevereMessage("Erro ao finalizar o comando " + jt.jobName, e);
                    }
                    finally {
                        Service.setUserId(null);
                    }
                }
            }
        }, new BodyTypeFilter(CommandNotification.class));
    }

    private void commandFinished(CommandNotification notification, OpenDreamsJobTemplate template, String userId) {
        try {
            if (template.outputPath != null && !template.outputPath.isEmpty()) {
                String jobId = notification.getCommandId().toString();
                CommandInfo info = CommandPersistenceService.getInstance().getCommandInfo(this.project.getId(), jobId);
                try {
                    Set files = info.getConfigurator().getStandardOutputFiles();
                    this.createOutputFile(userId, files, template.outputPath);
                }
                catch (RemoteException e) {
                    Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do configurador do comando.", e);
                }
            }
        }
        catch (Throwable e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do log de sa\u00edda do comando.", e);
        }
        this.jobInfoQueue.jobExit(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createOutputFile(String userId, Set<FileURLValue> stdOutputFiles, String outputFile) {
        ProjectService projectService = ProjectService.getInstance();
        String[] outputFilePath = FileUtils.splitPath((String)outputFile);
        if (projectService.existsFile(this.project.getId(), outputFilePath)) {
            projectService.removeFile(this.project.getId(), outputFilePath);
        }
        String[] outputDirPath = FileUtils.splitPath((String)FileUtils.getFilePath((String)outputFile));
        String newFileName = FileUtils.getFileName((String)outputFile);
        projectService.createFile(this.project.getId(), outputDirPath, newFileName, "TEXT");
        ClientProjectFile cpf = projectService.getChild(this.project.getId(), outputDirPath, newFileName);
        OutputStream fileTo = null;
        try {
            fileTo = projectService.getOutputStream(this.project.getId(), outputFilePath);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(fileTo));
            for (FileURLValue stdOutputFile : stdOutputFiles) {
                String[] stdOutputFilePath = stdOutputFile.getPathAsArray();
                InputStream fileFrom = null;
                try {
                    if (stdOutputFiles.size() > 1) {
                        printWriter.printf("\n---- %s ----\n", stdOutputFile.getPath());
                    }
                    if (!projectService.existsFile(this.project.getId(), stdOutputFilePath)) continue;
                    fileFrom = projectService.getInputStream(this.project.getId(), stdOutputFilePath);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileFrom));
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        printWriter.println(line);
                        line = bufferedReader.readLine();
                    }
                    printWriter.flush();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro na grava\u00e7\u00e3o do arquivo " + stdOutputFile.getPath() + " em " + cpf.getStringPath(), e);
                }
                catch (Exception e) {
                    Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do inputstream do arquivo " + stdOutputFile.getPath(), e);
                }
                finally {
                    try {
                        if (fileFrom == null) continue;
                        fileFrom.close();
                    }
                    catch (IOException e) {
                        Server.logSevereMessage("Erro no fechamento do inputStream do arquivo " + stdOutputFile.getPath(), e);
                    }
                }
            }
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro na recupera\u00e7\u00e3o do outputsream do arquivo de sa\u00edda " + cpf.getStringPath(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileTo != null) {
                try {
                    fileTo.close();
                }
                catch (IOException e) {
                    Server.logSevereMessage("Erro no fechamento do outputsream do arquivo de sa\u00edda " + cpf.getStringPath(), e);
                }
            }
        }
        return true;
    }
}

