/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.opendreams.v2_0;

import csbase.exception.OperationFailureException;
import csbase.server.Server;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.opendreams.v2_0.InvalidJobTemplateException;
import csbase.server.services.opendreamsservice.opendreams.v2_0.OpenDreamsJob;
import csbase.server.services.schedulerservice.Base32IdGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import tecgraf.openbus.DRMAA.v2_0.DeniedByDrmsException;
import tecgraf.openbus.DRMAA.v2_0.DrmCommunicationException;
import tecgraf.openbus.DRMAA.v2_0.InternalException;
import tecgraf.openbus.DRMAA.v2_0.InvalidArgumentException;
import tecgraf.openbus.DRMAA.v2_0.Job;
import tecgraf.openbus.DRMAA.v2_0.JobArray;
import tecgraf.openbus.DRMAA.v2_0.JobArrayHelper;
import tecgraf.openbus.DRMAA.v2_0.JobArrayOperations;
import tecgraf.openbus.DRMAA.v2_0.JobArrayPOATie;
import tecgraf.openbus.DRMAA.v2_0.JobTemplate;
import tecgraf.openbus.DRMAA.v2_0.UnsupportedOperationException;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplate;
import tecgraf.openbus.opendreams.v2_0.OpenDreamsJobTemplateImpl;

public class OpenDreamsJobArray
implements JobArrayOperations,
Serializable {
    private String jobArrayId;
    private String sessionName;
    private OpenDreamsJobTemplate jt;
    private HashMap<String, OpenDreamsJob> jobs;
    private transient JobArray ref;
    private transient Job[] jobRefs;

    public OpenDreamsJobArray(String sessionName, String userId, OpenDreamsJobTemplate jt) {
        this.sessionName = sessionName;
        this.jt = jt;
        this.jobArrayId = this.generateUniqueId(userId, sessionName);
        this.jobs = new HashMap();
    }

    public String jobArrayId() {
        return this.jobArrayId;
    }

    public OpenDreamsJob getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    public HashMap<String, OpenDreamsJob> jobsMap() {
        return this.jobs;
    }

    public Job[] jobs() {
        if (this.jobRefs == null) {
            int jobCounter = 0;
            this.jobRefs = new Job[this.jobs.entrySet().size()];
            for (Map.Entry<String, OpenDreamsJob> job : this.jobs.entrySet()) {
                try {
                    this.jobRefs[jobCounter++] = job.getValue().corbaObjectReference();
                }
                catch (OperationFailureException | ServantNotActive | WrongPolicy e) {
                    String msg = "Erro ao criar refer\u00eancias do Job " + job.getValue().jobId() + " que pertence ao JobArray " + this.jobArrayId;
                    Server.logSevereMessage(msg, e);
                    e.printStackTrace();
                }
            }
        }
        return this.jobRefs;
    }

    public String sessionName() {
        return this.sessionName;
    }

    public JobTemplate jobTemplate() {
        return this.jt;
    }

    public void execute(String userId, int beginIndex, int endIndex, int step) throws InvalidJobTemplateException, InvalidArgumentException, CloneNotSupportedException, ServantNotActive, WrongPolicy, OperationFailureException {
        System.out.println("Executing JobArray " + this.jobArrayId);
        this.validateIndexes(beginIndex, endIndex, step);
        int numberOfJobs = (endIndex - beginIndex) / step + 1;
        int jobCounter = 0;
        String baseOutputPath = this.jt.outputPath;
        this.jobRefs = new Job[numberOfJobs];
        for (int i = beginIndex; i <= endIndex; i += step) {
            OpenDreamsJobTemplate jtClone = (OpenDreamsJobTemplate)((OpenDreamsJobTemplateImpl)this.jt).clone();
            if (baseOutputPath != null && baseOutputPath.length() > 0) {
                System.out.println(baseOutputPath);
                jtClone.outputPath = baseOutputPath.replaceAll(Pattern.quote("$DRMAA2_INDEX$"), String.valueOf(i));
                jtClone.outputPath = jtClone.outputPath.replaceAll(Pattern.quote("$DRMAA2_N_JOBS$"), String.valueOf(numberOfJobs));
                System.out.println(jtClone.outputPath);
            }
            if (jtClone.jobParameters != null) {
                for (String[] parameters : jtClone.jobParameters) {
                    parameters[1] = parameters[1].replaceAll(Pattern.quote("$DRMAA2_INDEX$"), String.valueOf(i));
                    parameters[1] = parameters[1].replaceAll(Pattern.quote("$DRMAA2_N_JOBS$"), String.valueOf(numberOfJobs));
                }
            }
            OpenDreamsJob job = new OpenDreamsJob(this.sessionName, jtClone);
            job.execute(userId);
            this.jobs.put(job.jobId(), job);
            this.jobRefs[jobCounter++] = job.corbaObjectReference();
        }
    }

    private void validateIndexes(int beginIndex, int endIndex, int step) throws InvalidArgumentException {
        if (beginIndex < 1) {
            throw new InvalidArgumentException("O valor do argumento beginIndex deve ser maior que 1");
        }
        if (beginIndex > endIndex) {
            throw new InvalidArgumentException("O valor do argumento beginIndex deve ser menor ou igual ao valor do argumento endIndex");
        }
        if (step <= 0) {
            throw new InvalidArgumentException("O valor do argumento step deve ser positivo");
        }
    }

    private String generateUniqueId(String userId, String sessionName) {
        return String.format("%s@%s.%s.%s", userId, sessionName, Server.getInstance().getSystemName(), new Base32IdGenerator().generateId());
    }

    public JobArray corbaObjectReference() throws OperationFailureException, ServantNotActive, WrongPolicy {
        POA poa = OpenBusService.getInstance().getRootPOA();
        if (this.ref == null) {
            JobArrayPOATie tie = new JobArrayPOATie((JobArrayOperations)this, poa);
            Object obj = poa.servant_to_reference((Servant)tie);
            this.ref = JobArrayHelper.narrow((Object)obj);
        }
        return this.ref;
    }

    public void suspend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }

    public void resume() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }

    public void hold() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }

    public void release() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }

    public void terminate() throws DrmCommunicationException, DeniedByDrmsException, InternalException {
        for (Map.Entry<String, OpenDreamsJob> job : this.jobs.entrySet()) {
            job.getValue().terminate();
        }
    }

    public void reap() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada.");
    }
}

