package csbase.server.services.projectservice.v1_00;

import java.util.Properties;

import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;

import scs.core.ComponentId;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.data_service.DataKey;
import tecgraf.openbus.data_service.IHierarchicalDataServiceHelper;
import tecgraf.openbus.data_service.IHierarchicalNavigationDataService;
import tecgraf.openbus.data_service.IHierarchicalNavigationDataServiceHelper;
import tecgraf.openbus.data_service.ServiceFailure;
import csbase.exception.OperationFailureException;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Utilitrio para fazer a busca de servios de dados da verso 1.0 a partir da
 * chave informada.
 * 
 * @author Tecgraf
 */
public class FindService {
  /**
   * O nome da propriedade que indica que o sistema deve prover uma interface.
   */
  private static final String INTERFACE_PROPERTY_NAME =
    "openbus.component.interface";
  private static final String COMPONENT_NAME_PROPERTY_NAME =
    "openbus.component.name";
  private static final String COMPONENT_MAJOR_VERSION_PROPERTY_NAME =
    "openbus.component.version.major";
  private static final String COMPONENT_VERSION_MINOR_PROPERTY_NAME =
    "openbus.component.version.minor";
  private static final String COMPONENT_VERSION_PATCH_PROPERTY_NAME =
    "openbus.component.version.patch";

  /**
   * Realiza uma busca por um Servio de Dados a partir da chave de um dado. O
   * dado representado pela chave  oriundo do Servio de Dados encontrado.
   * 
   * @param dataKey A chave do dado que contm as informaes sobre o Servio de
   *        Dados procurado.
   * 
   * @return O Servio de Dados.
   * @throws ServiceFailure caso ocorra algum erro na busca do servio de dados
   */
  protected static IHierarchicalNavigationDataService find(DataKey dataKey)
    throws ServiceFailure {

    String serviceFacetIOR = dataKey.getServiceFacetIOR();
    IComponent component = null;

    if (serviceFacetIOR != null) {
      ORB orb = OpenBusService.getInstance().getORB();
      org.omg.CORBA.Object obj = orb.string_to_object(serviceFacetIOR);
      component = IComponentHelper.narrow(obj);
      if (component == null) {
        return null;
      }
      if (!isReachable(component)) {
        return null;
      }
    }
    else {
      ComponentId componentId = dataKey.getServiceComponentId();
      if (componentId == null) {
        return null;
      }
      else {
        Properties properties = new Properties();

        properties.setProperty(COMPONENT_NAME_PROPERTY_NAME, componentId.name);
        properties.setProperty(COMPONENT_MAJOR_VERSION_PROPERTY_NAME, Byte
          .toString(componentId.major_version));
        properties.setProperty(COMPONENT_VERSION_MINOR_PROPERTY_NAME, Byte
          .toString(componentId.minor_version));
        properties.setProperty(COMPONENT_VERSION_PATCH_PROPERTY_NAME, Byte
          .toString(componentId.patch_version));
        properties.setProperty(INTERFACE_PROPERTY_NAME, dataKey
          .getServiceFacetName());

        try {
          component = OpenBusService.getInstance().findService(properties);
          if (component == null) {
            return null;
          }
        }
        catch (OperationFailureException e) {
          throw new ServiceFailure("Erro ao buscar o servio de dados.");
        }
      }
    }

    org.omg.CORBA.Object obj =
      component.getFacet(IHierarchicalDataServiceHelper.id());

    IHierarchicalNavigationDataService dataService =
      IHierarchicalDataServiceHelper.narrow(obj);

    if (dataService == null) {
      obj = component.getFacet(IHierarchicalNavigationDataServiceHelper.id());
      dataService = IHierarchicalNavigationDataServiceHelper.narrow(obj);
    }

    return dataService;
  }

  /**
   * Verifica se um componente  alcanvel.
   * 
   * @param component O componente.
   * 
   * @return {@code true}, caso o componente seja alcanvel, ou {@code false},
   *         caso contrrio.
   */
  private static boolean isReachable(IComponent component) {
    try {
      if (component._non_existent()) {
        return false;
      }
      component.getComponentId();
      return true;
    }
    catch (SystemException e) {
      return false;
    }
  }
}
