package csbase.server.services.restservice;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

import javax.annotation.Priority;
import javax.ws.rs.Priorities;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.glassfish.hk2.api.ServiceLocator;

import ibase.common.RestErrorMessage;
import ibase.common.ServiceAdapter;
import ibase.rest.api.authentication.v1.adapter.AuthenticationService;
import ibase.rest.api.authentication.v1.adapter.ParseException;

/**
 * Filtro que vai verificar credenciais ou tokens ou o que estiver sendo usado
 * para validar o usurio.
 * 
 * Alm disso ele executa configures necessrias antes do request.
 * 
 * @author Tecgraf/PUC-Rio
 */
@Priority(Priorities.AUTHENTICATION)
public class CSBaseRequestFilter implements ContainerRequestFilter {

  /** ServiceLocator default do jersey */
  @Context
  private ServiceLocator serviceLocator;

  /** URI base */
  @Context
  private UriInfo uriInfo;

  /**
   * Nome do parmetro opcional que todas as requisies podem ter para o locale
   */
  public static String LOCALE_PARAM = "locale";

  /**
   * Logger
   */
  private static final Logger logger = Logger.getLogger("CSBaseRequestFilter");

  /**
   * {@inheritDoc}
   */
  @Override
  public void filter(ContainerRequestContext requestContext)
    throws IOException {

    long now = System.currentTimeMillis();

    ServiceAdapter.setServiceLocator(serviceLocator);
    ServiceAdapter.setURI(RestService.getInstance().getExternalURL());
    ServiceAdapter.addProperty("ftp.SSL.enabled", RestService.getInstance()
      .getStringProperty("ftp.SSL.enabled"));
    ServiceAdapter.addProperty("ftp.SSL.private", RestService.getInstance()
      .getStringProperty("ftp.SSL.private"));
    ServiceAdapter.addProperty("ftp.SSL.auth", RestService.getInstance()
      .getStringProperty("ftp.SSL.auth"));
    ServiceAdapter.addProperty("ftp.passive", RestService.getInstance()
      .getStringProperty("ftp.passive"));
    ServiceAdapter.addProperty("ftp.host", RestService.getInstance()
      .getStringProperty(
        "ftp.host"));
    ServiceAdapter.addProperty("ftp.port", RestService.getInstance()
      .getStringProperty(
        "ftp.port"));
    ServiceAdapter.addProperty("ftp.user", RestService.getInstance()
      .getStringProperty(
        "ftp.user"));
    ServiceAdapter.addProperty("ftp.password", RestService.getInstance()
      .getStringProperty("ftp.password"));
    //requestContext.getQueryParameters().get("token").get(0)
    
    if (requestContext.getUriInfo().getPath().indexOf("authentication") < 0
      && requestContext.getUriInfo().getPath().indexOf("links") < 0
      && requestContext.getUriInfo().getPath().indexOf("swagger.yaml") < 0
      && requestContext.getUriInfo().getPath().indexOf("swagger.json") < 0
      && requestContext.getUriInfo().getPath().indexOf("algorithms/public") < 0) {

      try {

        AuthenticationService authenticationService = ServiceAdapter.getInstance(
          AuthenticationService.class, Locale.getDefault().toString());

        String authorizationHeader = requestContext.getHeaderString(
          HttpHeaders.AUTHORIZATION);
        ServiceAdapter.setAuthorizationHeader(authorizationHeader);

        String userId = null;

        boolean valid = true;

        if (authorizationHeader == null || !authorizationHeader.startsWith(
          "Bearer ")) {

          valid = false;

          List<String> parameters = requestContext.getUriInfo()
            .getQueryParameters().get("token");

          if (parameters != null && parameters.size() > 0 && parameters.get(
            0) != null) {

            Map<String, Object> tokenParams = new HashMap<String, Object>();

            userId = authenticationService.parserToken(parameters.get(0),
              tokenParams);
            long creation = ((Date) tokenParams.get("iat")).getTime();

            //verifica se eh maior q 30 segundos
            if ((now - creation) < 30000) {
              valid = true;
              ServiceAdapter.setAuthorizationHeader("Bearer " + parameters.get(0));
            }

          }
        }
        else {
          userId = authenticationService.parserToken(authorizationHeader
            .substring("Bearer".length()).trim(), null);
        }

        if (!valid) {
          requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED)
            .entity(new RestErrorMessage("Authorization header must be provided"))
            .build());
          return;
        }

        ServiceAdapter.setCurrentUser(userId);
        requestContext.setProperty("userId", userId);
      }
      catch (ParseException e) {
        requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED)
          .build());
      }
    }
  }
}
