/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.projectservice;

import csbase.logic.ProjectFileInfo;
import csbase.logic.ProjectFileType;
import csbase.server.services.projectservice.DefaultProjectTemplate;
import csbase.server.services.projectservice.ServerProjectFile;
import java.util.Arrays;

public class FileTypeTemplate
extends DefaultProjectTemplate {
    public FileTypeTemplate(ProjectFileInfo baseDir, String ... params) {
        super(baseDir, params);
    }

    @Override
    public boolean canCreate(ServerProjectFile parentDir, String name, String type) {
        Object[] parentPath;
        if (!super.canCreate(parentDir, name, type)) {
            return false;
        }
        ProjectFileInfo baseDir = this.getBaseDir();
        Object[] baseDirPath = baseDir.getPath();
        if (Arrays.equals(baseDirPath, parentPath = parentDir.getPath()) || FileTypeTemplate.isAncestor((String[])baseDirPath, (String[])parentPath)) {
            if (this.isInDataset(parentDir)) {
                return true;
            }
            return this.checkCondition(type);
        }
        return true;
    }

    private boolean isInDataset(ServerProjectFile parentDir) {
        while (parentDir != null) {
            String type = parentDir.getType();
            ProjectFileType fileType = ProjectFileType.getFileType((String)type);
            if (fileType != null && fileType.isDirectory() && !type.equals("DIRECTORY_TYPE")) {
                return true;
            }
            parentDir = parentDir.getParent();
        }
        return false;
    }

    @Override
    public boolean canChangeType(ServerProjectFile file, String newType) {
        Object[] filePath;
        if (!super.canChangeType(file, newType)) {
            return false;
        }
        ProjectFileInfo baseDir = this.getBaseDir();
        Object[] baseDirPath = baseDir.getPath();
        if (Arrays.equals(baseDirPath, filePath = file.getPath()) || FileTypeTemplate.isAncestor((String[])baseDirPath, (String[])filePath)) {
            return this.checkCondition(newType);
        }
        return true;
    }

    private boolean checkCondition(String type) {
        String[] allowedTypes;
        for (String allowedType : allowedTypes = this.getParameters()) {
            if (!type.equalsIgnoreCase(allowedType)) continue;
            return true;
        }
        return false;
    }
}

