/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.repositoryservice;

import csbase.server.FileSystem;
import csbase.server.Server;
import csbase.server.services.repositoryservice.IRepositoryFile;
import csbase.server.services.repositoryservice.LocalRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;

class LocalFile
implements IRepositoryFile {
    private File file;
    private RandomAccessFile raf;
    private LocalRepository repository;
    private String relativePath;

    LocalFile(File file, LocalRepository repository, String relativePath) {
        if (file == null) {
            throw new IllegalArgumentException("file n\u00e3o pode ser nulo.");
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository n\u00e3o pode ser nulo.");
        }
        this.file = file;
        this.repository = repository;
        this.relativePath = relativePath;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public List<IRepositoryFile> getChildren() {
        if (this.isRegularFile()) {
            return null;
        }
        LinkedList<IRepositoryFile> result = new LinkedList<IRepositoryFile>();
        for (File child : this.file.listFiles()) {
            String childPath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.relativePath, child.getName()});
            result.add(new LocalFile(child, this.repository, childPath));
        }
        return result;
    }

    @Override
    public IRepositoryFile getChild(String ... path) {
        String filePath = FileUtils.joinPath((char)File.separatorChar, (String[])path);
        filePath = FileUtils.joinPath((char)File.separatorChar, (String[])new String[]{this.getPath(), filePath});
        return this.repository.getFile(filePath);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public long getModificationDate() {
        return this.file.lastModified();
    }

    @Override
    public IRepositoryFile getParent() {
        File parentFile = this.file.getParentFile();
        if (parentFile == null) {
            return null;
        }
        if (parentFile.getPath().equals(this.repository.getURI())) {
            return null;
        }
        return new LocalFile(parentFile, this.repository, FileUtils.getFilePath((String)this.relativePath));
    }

    @Override
    public String getPath() {
        return this.relativePath;
    }

    @Override
    public long size() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isRegularFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isHidden() {
        return this.file.isHidden();
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead();
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite();
    }

    @Override
    public boolean isExecutable() {
        return this.file.canExecute();
    }

    @Override
    public boolean lock() {
        return this.repository.lock(this);
    }

    @Override
    public boolean release() {
        return this.repository.release(this);
    }

    @Override
    public boolean isLocked() {
        return this.repository.isLocked(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isLocked()) {
            throw new IOException(String.format("Arquivo bloqueado: %s", this));
        }
        return new FileOutputStream(this.file);
    }

    @Override
    public FileChannel getFileChannel(String mode) throws IOException {
        if (this.raf == null) {
            this.raf = new RandomAccessFile(this.file, mode);
        }
        return this.raf.getChannel();
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        this.raf = null;
    }

    public String toString() {
        return this.file.getName();
    }

    @Override
    public String getFullPath() {
        return this.file.getAbsolutePath();
    }

    boolean copyRegularFile(File newFile) {
        if (!FileSystem.copyFile(this.file, newFile)) {
            String errMsg = "ServerProjectFile:copyFile: erro na c\ufffdpia f\ufffdsica de " + this.file.getAbsolutePath() + " para " + newFile.getAbsolutePath();
            Server.logWarningMessage(errMsg);
            return false;
        }
        return true;
    }
}

