/**
 * $Id: Utils.java 177959 2016-12-02 11:56:05Z fpina $
 */
package csbase.sga;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import sgaidl.Pair;

/**
 * Utilitrios.
 *
 * @author Tecgraf/PUC-Rio
 */
public class Utils {

  /**
   * Adiciona as entradas de um dicionrio em um mapa.
   *
   * @param dictionary o odicionrio
   * @param map o mapa
   */
  protected static void convertDicToMap(Pair[] dictionary,
    Map<String, String> map) {
    for (Pair pair : dictionary) {
      map.put(pair.key, pair.value);
    }
  }

  /**
   * Converte um dicionrio para mapa.
   *
   * @param dictionary o dicionrio
   *
   * @return o mapa
   */
  protected static Map<String, String> convertDicToMap(Pair[] dictionary) {
    Map<String, String> map = new HashMap<String, String>();
    for (Pair pair : dictionary) {
      map.put(pair.key, pair.value);
    }

    return map;
  }

  /**
   * Converte um mapa no formato
   *
   * <p><code>{ key.1, value1; key.2, value2; ... ; key.n, valuen }</code></p>
   *
   * para uma lista no formato
   *
   * <p><code>{ value1; value2; ... ; valuen }</code></p>
   *
   * @param map o mapa
   * @param key a chave
   *
   * @return a lista
   */
  protected static List<String> convertMapToList(Map<String, String> map, String key) {
    List<String> list = new LinkedList<>();
    int i = 1;
    while (map.containsKey(key + "." + i)) {
      list.add(map.get(key + "." + i));
      i++;
    }
    return list;
  }
}
