package csbase.sga.executor;

import java.util.Map;

/**
 * Classe base de JobData que contm os parmetros do ambiente de execuo do
 * job.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractJobData implements JobData {
  /**
   * Os parmetros do ambiente de execuo do job.
   */
  protected Map<String, String> execParam;

  /**
   * Construtor.
   *
   * @param execParam os parmetros de execuo do job
   */
  public AbstractJobData(Map<String, String> execParam) {
    this.execParam = execParam;
  }

  /**
   * Obtm os parmetros de execuo do job
   *
   * @return os parmetros de execuo
   */
  public Map<String, String> getExecParam() {
    return execParam;
  }
}
