/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import csbase.server.plugin.service.sgaservice.SGADaemonCommand;
import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import sgaidl.ActionNotSupportedException;
import sgaidl.InvalidActionException;
import sgaidl.InvalidTransitionException;
import sgaidl.JobControlAction;
import sgaidl.Pair;
import sgaidl.ProcessState;
import sgaidl.RunningCommandInfo;

public class SGALocalCommand
extends SGADaemonCommand {
    private static final long serialVersionUID = -5874016392438461849L;
    private static Logger LOGGER;
    private JobExecutor executor;
    private String commandId;
    private JobData jobData;
    private ListenableFuture<JobData> jobDataFuture;
    private ListenableFuture<Boolean> recoveryStatusFuture;
    ListeningExecutorService executionThread = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    protected static void setLogger(String name) {
        LOGGER = Logger.getLogger(name);
    }

    protected SGALocalCommand(JobExecutor executor, String commandId) {
        this.executor = executor;
        this.commandId = commandId;
    }

    protected SGALocalCommand(JobExecutor executor, String commandId, JobData jobData) {
        this.executor = executor;
        this.commandId = commandId;
        this.jobData = jobData;
    }

    protected JobData getJobData() {
        if (this.jobData != null) {
            return this.jobData;
        }
        if (this.jobDataFuture.isDone()) {
            try {
                return (JobData)this.jobDataFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    protected JobExecutor getExecutor() {
        return this.executor;
    }

    protected void execute(final String commandString, final Map<String, String> execParam, final JobObserver observer) {
        this.jobDataFuture = this.executionThread.submit((Callable)new Callable<JobData>(){

            @Override
            public JobData call() throws Exception {
                try {
                    LOGGER.log(Level.INFO, "Solicitando execu\u00e7\u00e3o do comando {0} ao executor", new Object[]{SGALocalCommand.this.commandId});
                    return SGALocalCommand.this.executor.executeJob(commandString, execParam, observer);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Erro ao executar comando " + SGALocalCommand.this.commandId, e);
                    return null;
                }
            }
        });
        Futures.addCallback(this.jobDataFuture, (FutureCallback)new FutureCallback<JobData>(){

            public void onSuccess(JobData data) {
                if (data == null) {
                    LOGGER.log(Level.WARNING, "Comando {0} n\u00e3o iniciado", new Object[]{SGALocalCommand.this.commandId});
                    observer.onJobLost();
                } else {
                    observer.onJobStarted(data);
                }
            }

            public void onFailure(Throwable t) {
                if (CancellationException.class.isInstance(t)) {
                    LOGGER.log(Level.FINE, "Execu\u00e7\u00e3o do comando {0} foi cancelada", new Object[]{SGALocalCommand.this.commandId});
                } else {
                    LOGGER.log(Level.SEVERE, "Erro ao executar comando: " + SGALocalCommand.this.commandId, t);
                    observer.onJobLost();
                }
            }
        });
    }

    protected void recovery(JobData data, final JobObserver observer) {
        this.jobData = data;
        this.recoveryStatusFuture = this.executionThread.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.log(Level.INFO, "Solicitando recupera\u00e7\u00e3o do comando {0} ao executor", new Object[]{SGALocalCommand.this.commandId});
                return SGALocalCommand.this.executor.recoveryJob(SGALocalCommand.this.jobData, observer);
            }
        });
        Futures.addCallback(this.recoveryStatusFuture, (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean wasRecovered) {
                if (!wasRecovered.booleanValue()) {
                    LOGGER.log(Level.INFO, "Comando {0} n\u00e3o recuperado", new Object[]{SGALocalCommand.this.commandId});
                    observer.onJobLost();
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.log(Level.SEVERE, "Erro ao recuperar comando: " + SGALocalCommand.this.commandId, t);
                observer.onJobLost();
            }
        });
    }

    public void control(JobControlAction action, String child) throws InvalidActionException, ActionNotSupportedException, InvalidTransitionException {
        LOGGER.log(Level.INFO, "Exercendo a\u00e7\u00e3o {0} no comando {1}", new Object[]{action.toString(), this.commandId});
        JobData data = this.getJobData();
        if (data != null) {
            this.executor.controlJob(data, child, action);
        } else if (!this.jobDataFuture.cancel(true)) {
            LOGGER.log(Level.WARNING, "Erro ao cancelar comando {0}", new Object[]{this.commandId});
        }
    }

    public RunningCommandInfo getRunningCommandInfo() {
        LOGGER.log(Level.INFO, "Obtendo as informa\u00e7\u00f5es do comando {0}", new Object[]{this.commandId});
        JobData data = this.getJobData();
        if (data == null) {
            return this.convertJobInfoToRunningCommandInfo(new JobInfo());
        }
        JobInfo info = this.executor.getJobInfo(data);
        if (info == null) {
            LOGGER.log(Level.FINE, "N\u00e3o foi poss\u00edvel obter as informa\u00e7\u00f5es do comando {0}", new Object[]{this.commandId});
            return null;
        }
        return this.convertJobInfoToRunningCommandInfo(info);
    }

    private RunningCommandInfo makeBlankInfo() {
        return new RunningCommandInfo((Pair[][])new Pair[0][], new Pair[0]);
    }

    private RunningCommandInfo makeWatingInfo() {
        Pair[] processInfo = new Pair[]{new Pair("csbase_command_state", ProcessState.WAITING.toString())};
        return new RunningCommandInfo((Pair[][])new Pair[][]{processInfo}, new Pair[0]);
    }

    private RunningCommandInfo convertJobInfoToRunningCommandInfo(JobInfo jobInfo) {
        LinkedList<Pair[]> processData = new LinkedList<Pair[]>();
        LinkedList<Pair> mainProcessDic = new LinkedList<Pair>();
        for (String key : jobInfo.jobParam.keySet()) {
            mainProcessDic.add(new Pair(key, jobInfo.jobParam.get(key)));
        }
        processData.add(mainProcessDic.toArray(new Pair[0]));
        for (JobInfo pInfo : jobInfo.children) {
            LinkedList<Pair> pDic = new LinkedList<Pair>();
            for (String key : pInfo.jobParam.keySet()) {
                pDic.add(new Pair(key, pInfo.jobParam.get(key)));
            }
            processData.add(pDic.toArray(new Pair[0]));
        }
        return new RunningCommandInfo((Pair[][])processData.toArray((T[])new Pair[0][]), new Pair[0]);
    }
}

