package csbase.sga.ssh;

import csbase.sshclient.SSHClient;
import csbase.sshclient.SSHClientException;

public class SSHClientFactory {
  private String sshHost;
  private int sshPort;
  private String sshUserName;
  private String sshUserPass;
  private String sshUserPrivKey;
  private boolean isTunnelEnable;
  private String sshTunnelHost;
  private int sshTunnelPort;
  private String sshTunnelUser;
  private String sshTunnelPass;
  private String sshTunnelPrivKey;
  private int sshTunnelLocalPort;
  private int sshTunnelLocalPortRange;

  public SSHClientFactory(String sshHost, int sshPort, String sshUserName,
    String sshUserPass, String sshUserPrivKey, boolean isTunnelEnable,
    String sshTunnelHost, int sshTunnelPort, String sshTunnelUser,
    String sshTunnelPass, String sshTunnelPrivKey, int sshTunnelLocalPort,
    int sshTunnelLocalPortRange) {
    super();
    this.sshHost = sshHost;
    this.sshPort = sshPort;
    this.sshUserName = sshUserName;
    this.sshUserPass = sshUserPass;
    this.sshUserPrivKey = sshUserPrivKey;
    this.isTunnelEnable = isTunnelEnable;
    this.sshTunnelHost = sshTunnelHost;
    this.sshTunnelPort = sshTunnelPort;
    this.sshTunnelUser = sshTunnelUser;
    this.sshTunnelPass = sshTunnelPass;
    this.sshTunnelPrivKey = sshTunnelPrivKey;
    this.sshTunnelLocalPort = sshTunnelLocalPort;
    this.sshTunnelLocalPortRange = sshTunnelLocalPortRange;
  }

  /**
   * Gets a SSH client.
   *
   * @return the SSH client
   *
   * @throws SSHClientException failure getting the SSH client
   */
  protected SSHClient getSSHClient() throws SSHClientException {
    SSHClient sshClient = new SSHClient(sshHost, sshPort);
    //    logger.fine("SSH client to " + sshHost + ":" + sshPort + " created");

    if (this.isTunnelEnable) {
      sshClient.createTunnel(
        sshTunnelHost, sshTunnelPort, sshTunnelUser, sshTunnelPrivKey,
        sshTunnelLocalPort, sshTunnelLocalPortRange);
      //      logger.fine(
      //        "SSH tunnel to " + sshTunnelHost + ":" + sshTunnelPort + " created");
    }

    sshClient.connect(sshUserName, sshUserPrivKey);
    //    logger.fine(
    //      "SSH client authenticated [user: " + sshUserName + ", key: "
    //        + sshUserPrivKey);

    return sshClient;
  }
}
