/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.pbs;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.pbs.PBSJobData;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sgaidl.ProcessState;

public class PBSDriver
implements SGADriver {
    private static final String SUBMIT_JOB = "echo \"{0}\" | qsub";
    private static final String CHECK_JOB = "qstat -f {0}";
    private static final String CHECK_ALL_JOBS = "qstat -f";
    private static final String KILL_JOB = "qdel {0}";
    private static final String JOB_INFO_SEPARATOR = "Job Id:";
    private Pattern JOB_ID_PATTERN = Pattern.compile("([^\\.]+)\\.(.*)\n");
    private Pattern JOB_INFO_PATTERN = Pattern.compile("Job Id\\: (\\d+)\\.(\\S+)$(.*)", 40);
    private Pattern JOB_ATTRIBUTES_PATTERN = Pattern.compile("\\s*(\\S+) = ([\\S ]+)");
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        return MessageFormat.format(SUBMIT_JOB, script);
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(KILL_JOB, data.getJobId());
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(CHECK_JOB, data.getJobId());
    }

    @Override
    public String buildCheckAllJobsCommand() {
        return CHECK_ALL_JOBS;
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        Matcher matcher = this.JOB_ID_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new PBSJobData(matcher.group(1));
        }
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobOutput(String output) {
        HashMap<JobData, JobInfo> jobsInfo = new HashMap<JobData, JobInfo>();
        int beginIdx = output.indexOf(JOB_INFO_SEPARATOR);
        if (beginIdx < 0) {
            return jobsInfo;
        }
        do {
            int endIdx;
            String entry = output.substring(beginIdx, (endIdx = output.indexOf(JOB_INFO_SEPARATOR, beginIdx + 1)) < 0 ? output.length() : endIdx);
            Matcher matcher = this.JOB_INFO_PATTERN.matcher(entry);
            HashMap<String, String> attrsMap = new HashMap<String, String>();
            while (matcher.find()) {
                attrsMap.put("pid", matcher.group(1));
                attrsMap.put("server", matcher.group(2));
                String attrs = matcher.group(3);
                Matcher attrsMatcher = this.JOB_ATTRIBUTES_PATTERN.matcher(attrs);
                while (attrsMatcher.find()) {
                    attrsMap.put(attrsMatcher.group(1), attrsMatcher.group(2));
                }
            }
            beginIdx = endIdx;
            jobsInfo.put(new PBSJobData((String)attrsMap.get("pid")), this.convertToJobInfo(attrsMap));
        } while (beginIdx > 0);
        return jobsInfo;
    }

    private JobInfo convertToJobInfo(Map<String, String> jobMap) {
        ProcessState jobState;
        JobInfo jobInfo = new JobInfo();
        jobInfo.jobParam.put("csbase_command_pid", jobMap.get("pid"));
        switch (jobMap.get("job_state")) {
            case "C": {
                jobState = ProcessState.FINISHED;
                break;
            }
            case "E": {
                jobState = ProcessState.FINISHED;
                break;
            }
            case "H": {
                jobState = ProcessState.SLEEPING;
                break;
            }
            case "Q": {
                jobState = ProcessState.WAITING;
                break;
            }
            case "R": {
                jobState = ProcessState.RUNNING;
                break;
            }
            case "T": {
                jobState = ProcessState.RUNNING;
                break;
            }
            case "W": {
                jobState = ProcessState.SLEEPING;
                break;
            }
            case "S": {
                jobState = ProcessState.FINISHED;
                break;
            }
            default: {
                jobState = ProcessState.WAITING;
            }
        }
        jobInfo.jobParam.put("csbase_command_state", jobState.toString());
        String host = jobMap.get("server");
        jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
        return jobInfo;
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        return "";
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        return new SGAInfo(this.properties);
    }

    public void parseNodes(String output) {
        Pattern NODES_PATTERN = Pattern.compile("^(\\S+)$", 8);
        Matcher matcher = NODES_PATTERN.matcher(output);
        while (matcher.find()) {
            System.out.println(matcher.group(1));
        }
    }
}

