/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobExecutor;
import csbase.sga.executor.JobInfo;
import csbase.sga.executor.JobObserver;
import csbase.sga.ssh.JobStorage;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.SGASSH;
import csbase.sga.ssh.SSHClientPool;
import csbase.sshclient.CommandResult;
import csbase.sshclient.SSHClient;
import csbase.sshclient.SSHClientException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import sgaidl.ActionNotSupportedException;
import sgaidl.InvalidActionException;
import sgaidl.JobControlAction;
import sgaidl.ProcessState;

public class SSHExecutor
implements JobExecutor {
    private Properties pluginProperties;
    private SGADriver driver;
    private SSHClientPool sshClientPool;
    private JobStorage jobStorage;
    private Logger logger;
    private final ExecutorService notifier;

    public SSHExecutor(Properties pluginProperties, SGADriver driver, SSHClientPool sshClientPool) {
        this.pluginProperties = pluginProperties;
        String sgaName = pluginProperties.getProperty("csbase_sga_name");
        this.logger = Logger.getLogger(SGASSH.class.getName() + "." + sgaName);
        long jobInfoMaxAge = 60000L;
        if (pluginProperties.containsKey("csbase_process_time_seconds")) {
            jobInfoMaxAge = Long.parseLong(pluginProperties.getProperty("csbase_process_time_seconds")) * 1000L;
        }
        this.jobStorage = new JobStorage(jobInfoMaxAge);
        this.driver = driver;
        this.sshClientPool = sshClientPool;
        this.notifier = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobData executeJob(String jobCommand, Map<String, String> extraParams, JobObserver observer) {
        JobData data = null;
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            String command = this.driver.buildSubmitJobCommand(jobCommand, extraParams);
            this.logger.fine("Job's command line: " + command);
            CommandResult result = client.execute(command);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Job execution return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                observer.onJobLost();
                JobData jobData = null;
                return jobData;
            }
            this.logger.fine("Job execution return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            data = this.driver.parseJobSubmissionOutput(result.getOutput());
            if (data == null) {
                this.logger.log(Level.SEVERE, "Cannot parse job submission output");
                observer.onJobLost();
                JobData jobData = null;
                return jobData;
            }
            this.logger.fine("Job's JobData: " + data);
            this.jobStorage.addJob(data, observer);
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Erro submitting job", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
        return data;
    }

    public void recoverJob(JobData data, JobObserver observer) {
        try {
            this.updateSingleJobInfo(data);
            if (!this.jobStorage.recoverJob(data, observer)) {
                observer.onJobLost();
            }
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.WARNING, "Error recovering job", e);
            observer.onJobLost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controlJob(JobData data, String child, JobControlAction action) throws InvalidActionException, ActionNotSupportedException {
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            String controlCommand = this.driver.buildKillJobCommand(data);
            this.logger.fine("Job's control command line: " + controlCommand);
            CommandResult result = client.execute(controlCommand);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Job control return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Job control return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            JobObserver observer = this.jobStorage.getObserver(data);
            this.jobStorage.removeJob(data);
            observer.onJobKilled();
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Erro controlling job", e);
            if (client != null) {
                client.disconnect();
            }
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
    }

    public JobInfo getJobInfo(JobData data) {
        try {
            this.updateJobsInfo();
        }
        catch (SSHClientException | IOException e) {
            this.logger.log(Level.SEVERE, "Error updating job info", e);
        }
        return this.jobStorage.getJobInfo(data);
    }

    public void searchAndNotifyFinishedJobs() {
        try {
            this.updateJobsInfo();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while searching for finished jobs", e);
        }
        for (JobData data : this.jobStorage.getJobs()) {
            JobObserver observer;
            final JobInfo info = this.jobStorage.getJobInfo(data);
            if (info == null || !this.isFinished(info) || (observer = this.jobStorage.getObserver(data)) == null) continue;
            this.notifier.execute(new Runnable(){

                @Override
                public void run() {
                    observer.onJobCompleted(info);
                }
            });
            this.jobStorage.removeJob(data);
        }
    }

    private boolean isFinished(JobInfo info) {
        return ((String)info.jobParam.get("csbase_command_state")).equals(ProcessState.FINISHED.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSingleJobInfo(JobData data) throws SSHClientException, IOException {
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            String updateCommand = this.driver.buildCheckJobCommand(data);
            this.logger.fine("Job's update command line: " + updateCommand);
            CommandResult result = client.execute(updateCommand);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Update job info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Update job info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            HashMap<JobData, JobInfo> jobs = new HashMap<JobData, JobInfo>();
            jobs.put(data, this.driver.parseCheckJobOutput(data, result.getOutput()));
            this.jobStorage.updateJobs(jobs);
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllJobsInfo() throws SSHClientException, IOException {
        JobData[] jobsData = this.jobStorage.getJobs().toArray(new JobData[0]);
        SSHClient client = null;
        try {
            client = this.sshClientPool.retrieveSSHClient();
            String updateCommand = this.driver.buildCheckJobListCommand(jobsData);
            this.logger.fine("Job's update command line: " + updateCommand);
            CommandResult result = client.execute(updateCommand);
            if (result.getStatus() > 0) {
                this.logger.log(Level.WARNING, "Update all jobs info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
                return;
            }
            this.logger.fine("Update all jobs info return code: " + result.getStatus() + "\nOutput: " + result.getOutput() + "\nError: " + result.getError());
            this.jobStorage.updateJobs(this.driver.parseCheckJobListOutput(jobsData, result.getOutput()));
        }
        finally {
            if (client != null) {
                this.sshClientPool.returnSSHClient(client);
            }
        }
    }

    private void updateJobsInfo() throws SSHClientException, IOException {
        if (!this.jobStorage.needsUpdate()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        JobData[] jobsData = this.jobStorage.getJobs().toArray(new JobData[0]);
        try {
            if (this.driver.buildCheckJobListCommand(jobsData) != null) {
                this.updateAllJobsInfo();
            } else {
                for (JobData d : jobsData) {
                    this.updateSingleJobInfo(d);
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error while updating jobs info", e);
        }
        this.logger.fine("Time took to update job info: " + (System.currentTimeMillis() - startTime) + " ms");
    }
}

