/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.sge.xml;

import csbase.sga.ssh.sge.SGEJobData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SGESAXReader {
    public Map<SGEJobData, Map<String, String>> parseCommands(String xml) {
        final HashMap<SGEJobData, Map<String, String>> jobs = new HashMap<SGEJobData, Map<String, String>>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                private Map<String, String> currentJob;
                boolean readingJobId = false;
                boolean readingQueueName = false;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals("job_list")) {
                        this.currentJob = new HashMap<String, String>();
                        this.currentJob.put("state", attributes.getValue("state"));
                    } else if (qName.equals("JB_job_number")) {
                        this.readingJobId = true;
                    } else if (qName.equals("queue_name")) {
                        this.readingQueueName = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("job_list")) {
                        jobs.put(new SGEJobData(this.currentJob.get("JB_job_number")), this.currentJob);
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.readingJobId) {
                        this.currentJob.put("JB_job_number", new String(ch, start, length));
                        this.readingJobId = false;
                    }
                    if (this.readingQueueName) {
                        String queueName = new String(ch, start, length).trim();
                        if (!queueName.isEmpty()) {
                            String[] queueAndHost = new String(ch, start, length).split("@");
                            this.currentJob.put("queue", queueAndHost[0]);
                            this.currentJob.put("host", queueAndHost[1]);
                        }
                        this.readingQueueName = false;
                    }
                }
            };
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jobs;
    }

    public List<Map<String, String>> parseNodes(String xml) {
        final LinkedList<Map<String, String>> nodes = new LinkedList<Map<String, String>>();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                private Map<String, String> currentNode;
                List<String> queues = null;
                String queueName = null;
                String currentAttribute;
                int nodeSlotsUsed = 0;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals("host")) {
                        this.currentNode = new HashMap<String, String>();
                        this.currentNode.put("name", attributes.getValue("name"));
                        this.queues = new LinkedList<String>();
                    } else if (qName.equals("hostvalue")) {
                        this.currentAttribute = attributes.getValue("name");
                    } else if (qName.equals("resourcevalue")) {
                        this.currentAttribute = attributes.getValue("name");
                    } else if (qName.equals("queue")) {
                        this.queueName = attributes.getValue("name");
                        this.queues.add(this.queueName);
                    } else if (qName.equals("queuevalue")) {
                        this.currentAttribute = attributes.getValue("name");
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals("host") && !this.currentNode.get("name").equals("global")) {
                        this.currentNode.put("total_slots_used", String.valueOf(this.nodeSlotsUsed));
                        this.currentNode.put("queues", this.queues.toString());
                        nodes.add(this.currentNode);
                        this.nodeSlotsUsed = 0;
                    }
                    if (qName.equals("queue")) {
                        this.queueName = null;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.currentAttribute == null) {
                        return;
                    }
                    switch (this.currentAttribute) {
                        case "arch_string": {
                            this.currentNode.put("arch_string", new String(ch, start, length));
                            break;
                        }
                        case "num_proc": {
                            this.currentNode.put("num_proc", new String(ch, start, length));
                            break;
                        }
                        case "load_avg": {
                            this.currentNode.put("load_avg", new String(ch, start, length));
                            break;
                        }
                        case "mem_total": {
                            this.currentNode.put("mem_total", new String(ch, start, length));
                            break;
                        }
                        case "mem_used": {
                            this.currentNode.put("mem_used", new String(ch, start, length));
                            break;
                        }
                        case "swap_total": {
                            this.currentNode.put("swap_total", new String(ch, start, length));
                            break;
                        }
                        case "swap_used": {
                            this.currentNode.put("swap_used", new String(ch, start, length));
                            break;
                        }
                        case "np_load_short": {
                            this.currentNode.put("np_load_short", new String(ch, start, length));
                            break;
                        }
                        case "np_load_medium": {
                            this.currentNode.put("np_load_medium", new String(ch, start, length));
                            break;
                        }
                        case "np_load_long": {
                            this.currentNode.put("np_load_long", new String(ch, start, length));
                            break;
                        }
                        case "slots_used": {
                            int queueSlotsUsed = 0;
                            try {
                                queueSlotsUsed = Integer.parseInt(new String(ch, start, length));
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            this.nodeSlotsUsed += queueSlotsUsed;
                        }
                    }
                    this.currentAttribute = null;
                }
            };
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes()), handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nodes;
    }
}

