/*
 * Decompiled with CFR 0.152.
 */
package csbase.test.unit.service;

import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.ServiceManager;
import io.jsonwebtoken.lang.Assert;
import junit.framework.Test;
import org.junit.Before;

public abstract class CSBaseTestSetup {
    protected Server server;

    public CSBaseTestSetup(Test test) {
    }

    public CSBaseTestSetup() {
        this(null);
    }

    @Before
    protected void setUp() throws Exception {
        this.server = this.createServer();
        this.initServer();
        this.loadTestData();
    }

    protected abstract Server createServer() throws ServerException;

    protected void initServer() {
        boolean success = this.server.start();
        Assert.isTrue((boolean)success, (String)"N\u00e3o foi poss\u00edvel iniciar o servidor.\nPor favor consulte o log para maiores detalhes.");
        ServiceManager srvManager = ServiceManager.getInstance();
        Assert.notNull((Object)srvManager, (String)"Gerente de Servi\u00e7os fora do ar");
    }

    protected void shutDown() {
        this.server.shutdown();
    }

    public void loadTestData() {
    }
}

