package csbase.util.data.dispatcher;

import java.awt.EventQueue;


/**
 * Decora um {@link IDispatcher despachante}, garantindo que os dados sero
 * entregues dentro da EDT.
 * 
 * @param <T> Tipo do destino.
 * @param <D> Tipo dos dados a serem despachados para o destino.
 * 
 * @author Tecgraf
 */
public class EDTDispatcher<T, D> implements IDispatcher<T, D> {

  /**
   * Despachante sendo decorado.
   */
  private IDispatcher<T, D> decorated;

  /**
   * Construtor.
   * 
   * @param decorated Despachante sendo decorado.
   */
  public EDTDispatcher(IDispatcher<T, D> decorated) {
    this.decorated = decorated;
  }

  /**
   * <p>
   * Garante que a entrega dos dados seja feita pela EDT.
   * </p>
   * {@inheritDoc}
   */
  @Override
  public void dispatch(final IDispatchListener<T, D> callback,
    final T destination, final D... data) {

    if (EventQueue.isDispatchThread()) {
      decorated.dispatch(callback, destination, data);
    }
    else {
      Runnable runnable = new Runnable() {
        @Override
        public void run() {
          decorated.dispatch(callback, destination, data);
        }
      };
      EventQueue.invokeLater(runnable);
    }
  }
}
