package csbase.util.data.dispatcher;

/**
 * Facilita o uso de um {@link IDispatcher despachante}, dando uma implementao
 * vazia para os mtodos de seu {@link IDispatchListener ouvinte}.
 * 
 * @param <T> Tipo do destino dos dados.
 * @param <D> Tipo do dado a ser despachado.
 * 
 * @author Tecgraf
 */
public class DispatcherAdapter<T, D> implements IDispatchListener<T, D> {

  /**
   * {@inheritDoc}
   */
  @Override
  public void onExceptionThrown(Exception e, T destination, D... data) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onDataDelivered(T destination, D... data) {
  }
}
