/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.proxy;

import csbase.util.proxy.InvocationHandlers;
import csbase.util.proxy.Invoker;
import csbase.util.proxy.RemoteInvocationHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import tecgraf.javautils.core.lng.LNG;

public class ProxyUtils {
    static final String className = ProxyUtils.class.getSimpleName();

    public static <T> T newProxyInstance(Object obj, InvocationHandler handler) {
        Class<?> objClass = obj.getClass();
        ClassLoader cl = objClass.getClassLoader();
        Class<?>[] interfaces = objClass.getInterfaces();
        if (interfaces.length == 0) {
            throw new RuntimeException(LNG.get((String)(className + ".error.runtime.noimplementation")));
        }
        return (T)Proxy.newProxyInstance(cl, interfaces, handler);
    }

    public static <T> T newRemoteProxyInstance(Object obj, InvocationHandler handler, int port) throws RemoteException {
        Class<?> objClass = obj.getClass();
        ClassLoader cl = objClass.getClassLoader();
        ArrayList remoteInterfaceList = new ArrayList();
        for (Class<?> anInterface : objClass.getInterfaces()) {
            if (!Remote.class.isAssignableFrom(anInterface)) continue;
            remoteInterfaceList.add(anInterface);
        }
        if (remoteInterfaceList.size() == 0) {
            throw new IllegalArgumentException(LNG.get((String)(className + ".illegalarg.noimplementation.remote")));
        }
        Class[] remoteInterfaces = remoteInterfaceList.toArray(new Class[0]);
        RemoteInvocationHandler remoteHandler = new RemoteInvocationHandler(obj, handler);
        remoteHandler.export(port);
        return (T)Proxy.newProxyInstance(cl, remoteInterfaces, (InvocationHandler)remoteHandler);
    }

    public static void unexportRemoteProxy(Object proxy) throws NoSuchObjectException {
        InvocationHandler handler = Proxy.getInvocationHandler(proxy);
        if (!(handler instanceof RemoteInvocationHandler)) {
            throw new IllegalArgumentException(LNG.get((String)(className + ".ilegalarg.proxy.notremote")));
        }
        ((RemoteInvocationHandler)handler).unexport();
    }

    public static InvocationHandler createInvocationHandler(Object obj) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        InvocationHandler handler = new Invoker(obj);
        Class<?> objType = obj.getClass();
        if (objType.isAnnotationPresent(InvocationHandlers.class)) {
            InvocationHandlers annotation = objType.getAnnotation(InvocationHandlers.class);
            Class<? extends InvocationHandler>[] handlersClasses = annotation.value();
            for (int inx = handlersClasses.length - 1; inx >= 0; --inx) {
                Class<? extends InvocationHandler> handlerClass = handlersClasses[inx];
                Constructor<? extends InvocationHandler> cons = handlerClass.getConstructor(Object.class, InvocationHandler.class);
                handler = cons.newInstance(obj, handler);
            }
        }
        return handler;
    }
}

