/*
 * Decompiled with CFR 0.152.
 */
package validations;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;
import validations.AbstractValidation;
import validations.util.ValidatorUtils;

public class UserMail2EmailsValidation
extends AbstractValidation {
    private static final String USERS_DIR_PROPERTY = "UsersData.directory";
    private static final String BKP_USER_SUBDIR = File.separator + "persistency" + File.separator + "users";
    private static final String OLD_EMAIL_ATTRIBUTE_KEY = "mail";
    private static final String NEW_EMAIL_ATTRIBUTE_KEY = "emails";
    private static final String LOGIN_ATTRIBUTE_KEY = "login";
    private String fileExtension;
    private File usersDir;
    private String usersBkpPath;
    private List<Hashtable<String, Object>> usersAttributes;
    private boolean terminate = false;
    private String warning = null;

    /*
     * Exception decompiling
     */
    @Override
    protected boolean init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected String getStartMessage() {
        return "Transformando o atributo MAIL:String em EMAILS:String[] nos usu\u00e1rios.";
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add("Existem usu\u00e1rios com o atributo MAIL:String ou sem o atributo EMAILS:String[]");
                break;
            }
            case PATCH_FAILED: {
                errors.add("Ocorre um erro ao tentar corrigir alterar o atributo MAIL:String de um ou mais usu\u00e1rios.");
                break;
            }
            case INIT_FAILED: {
                errors.add("Falha na inicializa\u00e7\u00e3o");
                break;
            }
            default: {
                errors.add("Estado inv\u00e1lido: " + status.toString());
            }
        }
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        switch (status) {
            case VALIDATION_OK: {
                if (this.terminate) {
                    if (this.warning != null) {
                        return String.format("A execu\u00e7\u00e3o do validador %s foi interrompida. %s", this.getClass().getSimpleName(), this.warning);
                    }
                    return String.format("A execu\u00e7\u00e3o do validador %s foi interrompida por raz\u00e3o desconhecida.", this.getClass().getSimpleName());
                }
                return "N\u00e3o h\u00e1 usu\u00e1rio com atributo MAIL:String e todos tem o atributo EMAILS:String[]";
            }
            case PATCH_OK: {
                return "O atributo MAIL:String foi transformado para EMAILS:String[] com sucesso em todos os usu\u00e1rios.";
            }
        }
        return "Estado inv\u00e1lido: " + status.toString();
    }

    @Override
    protected boolean backupData() {
        File usersBkp = new File(this.usersBkpPath);
        if (!usersBkp.exists() && !usersBkp.mkdirs()) {
            String msg = "Erro criando backup em: '" + this.usersBkpPath + "'";
            this.logger.severe(msg);
            return false;
        }
        File[] usersFiles = this.usersDir.listFiles();
        if (usersFiles == null || usersFiles.length == 0) {
            String path = this.usersDir.getAbsolutePath();
            this.logger.fine("Nada a fazer backup em: " + path);
            return true;
        }
        for (File file : usersFiles) {
            File bkpFile = new File(usersBkp, file.getName());
            if (ValidatorUtils.copyFile(file, bkpFile, this.logger, true)) continue;
            String fmt = "Erro fazendo backup do arquivo '%s'";
            String path = file.getAbsolutePath();
            String err = String.format("Erro fazendo backup do arquivo '%s'", path);
            this.logger.severe(err);
            return false;
        }
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        File usersBkp = new File(this.usersBkpPath);
        if (!usersBkp.exists()) {
            String fmt = "O diret\u00f3rio de backup '%s' n\u00e3o foi encontrado.";
            String err = String.format("O diret\u00f3rio de backup '%s' n\u00e3o foi encontrado.", this.usersBkpPath);
            this.logger.severe(err);
            return false;
        }
        File[] usersBkpFiles = usersBkp.listFiles();
        if (usersBkpFiles == null || usersBkpFiles.length == 0) {
            String path = usersBkp.getAbsolutePath();
            String msg = "Nada restaurar em: " + path + " (backup)";
            this.logger.fine(msg);
            FileUtils.delete((File)usersBkp);
            return true;
        }
        for (File bkpFile : usersBkpFiles) {
            File file = new File(this.usersDir, bkpFile.getName());
            if (ValidatorUtils.copyFile(bkpFile, file, this.logger, true)) continue;
            this.logger.severe(String.format("Erro restaurando arquivo '%s' para o diret\u00f3rio '%s'", bkpFile.getAbsolutePath(), this.usersDir.getAbsolutePath()));
            return false;
        }
        FileUtils.delete((File)usersBkp);
        return true;
    }

    @Override
    protected boolean validate() {
        if (this.terminate) {
            return true;
        }
        for (Hashtable<String, Object> attributes : this.usersAttributes) {
            if (attributes.containsKey(OLD_EMAIL_ATTRIBUTE_KEY)) {
                return false;
            }
            if (attributes.containsKey(NEW_EMAIL_ATTRIBUTE_KEY)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean applyPatch() {
        for (Hashtable<String, Object> attributes : this.usersAttributes) {
            if (attributes.containsKey(OLD_EMAIL_ATTRIBUTE_KEY) && attributes.containsKey(NEW_EMAIL_ATTRIBUTE_KEY)) {
                String userLogin = attributes.get(LOGIN_ATTRIBUTE_KEY).toString();
                String oldAttr = "MAIL:String mail";
                String newAttr = "EMAILS:String[] emails";
                String fmt = "Erro: O usu\u00e1rio %s tem atributos (%s) e (%s)!";
                String err = String.format("Erro: O usu\u00e1rio %s tem atributos (%s) e (%s)!", userLogin, "MAIL:String mail", "EMAILS:String[] emails");
                this.logger.warning(err);
                return false;
            }
            if (attributes.containsKey(NEW_EMAIL_ATTRIBUTE_KEY)) continue;
            if (attributes.containsKey(OLD_EMAIL_ATTRIBUTE_KEY)) {
                String email = attributes.get(OLD_EMAIL_ATTRIBUTE_KEY).toString();
                attributes.put(NEW_EMAIL_ATTRIBUTE_KEY, new String[]{email});
                attributes.remove(OLD_EMAIL_ATTRIBUTE_KEY);
            } else {
                attributes.put(NEW_EMAIL_ATTRIBUTE_KEY, new String[0]);
            }
            String loginString = attributes.get(LOGIN_ATTRIBUTE_KEY).toString();
            File userFile = new File(this.usersDir, loginString + "." + this.fileExtension);
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(new DataOutputStream(new BufferedOutputStream(new FileOutputStream(userFile))));
                out.writeObject(attributes);
                out.flush();
            }
            catch (FileNotFoundException e) {
                this.logger.exception("Erro, o arquivo '" + userFile.getPath() + "' n\u00e3o foi encontrado.", e);
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                this.logger.exception("Erro escrevendo no arquivo '" + userFile.getPath() + "'.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (out == null) continue;
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.exception("Erro fechando o arquivo '" + userFile.getPath() + "'.", e);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void finish() {
    }

    @Override
    protected boolean runsOnlyOnce() {
        return !this.terminate;
    }
}

