/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.util.FileSystemUtils;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import validations.AbstractValidation;
import validations.util.ValidationsLogger;
import validations.util.ValidatorUtils;

public class Validator {
    private static final String VALIDATION_MARKER_EXTENSION = ".ok";
    private static final String FRAMEWORK_VALIDATIONS_PACKAGE = "validations";
    private static final String SYSTEM_VALIDATIONS_PACKAGE = "validations_sys";
    public static final String VALIDATIONS_TEMP_DIR = "Validator.tempDir";
    private static final String DEFAULT_PROPERTIES_FILE = "System.properties";
    private static final String LOGPATH_PROPERTY_NAME = "Validator.logPath";
    private static final String DEFAULT_LOGFILE_NAME = "validacoes.log";
    private static final String SYSTEM_EXECDIR_PROP = "Server.system.exec.dir";
    private static final String PRJ_BASEDIR_PROP = "ProjectService.base.project.dir";
    private static final String ALGO_BASEDIR_PROP = "AlgorithmService.base.algorithm.dir";
    public static final String SAMPLE_PROPERTIES_FILE = "validations_sys" + File.separatorChar + "System.properties" + ".default";
    private File baseProjectDir;
    private File baseAlgorithmDir;
    private File baseExecutionDir;
    private List<AbstractValidation> validations;
    private boolean validateOnly;
    private Properties systemProperties;
    private ValidationsLogger logger;
    private String currDir;
    private boolean readyToRun;
    private String instTempDirPath;
    private boolean verboseMode;
    private final Set<AbstractValidation> skippedValidations = new HashSet<AbstractValidation>();

    private Validator(String[] args) {
        this.currDir = System.getProperty("user.dir");
        this.logger = new ValidationsLogger();
        this.readyToRun = this.processArgs(args) && this.registerValidations();
    }

    private boolean prepareTempDir() {
        this.instTempDirPath = this.getMandatorySystemProperty(VALIDATIONS_TEMP_DIR);
        if (this.instTempDirPath == null) {
            return false;
        }
        File tempDirFile = new File(this.instTempDirPath);
        if (!tempDirFile.exists()) {
            if (!tempDirFile.mkdir()) {
                this.logger.severe("N\u00e3o foi poss\u00edvel criar o diret\u00f3rio " + this.instTempDirPath + " para backups");
                return false;
            }
            this.logger.fine("Diret\u00f3rio " + this.instTempDirPath + " criado para backups");
        } else if (!tempDirFile.isDirectory()) {
            this.logger.severe(this.instTempDirPath + " n\u00e3o \u00e9 um diret\u00f3rio");
            return false;
        }
        this.logger.fine("Diret\u00f3rio tempor\u00e1rio: " + tempDirFile.getAbsolutePath());
        return true;
    }

    private final boolean checkSystemDirs() {
        if (!this.checkExecutionDir()) {
            this.logger.severe("Diret\u00f3rio de execu\u00e7\u00e3o inv\u00e1lido.");
            return false;
        }
        Console console = System.console();
        boolean askToCreateDir = console != null;
        if (!this.checkOrCreateProjectDir(askToCreateDir)) {
            this.logger.severe("Reposit\u00f3rio de projetos inv\u00e1lido.");
            return false;
        }
        if (!this.checkOrCreateAlgorithmDir(askToCreateDir)) {
            this.logger.severe("Reposit\u00f3rio de algoritmos inv\u00e1lido.");
            return false;
        }
        return true;
    }

    private final boolean checkExecutionDir() {
        this.logger.info("Verificando o diret\u00f3rio de execu\u00e7\u00e3o do sistema");
        String execDirPath = this.getMandatorySystemProperty(SYSTEM_EXECDIR_PROP);
        if (execDirPath == null) {
            return false;
        }
        File execDir = new File(execDirPath);
        if (!this.isValidExecutionDir(execDir)) {
            this.logger.severe("Diret\u00f3rio de execu\u00e7\u00e3o inv\u00e1lido (n\u00e3o \u00e9 diret\u00f3rio ou n\u00e3o \u00e9 do CSBase)");
            return false;
        }
        this.baseExecutionDir = execDir;
        this.logger.info("Diret\u00f3rio de execu\u00e7\u00e3o: OK");
        return true;
    }

    private boolean isValidExecutionDir(File execDir) {
        return FileSystemUtils.dirExists((File)execDir) && ValidatorUtils.hasChildFile(execDir, "runserver") && ValidatorUtils.hasChildFile(execDir, "runclient");
    }

    private final boolean checkOrCreateAlgorithmDir(boolean askToCreateDir) {
        this.logger.info("Verificando o reposit\u00f3rio de algoritmos");
        String baseAlgorithmPath = this.getMandatorySystemProperty(ALGO_BASEDIR_PROP);
        if (baseAlgorithmPath == null) {
            return false;
        }
        File tmpDir = new File(baseAlgorithmPath);
        File algorithmDir = null;
        if (tmpDir.isAbsolute()) {
            algorithmDir = tmpDir;
        } else if (this.baseExecutionDir != null) {
            algorithmDir = new File(this.baseExecutionDir, baseAlgorithmPath);
        } else {
            this.logger.severe("A verifica\u00e7\u00e3o do diret\u00f3rio de algoritmos depende de uma configura\u00e7\u00e3o v\u00e1lida para o diret\u00f3rio de execu\u00e7\u00e3o");
            return false;
        }
        if (!this.assureDirExists(algorithmDir, askToCreateDir)) {
            this.logger.severe("Diret\u00f3rio de algoritmos inv\u00e1lido (n\u00e3o \u00e9 diret\u00f3rio ou n\u00e3o \u00e9 do CSBase)");
            return false;
        }
        this.logger.info("Reposit\u00f3rio de algoritmos: OK");
        this.baseAlgorithmDir = algorithmDir;
        return true;
    }

    private final boolean checkOrCreateProjectDir(boolean askToCreateDir) {
        this.logger.info("Verificando o reposit\u00f3rio de projetos");
        String baseProjectPath = this.getMandatorySystemProperty(PRJ_BASEDIR_PROP);
        if (baseProjectPath == null) {
            return false;
        }
        File tmpDir = new File(baseProjectPath);
        File projectDir = null;
        if (tmpDir.isAbsolute()) {
            projectDir = tmpDir;
        } else if (this.baseExecutionDir != null) {
            projectDir = new File(this.baseExecutionDir, baseProjectPath);
        } else {
            this.logger.severe("A verifica\u00e7\u00e3o do diret\u00f3rio de projetos depende de uma configura\u00e7\u00e3o v\u00e1lida para o diret\u00f3rio de execu\u00e7\u00e3o");
            return false;
        }
        if (!this.assureDirExists(projectDir, askToCreateDir)) {
            this.logger.severe("Diret\u00f3rio de projetos inv\u00e1lido (n\u00e3o \u00e9 diret\u00f3rio ou n\u00e3o \u00e9 do CSBase)");
            return false;
        }
        this.logger.info("Reposit\u00f3rio de projetos: OK");
        this.baseProjectDir = projectDir;
        return true;
    }

    private boolean assureDirExists(File dir, boolean askToCreateDir) {
        boolean createDir;
        if (FileSystemUtils.dirExists((File)dir)) {
            return true;
        }
        this.logger.warning("O diret\u00f3rio especificado n\u00e3o existe");
        boolean bl = createDir = askToCreateDir && this.askUserToCreateDir(dir);
        if (createDir) {
            this.logger.fine("Criando o diret\u00f3rio: " + dir.getAbsolutePath());
            boolean created = dir.mkdirs();
            return created;
        }
        return false;
    }

    private boolean askUserToCreateDir(File dir) {
        Console console = System.console();
        if (console == null) {
            this.logger.severe("Este terminal n\u00e3o \u00e9 interativo");
            return false;
        }
        this.logger.warning("Deseja criar o diret\u00f3rio ");
        this.logger.warning(dir.getAbsolutePath() + " ?");
        boolean createDir = ValidatorUtils.readConfirmation(console, ValidatorUtils.Option.YES);
        System.out.println();
        return createDir;
    }

    protected final File getProjectDir() {
        return this.baseProjectDir;
    }

    protected final File getAlgorithmDir() {
        return this.baseAlgorithmDir;
    }

    private boolean registerValidations() {
        this.validations = new ArrayList<AbstractValidation>();
        if (!this.instantiateValidations(FRAMEWORK_VALIDATIONS_PACKAGE) || !this.instantiateValidations(SYSTEM_VALIDATIONS_PACKAGE)) {
            return false;
        }
        Collections.sort(this.validations, new Comparator<AbstractValidation>(){

            @Override
            public int compare(AbstractValidation v12, AbstractValidation v2) {
                return Validator.this.getValidationName(v12).compareTo(Validator.this.getValidationName(v2));
            }
        });
        this.logger.fine("Valida\u00e7\u00f5es:");
        for (AbstractValidation val : this.validations) {
            this.logger.fine("    " + this.getValidationName(val));
        }
        return true;
    }

    private boolean instantiateValidations(String pkg) {
        for (String className : this.getValidationsNames(pkg)) {
            try {
                Class<?> valClass = Class.forName(className);
                if (Modifier.isAbstract(valClass.getModifiers()) || !AbstractValidation.class.isAssignableFrom(valClass)) {
                    this.logger.warning("Ignorando valida\u00e7\u00e3o " + className);
                    continue;
                }
                this.validations.add((AbstractValidation)valClass.newInstance());
            }
            catch (Exception e) {
                this.logger.severe("N\u00e3o foi poss\u00edvel instanciar valida\u00e7\u00e3o " + className);
                this.logger.severe("Erro: " + e.getClass().getSimpleName());
                return false;
            }
        }
        if (this.validations.isEmpty()) {
            this.logger.severe("N\u00e3o foram encontradas valida\u00e7\u00f5es para esta instala\u00e7\u00e3o");
            return false;
        }
        return true;
    }

    private List<String> getValidationsNames(final String pkg) {
        final ArrayList<String> namesList = new ArrayList<String>();
        File directory = new File(this.currDir + File.separatorChar + pkg);
        if (!directory.exists()) {
            return namesList;
        }
        directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(".class") && name.indexOf(36) == -1) {
                    String n = name.substring(0, name.indexOf(46));
                    namesList.add(pkg + '.' + n);
                }
                return false;
            }
        });
        return namesList;
    }

    private boolean processArgs(String[] args) {
        CLOptions options = new CLOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
            return false;
        }
        this.verboseMode = options.verboseMode;
        this.validateOnly = options.validateOnly;
        File logFile = options.logFile;
        File propertiesFile = options.propertiesFile;
        if (propertiesFile == null) {
            propertiesFile = this.getPropertiesFile();
        }
        if (propertiesFile != null && !FileSystemUtils.fileExists((File)propertiesFile)) {
            this.logger.severe("Arquivo de propriedades " + propertiesFile.getPath() + " n\u00e3o existe");
            return false;
        }
        if (!this.readSystemDefaultProperties(propertiesFile)) {
            return false;
        }
        if (!this.checkSystemDirs()) {
            return false;
        }
        if (!this.prepareTempDir()) {
            return false;
        }
        if (!this.configureLogger(this.verboseMode, logFile)) {
            return false;
        }
        this.logger.blank(Level.FINE);
        this.logger.fine(Calendar.getInstance().getTime().toString());
        return true;
    }

    private boolean configureLogger(boolean isVerbosed, File logFile) {
        String logFilePath;
        this.logger.setConsoleLevel(isVerbosed ? Level.FINE : Level.INFO);
        if (logFile != null) {
            if (!FileSystemUtils.fileExists((File)logFile)) {
                this.logger.severe("Arquivo de log " + logFile.getPath() + " n\u00e3o existe");
                return false;
            }
            logFilePath = logFile.getAbsolutePath();
        } else {
            logFilePath = this.getSystemProperty(LOGPATH_PROPERTY_NAME);
            if (logFilePath == null) {
                logFilePath = this.getTempDirPath() + File.separatorChar + DEFAULT_LOGFILE_NAME;
            }
        }
        return this.logger.setFileHandler(logFilePath);
    }

    private File getPropertiesFile() {
        this.logger.warning("N\u00e3o foi fornecido path para o arquivo de propriedades.");
        Console console = System.console();
        if (console == null) {
            this.logger.severe("Este terminal n\u00e3o \u00e9 interativo");
            return null;
        }
        boolean copySample = false;
        if (FileSystemUtils.fileExists((String)SAMPLE_PROPERTIES_FILE)) {
            this.logger.warning("Deseja criar um novo arquivo de propriedades a partir de ");
            this.logger.warning(SAMPLE_PROPERTIES_FILE + " ?");
            copySample = ValidatorUtils.readConfirmation(console, ValidatorUtils.Option.YES);
            System.out.println();
        }
        this.logger.warning("Forne\u00e7a o path para o arquivo de propriedades.");
        this.logger.warning("O path deve ser absoluto, ou relativo ao diret\u00f3rio");
        this.logger.warning(this.currDir);
        this.logger.warning("e deve incluir o nome do arquivo.");
        String path = ValidatorUtils.readLine(console, "  > ");
        System.out.println();
        if (copySample) {
            if (FileSystemUtils.fileExists((String)path)) {
                this.logger.warning("O arquivo j\u00e1 existe. Deseja sobrescrev\u00ea-lo?");
                boolean overwrite = ValidatorUtils.readConfirmation(console, ValidatorUtils.Option.YES);
                if (!overwrite) {
                    this.logger.severe("Opera\u00e7\u00e3o abortada pelo usu\u00e1rio");
                    return null;
                }
                this.logger.info("Sobrescrevendo o arquivo de propriedades " + path);
            } else {
                this.logger.info("Criando o arquivo de propriedades " + path);
            }
            if (!ValidatorUtils.copyFile(SAMPLE_PROPERTIES_FILE, path, this.logger)) {
                return null;
            }
        }
        return new File(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSystemDefaultProperties(File propertiesFile) {
        if (propertiesFile == null) {
            return false;
        }
        if (!propertiesFile.exists()) {
            this.logger.severe("Arquivo de propriedades " + propertiesFile + " n\u00e3o existe");
            return false;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(propertiesFile));
            this.systemProperties = new Properties();
            this.systemProperties.load(in);
        }
        catch (Exception e) {
            this.logger.severe("Erro lendo arquivo de propriedades do sistema");
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        this.logger.info("Arquivo de propriedades: " + propertiesFile.getPath());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run() {
        try {
            if (!this.readyToRun) {
                this.logger.separator(Level.SEVERE);
                this.logger.severe("*** ERRO NA CONFIGURA\u00c7\u00c3O DAS VALIDA\u00c7\u00d5ES");
                boolean bl = false;
                return bl;
            }
            boolean allOK = true;
            AbstractValidation lastValidation = null;
            try {
                for (AbstractValidation validation : this.validations) {
                    if (validation.runsOnlyOnce() && this.hasAlreadyRun(validation)) {
                        this.skippedValidations.add(validation);
                        continue;
                    }
                    boolean succeeded = validation.run(this);
                    validation.reportStatus();
                    lastValidation = validation;
                    if (succeeded) {
                        if (!validation.runsOnlyOnce()) continue;
                        this.createValidationMarker(validation);
                        continue;
                    }
                    allOK = false;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.exception(e);
                allOK = false;
            }
            if (allOK) {
                this.logger.info("Valida\u00e7\u00e3o da instala\u00e7\u00e3o: OK");
                this.removeBackups();
            } else {
                this.logger.severe("Valida\u00e7\u00e3o da instala\u00e7\u00e3o: *** ERRO ***");
                AbstractValidation.Status status = lastValidation.getStatus();
                if (status == AbstractValidation.Status.BACKUP_FAILED) {
                    this.removeBackups();
                } else if (!this.validateOnly && status == AbstractValidation.Status.PATCH_FAILED) {
                    this.removeValidationMarkers(lastValidation);
                    if (this.rollback(lastValidation)) {
                        this.logger.separator(Level.SEVERE);
                        this.logger.severe("*** TODAS AS ATUALIZA\u00c7\u00d5ES FORAM DESFEITAS COM SUCESSO");
                        this.logger.severe("*** O SISTEMA N\u00c3O PODE SER EXECUTADO NA VERS\u00c3O ATUAL");
                        this.logger.severe("*** CORRIJA O PROBLEMA OU REINSTALE A VERS\u00c3O ANTERIOR");
                    } else {
                        this.logger.severe("*** ALGUMAS ATUALIZA\u00c7\u00d5ES N\u00c3O PUDERAM SER DESFEITAS");
                        this.logger.severe("*** O SISTEMA N\u00c3O PODE SER EXECUTADO NA VERS\u00c3O ATUAL");
                        this.logger.severe("*** N\u00c3O \u00c9 POSS\u00cdVEL REINSTALAR A VERS\u00c3O ANTERIOR");
                        this.logger.severe("*** CONTACTE A EQUIPE DE DESENVOLVIMENTO");
                    }
                }
                System.err.println();
                this.logger.toConsole("O registro das convers\u00f5es foi anexado ao arquivo ");
                this.logger.toConsole(this.logger.getLogFilePath());
            }
            boolean bl = allOK;
            return bl;
        }
        finally {
            this.logger.close();
        }
    }

    private String getValidationName(AbstractValidation validation) {
        return validation.getClass().getSimpleName();
    }

    private File getValidationMarkerFile(AbstractValidation validation) {
        return new File(this.getTempDirPath(), this.getValidationName(validation) + VALIDATION_MARKER_EXTENSION);
    }

    private boolean hasAlreadyRun(AbstractValidation validation) {
        File markerFile = this.getValidationMarkerFile(validation);
        if (!markerFile.exists()) {
            return false;
        }
        Date lastModified = new Date(markerFile.lastModified());
        String timestamp = DateFormat.getDateInstance(2).format(lastModified);
        String validationName = this.getValidationName(validation);
        this.logger.info(String.format("Valida\u00e7\u00e3o j\u00e1 executada em %s : %s", timestamp, validationName));
        return true;
    }

    private void createValidationMarker(AbstractValidation validation) {
        File validationFile = this.getValidationMarkerFile(validation);
        try {
            validationFile.createNewFile();
        }
        catch (IOException e) {
            String validationName = this.getValidationName(validation);
            this.logger.exception("Erro criando marcador para " + validationName, e);
        }
    }

    private void removeValidationMarkers(AbstractValidation lastValidation) {
        for (int i = this.validations.indexOf(lastValidation); i >= 0; --i) {
            File validationMarker;
            AbstractValidation val = this.validations.get(i);
            if (!val.runsOnlyOnce() || !(validationMarker = this.getValidationMarkerFile(val)).exists() || validationMarker.delete()) continue;
            this.logger.severe("Erro ao remover o marcador de " + this.getValidationName(val));
        }
    }

    private void removeBackups() {
        try {
            for (AbstractValidation validation : this.validations) {
                if (this.skippedValidations.contains(validation)) continue;
                validation.removeBackupDir();
            }
        }
        catch (Exception e) {
            this.logger.exception("Erro removendo backups", e);
        }
    }

    private boolean rollback(AbstractValidation lastValidation) {
        try {
            this.logger.sectionSeparator(Level.INFO);
            for (int i = this.validations.indexOf(lastValidation); i >= 0; --i) {
                AbstractValidation val = this.validations.get(i);
                if (this.skippedValidations.contains(val)) continue;
                String validationName = this.getValidationName(val);
                this.logger.info(validationName + " : desfazendo altera\u00e7\u00f5es");
                if (!val.rollback()) {
                    this.logger.severe(validationName + " : ERRO");
                    return false;
                }
                this.logger.info(validationName + " : OK");
                val.removeBackupDir();
            }
        }
        catch (Exception e) {
            this.logger.exception("Erro restaurando backups de " + lastValidation.getClass().getSimpleName(), e);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println();
        Validator validator = new Validator(args);
        int status = validator.run() ? 0 : 1;
        System.exit(status);
    }

    public String getTempDirPath() {
        return this.instTempDirPath;
    }

    public ValidationsLogger getLogger() {
        return this.logger;
    }

    public String getSystemProperty(String propName) {
        String value = this.systemProperties.getProperty(propName);
        if (value == null) {
            return null;
        }
        String trimmedValue = value.trim();
        return trimmedValue;
    }

    public String getMandatorySystemProperty(String propName) {
        String value = this.systemProperties.getProperty(propName);
        if (value == null) {
            String msg = "Prop. obrigat\u00f3ria [" + propName + "] indefinida.";
            this.logger.severe(msg);
            return null;
        }
        String trimmedValue = value.trim();
        return trimmedValue;
    }

    public boolean isValidatingOnly() {
        return this.validateOnly;
    }

    public boolean isVerbose() {
        return this.verboseMode;
    }

    private static class CLOptions {
        @Option(name="-V", usage="apenas valida a instala\u00e7\u00e3o (n\u00e3o faz mudan\u00e7as)")
        boolean validateOnly = false;
        @Option(name="-v", usage="modo verbose")
        boolean verboseMode = false;
        @Option(name="-l", usage="path para o arquivo de log da valida\u00e7\u00e3o")
        File logFile = null;
        @Option(name="-p", usage="path para o arquivo global de propriedades")
        File propertiesFile = null;

        private CLOptions() {
        }
    }
}

