#include <stdio.h>
#include <stdlib.h>
//#include <string.h>
#include <assert.h>

#ifdef WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <direct.h>
#include <windows.h>
#include <io.h>
#else
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#endif


//#define lua_setstringindexed(o,n,v) (lua_pushobject(o), \
//        lua_pushnumber(n), lua_pushstring(v), lua_settable())

static char comm_buffer[128];

// ======================================================================
// ======================================================================
// ======================================================================

#if 0
static int _ren(const char* fromName, const char* toName) {
#ifdef WIN32
   return MoveFileEx(fromName, toName, 
      MOVEFILE_WRITE_THROUGH | MOVEFILE_COPY_ALLOWED);
#else
   sprintf(comm_buffer, "/bin/mv %s %s", fromName, toName);
   int status = system(comm_buffer);
   if (status != 0) return 0;
   return 1;
#endif
}


static int _rmfile(const char* fileName) {
#ifdef WIN32
   return DeleteFile(fileName);
#else
   sprintf(comm_buffer, "/bin/rm -f %s", fileName);
   int status = system(comm_buffer);
   if (status != 0) return 0;
   return 1;
#endif
}

// ......................................................................

static int _rmdir(const char* dirName) {
#ifdef WIN32
   return RemoveDirectory(dirName);
#else
   sprintf(comm_buffer, "/bin/rmdir %s", dirName);
   int status = system(comm_buffer);
   if (status != 0) return 0;
   return 1;
#endif
}

// ......................................................................

static int _mkdir(const char* dirName) {
#ifdef WIN32
   return CreateDirectory(dirName, NULL);
#else
   sprintf(comm_buffer, "/bin/mkdir %s", dirName);
   int status = system(comm_buffer);
   if (status != 0) return 0;
   return 1;
#endif
}

// ......................................................................

// ======================================================================
// ======================================================================
// ======================================================================

// ......................................................................

static int lua_mkDir(lua_State* L) {
   char *dirName = (char *)lua_tostring(L, 1);
   int status = _mkdir((const char*)dirName);
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_chDirUp(lua_State* L) {
#ifdef WIN32
   int status = _chdir((const char*)"..");
#else
   int status = chdir((const char*)"..");
#endif
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_renItem(lua_State* L) {
   char* fromName = (char *)lua_tostring(L, 1);
   char* toName = (char *)lua_tostring(L, 2);
   int status = _ren(fromName, toName);
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_chDir(lua_State* L) {
   char *dirName = (char *)lua_tostring(L, 1);
#ifdef WIN32
   int status = _chdir((const char*)dirName);
#else
   int status = chdir((const char*)dirName);
#endif
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_fileSize(lua_State* L) {
   char *fileName = (char *)lua_tostring(L, 1);
   FILE* file;
   unsigned long fileSize;
   unsigned long currPosition;

   file = fopen(fileName, "rb");
   if (!file) {
      lua_pushnumber(L, -1.0);
      return 1;
   }

   currPosition = ftell(file);
   fseek(file, 0L, SEEK_END);
   fileSize = ftell(file);
   fseek(file, currPosition, SEEK_SET);

   fclose(file);
   lua_pushnumber(L, fileSize);
   return 1;
}

// ......................................................................

static int lua_listDir(lua_State* L) {
#ifdef WIN32
  HANDLE FileFile;
  WIN32_FIND_DATA inf;
  BOOL Find = true;

  /* prepara a mascara */
  char* mask = ".\\\\*";
  FileFile = FindFirstFile(mask, &inf);

  /* Se nao achou o FindFirstFile */
  if (FileFile == INVALID_HANDLE_VALUE) {
     lua_newtable(L);
     return 1;
  }

  lua_newtable(L);
  Find = FindNextFile(FileFile, &inf);
  int idx = 1;
  while (Find) {
    lua_newtable(L);
    lua_pushstring(L, "name");
    lua_pushstring(L, inf.cFileName);
    lua_settable(L, -3);

    /* verifica se  diretorio */
    lua_pushstring(L, "is_directory");
    if (inf.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) lua_pushnumber(L, 1.0);
    else lua_pushnil(L);
    lua_settable(L, -3);

    Find = FindNextFile (FileFile, &inf);  
    if (!Find && GetLastError() != ERROR_NO_MORE_FILES) {
       FindClose(FileFile);
       lua_newtable(L);
       return 1;
    }
    else {
      assert(lua_istable(L, -1));
      assert(lua_istable(L, -2));
      lua_rawseti(L, -2, idx);
      idx++;
    }
  }
  FindClose(FileFile);
  return 1;

#else
   DIR* current = opendir((const char*)".");
   if (current == NULL) return 0;
   struct dirent* dir = readdir(current);
   if (dir == NULL) return 0;
   lua_newtable(L);
   int idx = 1;
   while (dir != NULL) {
      struct stat status;
      int flag = stat(dir->d_name, &status);
      lua_newtable(L);
      if (flag == 0) {
         lua_pushstring(L, "is_directory");
         if (S_ISDIR(status.st_mode)) lua_pushnumber(L, 1.0);
         else lua_pushnil(L);
         lua_settable(L, -3);

         lua_pushstring(L, "name");
         lua_pushstring(L, dir->d_name);
         lua_settable(L, -3);
      }
      assert(lua_istable(L, -1));
      assert(lua_istable(L, -2));
      lua_rawseti(L, -2, idx);

      dir = readdir(current);
      idx++;
   }
   closedir(current);
#endif
   return 1;
}

// ......................................................................

static int lua_rmFile(lua_State* L) {
   char *fileName = (char *)lua_tostring(L, 1);
   int status = _rmfile((const char*)fileName);
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_rmDir(lua_State* L) {
   char* dirName = (char*)lua_tostring(L, 1);
   int status = _rmdir((const char*)dirName);
   lua_pushnumber(L, status);
   return 1;
}

// ......................................................................

static int lua_confirmMessage(lua_State* L) {
   char* title = (char*)lua_tostring(L, 1);
   char* msg = (char*)lua_tostring(L, 2);
   char* icon = (char*)lua_tostring(L, 3);
   char* label1 = (char*)lua_tostring(L, 4);
   char* label2 = (char*)lua_tostring(L, 5);

   int option = MacGetOption("main_dialog", title, icon, 
       label1, label2, NULL, msg);
   lua_pushnumber(L, option);
   return 1;
}


// ......................................................................

static void lua_showMessage(void) {
   lua_Object p1 = lua_getparam(1);
   lua_Object p2 = lua_getparam(2);
   lua_Object p3 = lua_getparam(3);
   if (!lua_isstring(p1) || !lua_isstring(p2) || !lua_isstring(p3)) {
      lua_pushnil();
      return;
   }
   char* title = (char*)lua_getstring(p1);
   char* msg = (char*)lua_getstring(p2);
   char* icon = (char*)lua_getstring(p3);

   MacShowMessage("main_dialog", title, icon, msg);
   return;
}
#endif
