#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <iup.h>
#include <iupcontrols.h>

#include <iupfilechooser.h>

// ======================================================================

int main(int argc, char* argv[]) {

  char* selectedFile = NULL;
  Ihandle* dialog = NULL;
  char* status = NULL;
  char* dir = NULL;
  char* filter = NULL;
  
  IupOpen();
  IupControlsOpen();

  IupFileChooserOpen();
  dialog = IupFileChooser();

  //IupFileChooserSetAttribute(dialog, IUP_DIRECTORY, "d:/users/rodesp/filechooser");
  IupFileChooserSetAttribute(dialog, IUP_DIRECTORY, "c:/Program Files");
  //IupFileChooserSetAttribute(dialog, IUP_DIRECTORY, "c:/teste");
  IupFileChooserSetAttribute(dialog, IUP_DIALOGTYPE, IUP_OPEN);
  IupFileChooserSetAttribute(dialog, IUP_FILTER, "*.exe");

  IupFileChooserPopup(dialog, IUP_CENTER, IUP_CENTER); 

  printf("\n");
  selectedFile = IupGetAttribute(dialog, IUP_VALUE);
  if (selectedFile != NULL && strcmp(selectedFile, "") != 0){
    printf("Arquivo selecionado: %s\n", selectedFile);
    free(selectedFile);
  }
  status = IupGetAttribute(dialog, IUP_STATUS);
  printf("Status de arquivo (0: normal, 1: novo, -1: operacao cancelada): %s\n", status);

  dir = IupGetAttribute(dialog, IUP_DIRECTORY);
  printf("Diretorio corrente: %s\n", strdup(dir));
  
  filter = IupGetAttribute(dialog, IUP_FILTERINFO);
  printf("Filtro info: %s\n", filter);
  filter = IupGetAttribute(dialog, IUP_FILTER);
  printf("Filter: %s\n", filter);
  filter = IupGetAttribute(dialog, IUP_EXTFILTER);
  printf("Extfilter: %s\n", filter);
 
  /*dialog = IupFileChooser();

  IupSetAttribute(dialog, IUP_DIRECTORY, "/home/i/tati/tecgraf/integrador/csbase");
  IupPopup(dialog, IUP_CENTER, IUP_CENTER);
  selectedFile = IupGetAttribute(dialog, IUP_VALUE);
  printf("\nNovo arquivo selecionado: %s\n", selectedFile);
  status = IupGetAttribute(dialog, IUP_STATUS);
  printf("Status de arquivo (0: normal, 1: novo, -1: operacao cancelada): %s\n", status);
  */

  IupFileChooserDestroy(dialog);
  IupClose();
  
  printf("\nFIM\n");
  
  return 0;
}

// ======================================================================
// ======================================================================
