package Demo;

import Requests.Algorithms.Algorithm;
import Requests.Algorithms.AlgorithmExplorer;
import Requests.Authentication.Authentication;
import Requests.Authentication.InvalidLoginOrPasswordException;
import Requests.Authentication.LoginOrPasswordNotProvidedException;
import Requests.Authentication.Token;
import Requests.Jobs.JobInfo;
import Requests.Jobs.JobServices;
import Requests.Projects.*;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class CommandSubmissionClient {

	private static final String ALGORITHM = "multmatrix";
	private static final String REMOTE_INPUT_FILE_1 = "data_1.in";
	private static final String REMOTE_INPUT_FILE_2 = "data_2.in";
	private static final String REMOTE_OUTPUT_FILE = "result.out";

	/**
	 * Nome do arquivo com as propriedades para a demo
	 */
	private static String configFileName = "config.properties";

	/*
	 * Assertivas:
	 * - usuário já cadastrado
	 * - projeto previamente criado
	 * - usuário é o dono do projeto
	 * - algoritmo multmatrix cadastrado
	 * - arquivos de entrada disponiveis localmente
	 * - caminho válido para arquivo de saída a ser criado localmente
	 * - alguma maquina remota disponivel para executar
	 */
	public static void main(String[] args) {
		System.out.println("-- Inicio da demo");

		Properties props = new Properties();
		if (args.length>0) {
			configFileName = args[0];
			try {
				InputStream input = new FileInputStream(configFileName);
				props.load(input);
				System.out.println("Propriedades carregadas de " + configFileName);

			} catch (Exception e) {
				System.out.println ("Erro na leitura do arquivo " + configFileName);
				System.exit(1);
			}
		} else {
			InputStream input = CommandSubmissionClient.class.getClassLoader().getResourceAsStream(configFileName);
			try {
				props.load(input);
				System.out.println("Propriedades default carregadas");
			} catch (Exception e) {
				System.out.println ("Erro na leitura do arquivo default " + configFileName);
				System.exit(1);
			}
		}
		String host = props.getProperty("host");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade host e' obrigatoria");
			System.exit(1);
		}
		String username = props.getProperty("username");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade username e' obrigatoria");
			System.exit(1);
		}
		String password = props.getProperty("password");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade password e' obrigatoria");
			System.exit(1);
		}
		String projectName = username + "/" + props.getProperty("project");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade project e' obrigatoria");
			System.exit(1);
		}
		String projectFolderPath = props.getProperty("projectFolderPath");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade projectFolderPath e' obrigatoria");
			System.exit(1);
		}
		String toUploadFilePath1 = props.getProperty("input_file_1");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade input_file_1 e' obrigatoria");
			System.exit(1);
		}
		String toUploadFilePath2 = props.getProperty("input_file_2");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade input_file_2 e' obrigatoria");
			System.exit(1);
		}
		String toSaveFilePath = props.getProperty("output_file");
		if (host==null || host.isEmpty()) {
			System.out.println ("A propriedade output_file e' obrigatoria");
			System.exit(1);
		}

		try {
			/*
			 * Autentica o usuario com login e senha configurados na demo
			 */
			Token token = Authentication.authenticate(host, username, password);

			/*
			 * Procura o projeto com o nome configurado na demo
			 */
			Project project = ProjectExplorer.findProjectByName(host, token, projectName);
			if (project==null) {
				System.out.println("Projeto " + projectName + " nao encontrado");
				System.exit(1);
			}
			System.out.println("Projeto " + projectName + " encontrado");

			/*
			 * Procura o algoritmo com o nome configurado na demo
			 */
			Algorithm algorithm = AlgorithmExplorer.findAlgorithmByName(host, token, ALGORITHM);
			if (algorithm==null) {
				System.out.println("Algoritmo " + ALGORITHM + " nao encontrado");
				System.exit(1);
			}
			System.out.println("Algoritmo " + ALGORITHM + " encontrado");

			/*
			 * Faz o upload dos dados de entrada na raiz do projeto
			 */
			FileExplorer.uploadFile(host, token, project, projectFolderPath, toUploadFilePath1, REMOTE_INPUT_FILE_1);
			FileExplorer.uploadFile(host, token, project, projectFolderPath, toUploadFilePath2, REMOTE_INPUT_FILE_2);

			/*
			 * Executa o algoritmo Multmatrix
			 */
			Map<String, String> commandArgs = new HashMap<>();
			commandArgs.put("matrix1", REMOTE_INPUT_FILE_1);
			commandArgs.put("matrix2", REMOTE_INPUT_FILE_2);
			commandArgs.put("result", REMOTE_OUTPUT_FILE);
			String jobId = JobServices.submitJob(host, token, project, algorithm, algorithm.getVersions().get(0),
					"demo rest java", 0, false, new String[0], commandArgs);
			if (jobId==null) {
				System.out.println("Falha na submissao do algoritmo " + ALGORITHM);
				System.exit(1);
			}
			System.out.println("Algoritmo " + ALGORITHM + " submetido com sucesso");

			JobInfo jinfo = JobServices.getJobInfo(host, token, jobId);
			if (jinfo==null) {
				System.out.println("Job "+ jobId + " nao foi encontrado");
				System.exit(1);
			}
			System.out.println("Job " + jobId + " encontrado");

			/**
			 * Aguarda o job terminar sua execução
			 */
			JobServices.awaitJobEnd(host, token, jinfo);

			/**
			 * Faz download do arquivo de saída (quando o arquivo é pequeno)
			 */
			String result = FileExplorer.downloadFile(host, token, project, projectFolderPath, REMOTE_OUTPUT_FILE);
			System.out.println("Resultado em " + REMOTE_OUTPUT_FILE + ":\n"+result);

			/**
			 * Faz download do arquivo de saída (quando o arquivo é grande)
			 */
			FileExplorer.downloadLargeFile(host, token, project, projectFolderPath, REMOTE_OUTPUT_FILE, toSaveFilePath);

		} catch (LoginOrPasswordNotProvidedException e) {
			e.printStackTrace();
		} catch (InvalidLoginOrPasswordException e) {
			e.printStackTrace();
		} catch (ProjectOrFileNotFoundException e) {
			e.printStackTrace();
		} catch (PermissionException e) {
			e.printStackTrace();
		}
	}
}
