/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import java.io.IOException;
import org.jacorb.util.tracing.MSecHelper;
import org.jacorb.util.tracing.PointIdHelper;
import org.jacorb.util.tracing.TraceData;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class TraceDataHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<TraceDataHelper> clazz = TraceDataHelper.class;
        synchronized (TraceDataHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(TraceDataHelper.id(), "TraceData", new StructMember[]{new StructMember("subtrace", ORB.init().create_sequence_tc(0, ORB.init().create_recursive_tc("IDL:org/jacorb/util/tracing/TraceData:1.0")), null), new StructMember("tracer_id", ORB.init().create_alias_tc(PointIdHelper.id(), "PointId", ORB.init().get_primitive_tc(TCKind.from_int((int)3))), null), new StructMember("operation", ORB.init().create_string_tc(0), null), new StructMember("client_time", ORB.init().create_alias_tc(MSecHelper.id(), "MSec", ORB.init().get_primitive_tc(TCKind.from_int((int)23))), null), new StructMember("trace_system_time", ORB.init().create_alias_tc(MSecHelper.id(), "MSec", ORB.init().get_primitive_tc(TCKind.from_int((int)23))), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    public static void insert(Any any, TraceData s) {
        any.type(TraceDataHelper.type());
        TraceDataHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceData extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            TraceData traceData = TraceDataHelper.read(in);
            return traceData;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:org/jacorb/util/tracing/TraceData:1.0";
    }

    public static TraceData read(InputStream in) {
        TraceData result = new TraceData();
        int _lresult_subtrace0 = in.read_long();
        try {
            int x = in.available();
            if (x > 0 && _lresult_subtrace0 > x) {
                throw new MARSHAL("Sequence length too large. Only " + x + " available and trying to assign " + _lresult_subtrace0);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        result.subtrace = new TraceData[_lresult_subtrace0];
        for (int i = 0; i < result.subtrace.length; ++i) {
            result.subtrace[i] = TraceDataHelper.read(in);
        }
        result.tracer_id = in.read_long();
        result.operation = in.read_string();
        result.client_time = in.read_longlong();
        result.trace_system_time = in.read_longlong();
        return result;
    }

    public static void write(OutputStream out, TraceData s) {
        out.write_long(s.subtrace.length);
        for (int i = 0; i < s.subtrace.length; ++i) {
            TraceDataHelper.write(out, s.subtrace[i]);
        }
        out.write_long(s.tracer_id);
        String tmpResult0 = s.operation;
        out.write_string(tmpResult0);
        out.write_longlong(s.client_time);
        out.write_longlong(s.trace_system_time);
    }
}

