/*
 * Decompiled with CFR 0.152.
 */
package csfs.test;

import csfs.impl.util.SystemProperties;
import csfs.remote.ChannelOperations;
import csfs.remote.ClosedChannelException;
import csfs.remote.FileAlreadyExistsException;
import csfs.remote.FileInUseException;
import csfs.remote.FileNotFoundException;
import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import csfs.remote.InvalidPathException;
import csfs.remote.InvalidStateException;
import csfs.remote.NotDirectoryException;
import csfs.remote.NotEmptyException;
import csfs.remote.NotFileException;
import csfs.remote.OctetSequenceHolder;
import csfs.remote.RandomAccessChannel;
import csfs.remote.ReadChannel;
import csfs.remote.RemoteFile;
import csfs.remote.RemoteFileOperations;
import csfs.remote.ServerException;
import csfs.remote.WriteChannel;
import java.io.BufferedReader;
import java.io.FileReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Vector;
import junit.framework.TestCase;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class TestRemoteFileDefaultServantImpl
extends TestCase {
    private RemoteFile root = null;

    public TestRemoteFileDefaultServantImpl() throws Exception {
        ORB orb = ORB.init((String[])null, null);
        String iorFile = SystemProperties.getProperty("IOR_FILE");
        BufferedReader br = new BufferedReader(new FileReader(iorFile));
        Object obj = orb.string_to_object(br.readLine());
        br.close();
        FileServer fileServer = FileServerHelper.narrow(obj);
        this.root = fileServer.getRoot();
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.root.getChildren().length > 0) {
            throw new Exception("There are files inside root! Can not perform the test in this situation!!!");
        }
    }

    protected void tearDown() throws Exception {
        RemoteFile[] children = this.root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.recursiveRemove(children[i]);
        }
        super.tearDown();
    }

    private void recursiveRemove(RemoteFile treeRoot) throws Exception {
        Vector<RemoteFile> elements = new Vector<RemoteFile>();
        elements.add(treeRoot);
        for (int index = 0; index < elements.size(); ++index) {
            RemoteFile remoteFile = (RemoteFile)elements.elementAt(index);
            if (!remoteFile.isDirectory()) continue;
            RemoteFile[] children = remoteFile.getChildren();
            elements.addAll(Arrays.asList(children));
        }
        for (int i = elements.size() - 1; i != -1; --i) {
            RemoteFile remoteFile = (RemoteFile)elements.elementAt(i);
            remoteFile.remove();
        }
    }

    private boolean assertEquals(String[] expected, String[] actual) {
        boolean response = true;
        if (expected.length == actual.length) {
            for (int i = 0; i < expected.length && response; ++i) {
                response = expected[i].equals(actual[i]);
            }
        } else {
            response = false;
        }
        return response;
    }

    public void testCreateDirectory() {
        try {
            String[] nameA = new String[]{"A"};
            RemoteFile actualReturnA = this.root.createDirectory(nameA);
            String[] actualNameA = actualReturnA.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)actualReturnA.isDirectory());
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameA, actualNameA));
            try {
                RemoteFile dup = this.root.createDirectory(nameA);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileAlreadyExistsException exc) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameA, exc.name));
            }
            String[] nameA_A1 = new String[]{"A", "A1"};
            RemoteFile actualReturnA_A1 = this.root.createDirectory(nameA_A1);
            String[] actualNameA_A1 = actualReturnA_A1.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)actualReturnA_A1.isDirectory());
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameA_A1, actualNameA_A1));
            try {
                RemoteFile dup = this.root.createDirectory(nameA_A1);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileAlreadyExistsException exc) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameA_A1, exc.name));
            }
            String[] nameB_B1_B11 = new String[]{"B", "B1", "B11"};
            RemoteFile actualReturnB_B1_B11 = this.root.createDirectory(nameB_B1_B11);
            String[] actualNameB_B1_B11 = actualReturnB_B1_B11.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)actualReturnB_B1_B11.isDirectory());
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameB_B1_B11, actualNameB_B1_B11));
            String[] partialDup = new String[]{"B", "B1"};
            try {
                RemoteFile dup = this.root.createDirectory(partialDup);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileAlreadyExistsException exc) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(partialDup, exc.name));
            }
            String[] outOfRoot = new String[]{".."};
            try {
                RemoteFile outOfRootFile = this.root.createDirectory(outOfRoot);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidPathException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(outOfRoot, ex.name));
            }
            String[] file = new String[]{"someDir", "anotherDir", "file"};
            String[] dir = new String[]{"dir"};
            RemoteFile remoteFile = this.root.createFile(file);
            try {
                remoteFile.createDirectory(dir);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (NotDirectoryException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(file, ex.name));
            }
            String[] dirH = new String[]{"H"};
            try {
                RemoteFile first = this.root.createDirectory(dirH);
                RemoteFile grabber = this.root.getChild(dirH);
                grabber.remove();
                first.createDirectory(new String[]{"dir"});
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidStateException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirH, ex.name));
            }
            catch (Exception exc) {
                TestRemoteFileDefaultServantImpl.fail();
                exc.printStackTrace();
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                String[] badName = new String[]{"a?1"};
                try {
                    RemoteFile badFile = this.root.createDirectory(badName);
                    TestRemoteFileDefaultServantImpl.fail();
                }
                catch (InvalidPathException ex) {
                    TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(badName, ex.name));
                }
                String[] badName2 = new String[]{"someDirWrong", "a?1"};
                try {
                    RemoteFile badFile = this.root.createDirectory(badName2);
                    TestRemoteFileDefaultServantImpl.fail();
                }
                catch (InvalidPathException ex) {
                    TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(badName2, ex.name));
                }
            }
            String[] wrongDirSlash = new String[]{"dir1/dir2"};
            try {
                this.root.createDirectory(wrongDirSlash);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidPathException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(wrongDirSlash, ex.name));
            }
            String[] wrongDirBackSlash = new String[]{"dir1\\dir2"};
            try {
                this.root.createDirectory(wrongDirBackSlash);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidPathException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(wrongDirBackSlash, ex.name));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            TestRemoteFileDefaultServantImpl.fail();
        }
    }

    public void testCreateFile() throws InvalidPathException, InvalidStateException, FileAlreadyExistsException, NotDirectoryException, ServerException {
        String[] fileA = new String[]{"a"};
        RemoteFile actualReturnFileA = this.root.createFile(fileA);
        String[] actualFileA = actualReturnFileA.getFullName();
        TestRemoteFileDefaultServantImpl.assertFalse((boolean)actualReturnFileA.isDirectory());
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileA, actualFileA));
        try {
            RemoteFile dup = this.root.createFile(fileA);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileAlreadyExistsException exc) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileA, exc.name));
        }
        String[] fileDir1_Dir2_A = new String[]{"dir1", "dir2", "a"};
        RemoteFile actualReturnFileDir1_Dir2_A = this.root.createFile(fileDir1_Dir2_A);
        String[] actualFileDir1_Dir2_A = actualReturnFileDir1_Dir2_A.getFullName();
        TestRemoteFileDefaultServantImpl.assertFalse((boolean)actualReturnFileDir1_Dir2_A.isDirectory());
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileDir1_Dir2_A, actualFileDir1_Dir2_A));
        try {
            RemoteFile dup = this.root.createFile(fileDir1_Dir2_A);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileAlreadyExistsException exc) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileDir1_Dir2_A, exc.name));
        }
        String[] fileDir1_A = new String[]{"dir1", "a"};
        RemoteFile actualReturnFileDir1_A = this.root.createFile(fileDir1_A);
        String[] actualFileDir1_A = actualReturnFileDir1_A.getFullName();
        TestRemoteFileDefaultServantImpl.assertFalse((boolean)actualReturnFileDir1_A.isDirectory());
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileDir1_A, actualFileDir1_A));
        try {
            RemoteFile dup = this.root.createFile(fileDir1_A);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileAlreadyExistsException exc) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileDir1_A, exc.name));
        }
        String[] outOfRoot = new String[]{"..", "root", ".."};
        try {
            RemoteFile outOfRootFile = this.root.createFile(outOfRoot);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(outOfRoot, ex.name));
        }
        String[] file = new String[]{"someDir", "anotherDir", "file"};
        String[] anotherFile = new String[]{"anotherFile"};
        RemoteFile remoteFile = this.root.createFile(file);
        try {
            remoteFile.createFile(anotherFile);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotDirectoryException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(file, ex.name));
        }
        String[] dirJ = new String[]{"J"};
        try {
            RemoteFile first = this.root.createDirectory(dirJ);
            RemoteFile grabber = this.root.getChild(dirJ);
            grabber.remove();
            first.createFile(new String[]{"file"});
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirJ, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            String[] badName = new String[]{"a?1"};
            try {
                RemoteFile badFile = this.root.createFile(badName);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidPathException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(badName, ex.name));
            }
            String[] badName2 = new String[]{"someDirWrong", "a?1"};
            try {
                RemoteFile badFile = this.root.createFile(badName2);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (InvalidPathException ex) {
                TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(badName2, ex.name));
            }
        }
        String[] wrongDirSlash = new String[]{"dir1/dir2"};
        try {
            this.root.createDirectory(wrongDirSlash);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(wrongDirSlash, ex.name));
        }
        String[] wrongDirBackSlash = new String[]{"dir1\\dir2"};
        try {
            this.root.createDirectory(wrongDirBackSlash);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(wrongDirBackSlash, ex.name));
        }
    }

    public void testGetChild() throws InvalidPathException, InvalidStateException, NotDirectoryException, FileNotFoundException, ServerException {
        String[] name = new String[]{"dir1", "dir2", "dir3", "dir4", "dir5", "file"};
        try {
            this.root.createFile(name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String[] nameDir1_Dir2 = new String[]{"dir1", "dir2"};
        RemoteFile actualReturnDir1_Dir2 = this.root.getChild(nameDir1_Dir2);
        String[] actualNameDir1_Dir2 = actualReturnDir1_Dir2.getFullName();
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(nameDir1_Dir2, actualNameDir1_Dir2));
        String[] nameDir3_Dir4_Dir5 = new String[]{"dir3", "dir4", "dir5"};
        RemoteFile actualReturnDir3_Dir4_Dir5 = actualReturnDir1_Dir2.getChild(nameDir3_Dir4_Dir5);
        String[] actualNameDir3_Dir4_Dir5 = actualReturnDir3_Dir4_Dir5.getFullName();
        String[] expectedNameDir3_Dir4_Dir5 = new String[]{"dir1", "dir2", "dir3", "dir4", "dir5"};
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(expectedNameDir3_Dir4_Dir5, actualNameDir3_Dir4_Dir5));
        String[] nameFile = new String[]{"file"};
        RemoteFile actualReturnFile = actualReturnDir3_Dir4_Dir5.getChild(nameFile);
        String[] actualNameFile = actualReturnFile.getFullName();
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(name, actualNameFile));
        try {
            actualReturnFile.getChild(new String[]{"another"});
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotDirectoryException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(name, ex.name));
        }
        RemoteFile parent = actualReturnDir3_Dir4_Dir5.getChild(new String[]{".."});
        String[] parentName = parent.getFullName();
        RemoteFile usualParent = actualReturnDir3_Dir4_Dir5.getParent();
        String[] usualParentName = usualParent.getFullName();
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(usualParentName, parentName));
        RemoteFile circle = actualReturnDir3_Dir4_Dir5.getChild(new String[]{"..", "..", "..", ".", ".", "dir3", "dir4", "dir5"});
        String[] circleName = circle.getFullName();
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(expectedNameDir3_Dir4_Dir5, circleName));
        String[] strangeName = new String[]{"g*1"};
        try {
            RemoteFile strangeFile = this.root.getChild(strangeName);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(strangeName, ex.name));
        }
        String[] regularName = new String[]{"nonExistingDir", "nonExistingFile"};
        try {
            RemoteFile regularFile = this.root.getChild(regularName);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.assertEquals((String)regularName[0], (String)ex.name[0]);
        }
        String[] regularName2 = new String[]{"dir1", "nonExistingFile"};
        try {
            RemoteFile regularFile2 = this.root.getChild(regularName2);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(regularName2, ex.name));
        }
        String[] outOfRoot = new String[]{".."};
        try {
            RemoteFile outOfRootFile = this.root.getChild(outOfRoot);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(outOfRoot, ex.name));
        }
        String[] dirH = new String[]{"H"};
        try {
            RemoteFile first = this.root.createDirectory(dirH);
            RemoteFile grabber = this.root.getChild(dirH);
            grabber.remove();
            first.getChild(new String[]{"dir"});
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirH, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetChildren() throws InvalidStateException, NotDirectoryException, ServerException {
        RemoteFile dirA = null;
        RemoteFileOperations f = null;
        try {
            dirA = this.root.createDirectory(new String[]{"dirA"});
            RemoteFile dirB = dirA.createDirectory(new String[]{"dirB"});
            RemoteFile dirC = dirA.createDirectory(new String[]{"dirC"});
            dirC.createFile(new String[]{"D", "E", "F"});
            f = dirA.createFile(new String[]{"file"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int total = 0;
        int expected = 8;
        Vector<RemoteFile> elements = new Vector<RemoteFile>();
        elements.add(this.root);
        while (elements.size() > 0) {
            RemoteFile remoteFile = (RemoteFile)elements.elementAt(0);
            if (remoteFile.isDirectory()) {
                RemoteFile[] children = remoteFile.getChildren();
                elements.addAll(Arrays.asList(children));
            }
            elements.remove(0);
            ++total;
        }
        TestRemoteFileDefaultServantImpl.assertEquals((int)expected, (int)total);
        String[] filename = new String[]{"dirA", "file"};
        try {
            f.getChildren();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotDirectoryException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(filename, ex.name));
        }
        try {
            f.remove();
            f.getChildren();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(filename, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetFullName() throws InvalidStateException, ServerException {
        RemoteFileOperations file = null;
        try {
            RemoteFile fileA = this.root.createDirectory(new String[]{"A", "B", "C", "D"});
            RemoteFile fileB = fileA.createDirectory(new String[]{"E"});
            file = fileB.createFile(new String[]{"file"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String[] name = new String[]{"A", "B", "C", "D", "E", "file"};
        String[] actual = file.getFullName();
        TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(name, actual));
        try {
            file.remove();
            file.getFullName();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(name, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
    }

    public void testGetName() throws InvalidStateException, ServerException {
        RemoteFile probeDir = null;
        RemoteFile probeFile = null;
        String[] probeDirStr = new String[]{"A", "A1"};
        String[] probeFileStr = new String[]{"B", "B1"};
        try {
            probeDir = this.root.createDirectory(probeDirStr);
            probeFile = this.root.createFile(probeFileStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        TestRemoteFileDefaultServantImpl.assertEquals((String)"A1", (String)probeDir.getName());
        TestRemoteFileDefaultServantImpl.assertEquals((String)"B1", (String)probeFile.getName());
        try {
            probeFile.remove();
            probeFile.getName();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(probeFileStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            probeDir.remove();
            probeDir.getName();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(probeDirStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetParent() throws InvalidPathException, InvalidStateException, ServerException {
        RemoteFile probe = null;
        RemoteFile parent = null;
        String[] probeStr = new String[]{"A", "B"};
        try {
            probe = this.root.createDirectory(probeStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        parent = probe.getParent();
        TestRemoteFileDefaultServantImpl.assertEquals((String)"A", (String)parent.getName());
        parent = parent.getParent();
        try {
            parent = parent.getParent();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(new String[]{".."}, ex.name));
        }
        try {
            probe.remove();
            probe.getParent();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(probeStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetRandomAccessChannel() throws NotFileException, InvalidStateException, ServerException {
        RandomAccessChannel raf;
        OctetSequenceHolder buf;
        OctetSequenceHolder buf2;
        RandomAccessChannel raf2;
        RemoteFile file = null;
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ";
        try {
            raf2 = file.getRandomAccessChannel();
            raf2.write(alphabet.length(), alphabet.getBytes());
            buf2 = new OctetSequenceHolder(new byte[1]);
            raf2.seek(0L);
            raf2.read(1, buf2);
            TestRemoteFileDefaultServantImpl.assertEquals((int)65, (int)buf2.value[0]);
            long skip = raf2.skip(3L);
            TestRemoteFileDefaultServantImpl.assertEquals((long)3L, (long)skip);
            raf2.read(1, buf2);
            TestRemoteFileDefaultServantImpl.assertEquals((int)69, (int)buf2.value[0]);
            raf2.seek(2L);
            raf2.read(1, buf2);
            TestRemoteFileDefaultServantImpl.assertEquals((int)67, (int)buf2.value[0]);
            RandomAccessChannel another = file.getRandomAccessChannel();
            another.seek(3L);
            String corruptAlphabet = "NERY";
            another.write(corruptAlphabet.length(), corruptAlphabet.getBytes());
            raf2.seek(0L);
            buf2.value = new byte[25];
            raf2.read(25, buf2);
            TestRemoteFileDefaultServantImpl.assertEquals((String)"ABCNERYHIJKLMNOPQRSTUWXYZ", (String)new String(buf2.value));
            another.close();
            raf2.close();
        }
        catch (ClosedChannelException ex) {
            ex.printStackTrace();
        }
        try {
            raf2 = file.getRandomAccessChannel();
            raf2.seek(-10L);
            buf2 = new OctetSequenceHolder(new byte[1]);
            raf2.read(1, buf2);
            TestRemoteFileDefaultServantImpl.assertEquals((int)65, (int)buf2.value[0]);
            raf2.seek(50L);
            raf2.write(2, new byte[]{37, 33});
            raf2.close();
            RemoteFile existingFile = this.root.getChild(new String[]{"A", "B", "C"});
            TestRemoteFileDefaultServantImpl.assertEquals((long)52L, (long)existingFile.size());
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            buf = new OctetSequenceHolder(new byte[1]);
            raf = file.getRandomAccessChannel();
            raf.skip(3L);
            raf.write(4, new byte[]{68, 69, 70, 71});
            raf.skip(-2L);
            raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)70, (int)buf.value[0]);
            raf.skip(-3L);
            raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)68, (int)buf.value[0]);
            raf.skip(-50L);
            raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)65, (int)buf.value[0]);
            raf.skip(100L);
            raf.skip(-1L);
            raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)33, (int)buf.value[0]);
            raf.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            buf = new OctetSequenceHolder(new byte[1]);
            raf = file.getRandomAccessChannel();
            raf.skip(100L);
            int read = raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)0, (int)read);
            raf.skip(-1L);
            raf.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)33, (int)buf.value[0]);
            raf.close();
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            raf2 = file.getRandomAccessChannel();
            boolean isOpen = raf2.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)true, (boolean)isOpen);
            raf2.close();
            isOpen = raf2.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)false, (boolean)isOpen);
            raf2.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            raf2 = file.getRandomAccessChannel();
            raf2.close();
            RemoteFile fileFromRAF = raf2.getFile();
            String[] expectedFullName = file.getFullName();
            String[] actualFullName = fileFromRAF.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(expectedFullName, actualFullName));
            TestRemoteFileDefaultServantImpl.assertEquals((long)52L, (long)fileFromRAF.size());
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            raf2 = file.getRandomAccessChannel();
            raf2.close();
            try {
                raf2.skip(1L);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
            try {
                raf2.seek(1L);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
            try {
                raf2.read(0, new OctetSequenceHolder(new byte[0]));
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
            try {
                raf2.write(0, new byte[0]);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            file.remove();
            raf2 = file.getRandomAccessChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        String[] dirStr = new String[]{"dir1", "dir2", "dir3", "dirXYZ"};
        try {
            RemoteFile dir = this.root.createDirectory(dirStr);
            dir.getRandomAccessChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetReadChannel() throws InvalidStateException, NotFileException, ServerException {
        ReadChannel reader;
        RemoteFile file = null;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ";
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
            WriteChannel writer = file.getWriteChannel();
            writer.write(alphabet.length(), alphabet.getBytes());
            writer.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            reader = file.getReadChannel();
            ReadChannel another = file.getReadChannel();
            OctetSequenceHolder buf = new OctetSequenceHolder(new byte[1]);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)65, (int)buf.value[0]);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)66, (int)buf.value[0]);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)67, (int)buf.value[0]);
            reader.skip(5L);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)73, (int)buf.value[0]);
            buf.value = new byte[16];
            reader.read(16, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((String)"JKLMNOPQRSTUWXYZ", (String)new String(buf.value));
            another.close();
            reader.close();
        }
        catch (ClosedChannelException ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            reader = file.getReadChannel();
            OctetSequenceHolder buf = new OctetSequenceHolder(new byte[1]);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)65, (int)buf.value[0]);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)66, (int)buf.value[0]);
            reader.skip(-1L);
            reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)67, (int)buf.value[0]);
            reader.skip(100L);
            int read = reader.read(1, buf);
            TestRemoteFileDefaultServantImpl.assertEquals((int)0, (int)read);
            reader.close();
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            reader = file.getReadChannel();
            boolean isOpen = reader.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)true, (boolean)isOpen);
            reader.close();
            isOpen = reader.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)false, (boolean)isOpen);
            reader.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            reader = file.getReadChannel();
            reader.close();
            RemoteFile fileFromRAF = reader.getFile();
            String[] expectedFullName = file.getFullName();
            String[] actualFullName = fileFromRAF.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(expectedFullName, actualFullName));
            TestRemoteFileDefaultServantImpl.assertEquals((long)25L, (long)fileFromRAF.size());
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            reader = file.getReadChannel();
            reader.close();
            try {
                reader.skip(1L);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
            try {
                reader.read(0, new OctetSequenceHolder(new byte[0]));
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            file.remove();
            reader = file.getReadChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            for (int i = 0; i < fileStr.length; ++i) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)fileStr[i], (String)ex.name[i]);
            }
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        String[] dirStr = new String[]{"dir1", "dir2", "dir3", "dirXYZ"};
        try {
            RemoteFile dir = this.root.createDirectory(dirStr);
            dir.getReadChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testGetWriteChannel() throws InvalidStateException, NotFileException, ServerException {
        int i;
        WriteChannel writer;
        RemoteFile file = null;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ!";
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            int i2;
            writer = file.getWriteChannel();
            WriteChannel another = file.getWriteChannel();
            for (i2 = 0; i2 < alphabet.length(); ++i2) {
                writer.write(1, new byte[]{(byte)alphabet.charAt(i2)});
            }
            writer.write(alphabet.length(), alphabet.getBytes());
            for (i2 = 0; i2 < alphabet.length(); i2 += 2) {
                writer.write(2, new byte[]{(byte)alphabet.charAt(i2), (byte)alphabet.charAt(i2 + 1)});
            }
            another.close();
            writer.close();
            ReadChannel reader = file.getReadChannel();
            OctetSequenceHolder buf = new OctetSequenceHolder(new byte[1]);
            for (i = 0; i < alphabet.length() * 3; ++i) {
                reader.read(1, buf);
                TestRemoteFileDefaultServantImpl.assertEquals((byte)((byte)alphabet.charAt(i % alphabet.length())), (byte)buf.value[0]);
            }
            reader.close();
        }
        catch (ClosedChannelException ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            writer = file.getWriteChannel();
            boolean isOpen = writer.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)true, (boolean)isOpen);
            writer.close();
            isOpen = writer.isOpen();
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)false, (boolean)isOpen);
            writer.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            writer = file.getWriteChannel();
            writer.close();
            RemoteFile fileFromRAF = writer.getFile();
            String[] expectedFullName = file.getFullName();
            String[] actualFullName = fileFromRAF.getFullName();
            if (expectedFullName.length == 3) {
                for (i = 0; i < expectedFullName.length; ++i) {
                    TestRemoteFileDefaultServantImpl.assertEquals((String)expectedFullName[i], (String)actualFullName[i]);
                }
            }
            TestRemoteFileDefaultServantImpl.assertEquals((long)0L, (long)fileFromRAF.size());
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            writer = file.getWriteChannel();
            writer.close();
            try {
                writer.write(0, new byte[0]);
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (ClosedChannelException exc) {
                TestRemoteFileDefaultServantImpl.assertEquals((String)"C", (String)exc.ch.getFile().getName());
            }
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            file.remove();
            writer = file.getWriteChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        String[] dirStr = new String[]{"dir1", "dir2", "dir3", "dirXYZ"};
        try {
            RemoteFile dir = this.root.createDirectory(dirStr);
            dir.getWriteChannel();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testHash() throws InvalidStateException {
        WriteChannel writer;
        RemoteFile file = null;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ";
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
            writer = file.getWriteChannel();
            writer.write(alphabet.length(), alphabet.getBytes());
            writer.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            MessageDigest digester = MessageDigest.getInstance("MD5");
            digester.update(alphabet.getBytes(), 0, alphabet.length());
            byte[] digest = digester.digest();
            byte[] hash = file.hash();
            for (int i = 0; i < digest.length; ++i) {
                TestRemoteFileDefaultServantImpl.assertEquals((byte)digest[i], (byte)hash[i]);
            }
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            writer = file.getWriteChannel();
            writer.close();
            try {
                MessageDigest digester = MessageDigest.getInstance("MD5");
                digester.update(new byte[0], 0, 0);
                byte[] digest = digester.digest();
                byte[] hash = file.hash();
                for (int i = 0; i < digest.length; ++i) {
                    TestRemoteFileDefaultServantImpl.assertEquals((byte)digest[i], (byte)hash[i]);
                }
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        String[] parentFullName = null;
        try {
            RemoteFile parent = file.getParent();
            parentFullName = parent.getFullName();
            parent.hash();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(parentFullName, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            file.remove();
            byte[] hash = file.hash();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
    }

    public void testIsDirectory() throws InvalidStateException, ServerException {
        RemoteFile file = null;
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)false, (boolean)file.isDirectory());
            TestRemoteFileDefaultServantImpl.assertEquals((boolean)true, (boolean)file.getParent().isDirectory());
        }
        catch (InvalidPathException ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            file.remove();
            file.isDirectory();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
    }

    public void testRemove() throws FileInUseException, NotEmptyException, InvalidStateException, ServerException {
        RemoteFile file = null;
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
            file.remove();
            file = this.root.getChild(fileStr);
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)true);
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        ChannelOperations reader = null;
        try {
            file = this.root.createFile(fileStr);
            reader = file.getReadChannel();
            file.remove();
        }
        catch (FileInUseException ex) {
            reader.close();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        String[] parentFullName = null;
        try {
            RemoteFile parent = file.getParent();
            parentFullName = parent.getFullName();
            parent.remove();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotEmptyException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(parentFullName, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            file.remove();
            file.remove();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidStateException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(fileStr, ex.name));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            this.recursiveRemove(this.root);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileInUseException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(new String[0], ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    public void testSize() throws InvalidStateException, ServerException {
        RemoteFile file = null;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ";
        String[] fileStr = new String[]{"A", "B", "C"};
        try {
            file = this.root.createFile(fileStr);
            WriteChannel writer = file.getWriteChannel();
            writer.write(alphabet.length(), alphabet.getBytes());
            writer.close();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            TestRemoteFileDefaultServantImpl.assertEquals((long)alphabet.length(), (long)file.size());
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            this.root.size();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(new String[0], ex.name));
        }
    }

    public void testAddMountPoint() throws InvalidStateException, NotDirectoryException, FileAlreadyExistsException, InvalidPathException, ServerException {
        String[] fileInMountFullName;
        RemoteFile fileInMount;
        RemoteFile mountDir = this.root.createDirectory(new String[]{"A", "B", "C"});
        RemoteFile mountPoint = this.root.createDirectory(new String[]{"D", "E", "F", "G", "H"});
        String[] mntStr = new String[]{"M", "mnt"};
        mountDir.addMountPoint(mntStr, mountPoint);
        String[] realFile = new String[]{"D", "E", "F", "G", "H", "file"};
        try {
            String[] mntDir = new String[]{"A", "B", "C", "M", "mnt"};
            RemoteFile file = this.root.getChild(mntDir);
            fileInMount = file.createFile(new String[]{"file"});
            fileInMountFullName = fileInMount.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(realFile, fileInMountFullName));
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        String[] probe = new String[]{"A", "B", "C", "M", "mnt"};
        try {
            this.root.createFile(probe);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileAlreadyExistsException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)true);
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(probe, ex.name));
        }
        try {
            this.root.createDirectory(probe);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileAlreadyExistsException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)true);
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(probe, ex.name));
        }
        String[] mountPointStr = mountPoint.getFullName();
        try {
            RemoteFile mnt = this.root.getChild(probe);
            mnt.remove();
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotEmptyException exc) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(mountPointStr, exc.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        try {
            fileInMount = this.root.getChild(realFile);
            fileInMountFullName = fileInMount.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(realFile, fileInMountFullName));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            mountDir.removeMountPoint(mntStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void testRemoveMountPoint() throws InvalidStateException, NotDirectoryException, FileAlreadyExistsException, InvalidPathException, ServerException {
        String[] mntStr = new String[]{"A", "mnt"};
        String[] targetStr = new String[]{"B", "C"};
        RemoteFile target = this.root.createDirectory(targetStr);
        boolean created = this.root.addMountPoint(mntStr, target);
        try {
            RemoteFile removed = this.root.removeMountPoint(mntStr);
            String[] expectedName = target.getFullName();
            String[] actualName = removed.getFullName();
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(expectedName, actualName));
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        try {
            this.root.removeMountPoint(new String[0]);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (InvalidPathException ex) {
            this.assertEquals(new String[0], ex.name);
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
        String[] regularFile = new String[]{"false_mount"};
        this.root.createFile(regularFile);
        try {
            this.root.removeMountPoint(regularFile);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (FileNotFoundException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(regularFile, ex.name));
        }
    }

    public void testCopyTo_UsingNIO() throws InvalidStateException, NotFileException, ServerException {
        this.copyDirTest("NIO");
        this.copyFile("NIO");
    }

    public void testCopyTo_UsingCORBA() throws InvalidStateException, NotFileException, ServerException {
        this.copyDirTest("CORBA");
        this.copyFile("CORBA");
    }

    private void copyDirTest(String method) throws InvalidStateException, NotFileException {
        String[] dirStr = new String[]{"dir"};
        try {
            RemoteFile dir = this.root.createDirectory(dirStr);
            RemoteFile target = this.root.createDirectory(new String[]{"targetDir"});
            dir.copyTo(target, method);
            TestRemoteFileDefaultServantImpl.fail();
        }
        catch (NotFileException ex) {
            TestRemoteFileDefaultServantImpl.assertTrue((boolean)this.assertEquals(dirStr, ex.name));
        }
        catch (Exception exc) {
            TestRemoteFileDefaultServantImpl.fail();
            exc.printStackTrace();
        }
    }

    private void copyFile(String method) throws InvalidStateException, NotFileException, ServerException {
        RemoteFileOperations source = null;
        RemoteFileOperations target1 = null;
        RemoteFileOperations target2 = null;
        RemoteFileOperations target3 = null;
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUWXYZ";
        try {
            source = this.root.createFile(new String[]{"A", "B", "C"});
            WriteChannel writer = source.getWriteChannel();
            writer.write(alphabet.length(), alphabet.getBytes());
            writer.close();
            target1 = this.root.createFile(new String[]{"T1"});
            target2 = this.root.createFile(new String[]{"T2"});
            target3 = this.root.createFile(new String[]{"T3"});
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        source.copyTo((RemoteFile)target3, method);
        byte[] sourceHash = source.hash();
        byte[] target1Hash = target1.hash();
        byte[] target2Hash = target2.hash();
        byte[] target3Hash = target3.hash();
        for (int i = 0; i < sourceHash.length; ++i) {
            TestRemoteFileDefaultServantImpl.assertEquals((byte)sourceHash[i], (byte)target1Hash[i]);
            TestRemoteFileDefaultServantImpl.assertEquals((byte)sourceHash[i], (byte)target2Hash[i]);
            TestRemoteFileDefaultServantImpl.assertEquals((byte)sourceHash[i], (byte)target3Hash[i]);
        }
        RemoteFile bigOne = null;
        try {
            bigOne = this.root.createFile(new String[]{"BigOne"});
            RandomAccessChannel raf = bigOne.getRandomAccessChannel();
            byte[] chunk = new byte[1024];
            byte[] small = new byte[]{65};
            for (int i = 0; i < chunk.length; ++i) {
                chunk[i] = (byte)(i % 10 + 48);
                raf.write(1, small);
            }
            raf.write(chunk.length, chunk);
            raf.close();
            WriteChannel writer = bigOne.getWriteChannel();
            for (int i = 0; i < 1024; ++i) {
                writer.write(chunk.length, chunk);
            }
            writer.close();
            TestRemoteFileDefaultServantImpl.assertEquals((long)(1024 * chunk.length), (long)bigOne.size());
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        RemoteFile bigTarget = null;
        try {
            bigTarget = this.root.createFile(new String[]{"BigTarget"});
            bigOne.copyTo(bigTarget, method);
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
        byte[] bigOneHash = bigOne.hash();
        byte[] bigTargetHash = bigTarget.hash();
        if (bigOneHash.length == bigTargetHash.length) {
            for (int i = 0; i < bigOneHash.length; ++i) {
                TestRemoteFileDefaultServantImpl.assertEquals((byte)bigOneHash[i], (byte)bigTargetHash[i]);
            }
        } else {
            TestRemoteFileDefaultServantImpl.fail();
        }
    }

    public void testLeasing() throws InvalidStateException, NotFileException {
        try {
            RemoteFile fileReadChannel = null;
            fileReadChannel = this.root.createFile(new String[]{"fileReadChannel"});
            fileReadChannel.getReadChannel();
            RemoteFile fileWriteChannel = null;
            fileWriteChannel = this.root.createFile(new String[]{"fileWriteChannel"});
            fileWriteChannel.getWriteChannel();
            RemoteFile fileRandomAccessChannel = null;
            fileRandomAccessChannel = this.root.createFile(new String[]{"fileRandomAccessChannel"});
            fileRandomAccessChannel.getRandomAccessChannel();
            int excCount = 0;
            try {
                fileReadChannel.remove();
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileInUseException ex) {
                ++excCount;
            }
            try {
                fileWriteChannel.remove();
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileInUseException ex) {
                ++excCount;
            }
            try {
                fileRandomAccessChannel.remove();
                TestRemoteFileDefaultServantImpl.fail();
            }
            catch (FileInUseException ex) {
                ++excCount;
            }
            TestRemoteFileDefaultServantImpl.assertEquals((int)3, (int)excCount);
            if (excCount > 0) {
                long time = SystemProperties.getIntProperty("INACTIVITY_LIMIT") * 2;
                System.out.println("testLeasing: sleeping for a while: " + time + " ms");
                Thread.sleep(time);
            }
            fileReadChannel.remove();
            fileWriteChannel.remove();
            fileRandomAccessChannel.remove();
        }
        catch (Exception ex) {
            TestRemoteFileDefaultServantImpl.fail();
            ex.printStackTrace();
        }
    }

    public void testGetFileServer() throws InvalidStateException, ServerException {
        TestRemoteFileDefaultServantImpl.assertNotNull((java.lang.Object)this.root.getFileServer().getName());
    }

    public void testShutdown() {
        try {
            this.root.getFileServer().shutdown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

