/* Importao das bibliotecas que a aplicao utiliza. */ 
#include <stdio.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#define SATURATION 4

int main(int argc, char** argv) {
	int myPid;
	char str[100];
	int load = 0;
	FILE *f;
    char command[100];

    /* Coleta o nmero de CPUs da mquina local */
    #ifdef IRIX 
        #define numberOfProcessors SATURATION*sysconf(_SC_NPROC_CONF)
    #else
    	#ifdef IRIX64
        	#define numberOfProcessors SATURATION*sysconf(_SC_NPROC_CONF)
    	#else
        	#define numberOfProcessors SATURATION*sysconf(_SC_NPROCESSORS_CONF) 
    	#endif
    #endif

	int pids[numberOfProcessors];

    if(argc != 2) 
    {
        printf("Uso: ./testUnixBench <hostName>\n");
        exit(0);
    }

    /* Remove resultados antigos do benchmark */
    remove(argv[1]);

    /* Inicializa o benchmark com carga de trabalho externa igual a zero */
    strcat(command, "./csBench ");
    strcat(command, argv[1]);
    f = popen(command, "r");
    fscanf(f, "%s", str);
    printf("A capacidade da maquina com carga 0 eh de %s csFlops.\n", str);

    /* Inicializa processos consumidores de CPU, totalizando uma carga
     * de trabalho igual a 4 vezes o nmero de processadores */
    while(load < numberOfProcessors) {
		myPid = fork();
		if(myPid == 0) {
			/* Processo consumidor de CPU */
			float i = 0.0;
			while(1) {
				i *= 1;
			}
		}
		else {
            /* Remove resultados antigos do benchmark */
            remove(argv[1]);

            /* Armazena o processo consumidor de CPU criado e inicia
             * uma nova execuo do benchmark */
			pids[load] = myPid;
			sleep(10);
			f = popen(command, "r");
			fscanf(f, "%s", str);
        	printf("A capacidade da maquina com carga %d eh de %s csFlops.\n", 
                    (load+1), str);
		}
		load++;
	}

    /* Finaliza os processos criados para que no se tornem zumbis */
	if(myPid != 0) {
		int i;
		for(i = 0; i < numberOfProcessors; i++)
			kill(pids[i], 3);
	}

    return 0;
}
