/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.streamblockingnio;

import csfs.datatransfer.streamblockingnio.StreamBlockingNIOMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamBlockingNIOSenderThread
extends Thread {
    private InetSocketAddress targetAddress;
    private File localFile;
    private long offset;
    private long length;
    private String targetFilename;
    private StreamBlockingNIOMethod parent;
    private long copyID;
    private boolean response;

    public StreamBlockingNIOSenderThread(InetSocketAddress targetAddress, File localFile, long offset, long length, String targetFilename, long copyID, StreamBlockingNIOMethod parent) {
        this.targetAddress = targetAddress;
        this.localFile = localFile;
        this.offset = offset;
        this.length = length;
        this.targetFilename = targetFilename;
        this.copyID = copyID;
        this.parent = parent;
    }

    @Override
    public void run() {
        try {
            SocketChannel socketChannel = null;
            while (socketChannel == null || !socketChannel.isConnected()) {
                try {
                    socketChannel = SocketChannel.open();
                    socketChannel.socket().setSoTimeout(14400000);
                    socketChannel.socket().connect(this.targetAddress, 14400000);
                }
                catch (IOException e) {
                    Logger.global.log(Level.SEVERE, "IOException em StreamBlockingNIOSenderThread:run():connect()! Ignoring!!!", e);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            FileInputStream file = new FileInputStream(this.localFile);
            FileChannel fileChannel = file.getChannel();
            String initProtocol = "" + this.offset + "\n" + this.length + "\n" + "1" + "\n" + this.targetFilename + "\n";
            int headerSize = initProtocol.length();
            String headerSizeStr = headerSize + "\n";
            ByteBuffer headerLength = ByteBuffer.allocate(7);
            headerLength.put(headerSizeStr.getBytes());
            headerLength.rewind();
            socketChannel.write(headerLength);
            ByteBuffer out = ByteBuffer.allocate(initProtocol.length());
            out.put(initProtocol.getBytes());
            out.rewind();
            socketChannel.write(out);
            fileChannel.transferTo(this.offset, this.length, socketChannel);
            fileChannel.close();
            ByteBuffer result = ByteBuffer.allocate(1);
            socketChannel.read(result);
            if (result.get(0) == 0) {
                this.response = true;
            }
            socketChannel.close();
            this.parent.notifyThreadEnd(this);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public long getCopyID() {
        return this.copyID;
    }

    public boolean getResponse() {
        return this.response;
    }

    public String getFilename() {
        return this.targetFilename;
    }
}

