/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.jacorb.idl.AliasTypeSpec;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.Environment;
import org.jacorb.idl.GlobalInputStream;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IDLTypes;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.IllegalRedefinition;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameAlreadyDefined;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.NoHelperException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.TypeDeclaration;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.Value;
import org.jacorb.idl.ValueBody;
import org.jacorb.idl.ValueInheritanceSpec;
import org.jacorb.idl.parser;

public class ValueAbsDecl
extends Value {
    ValueBody body = null;
    ValueInheritanceSpec inheritanceSpec;

    public ValueAbsDecl(int num) {
        super(num);
        this.pack_name = "";
    }

    @Override
    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.body != null) {
            this.body.setPackage(s);
        }
        if (this.inheritanceSpec != null) {
            this.inheritanceSpec.setPackage(s);
        }
    }

    public void setInheritanceSpec(ValueInheritanceSpec spec) {
        this.inheritanceSpec = spec;
    }

    public ValueInheritanceSpec setInheritanceSpec() {
        return this.inheritanceSpec;
    }

    @Override
    public TypeDeclaration declaration() {
        return this;
    }

    @Override
    public String typeName() {
        return this.full_name();
    }

    @Override
    public Object clone() {
        throw new RuntimeException("Don't clone me, i am an interface!");
    }

    @Override
    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            parser.logger.log(Level.SEVERE, "was " + this.enclosing_symbol.getClass().getName() + " now: " + s.getClass().getName());
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    @Override
    public boolean basic() {
        return true;
    }

    @Override
    public String holderName() {
        return this.javaName() + "Holder";
    }

    @Override
    public String helperName() throws NoHelperException {
        throw new NoHelperException();
    }

    @Override
    public String toString() {
        return this.getFullName(this.typeName());
    }

    @Override
    public void set_included(boolean i) {
        this.included = i;
    }

    @Override
    public void parse() {
        boolean justAnotherOne;
        block13: {
            justAnotherOne = false;
            this.escapeName();
            ConstrTypeSpec ctspec = new ConstrTypeSpec(ValueAbsDecl.new_num());
            try {
                ScopedName.definePseudoScope(this.full_name());
                ctspec.c_type_spec = this;
                NameTable.define(this.full_name(), IDLTypes.TYPE);
                TypeMap.typedef(this.full_name(), ctspec);
            }
            catch (IllegalRedefinition ill) {
                parser.fatal_error("Cannot redefine " + this.token.str_val + " in nested scope as " + ill.newDef, this.token);
            }
            catch (NameAlreadyDefined nad) {
                if (this.body != null) {
                    justAnotherOne = true;
                }
                if (this.full_name().equals("org.omg.CORBA.TypeCode") || this.body == null) break block13;
                TypeMap.replaceForwardDeclaration(this.full_name(), ctspec);
            }
        }
        if (this.body != null) {
            if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                if (parser.logger.isLoggable(Level.ALL)) {
                    parser.logger.log(Level.ALL, "Checking inheritanceSpec of " + this.full_name());
                }
                Enumeration e = this.inheritanceSpec.v.elements();
                while (e.hasMoreElements()) {
                    ConstrTypeSpec ts;
                    ScopedName name = (ScopedName)e.nextElement();
                    TypeSpec resolvedTSpec = name.resolvedTypeSpec();
                    if (!parser.strict_inheritance) continue;
                    while (resolvedTSpec instanceof AliasTypeSpec) {
                        resolvedTSpec = ((AliasTypeSpec)resolvedTSpec).originalType();
                    }
                    if (!(resolvedTSpec instanceof ConstrTypeSpec)) {
                        if (parser.logger.isLoggable(Level.ALL)) {
                            parser.logger.log(Level.ALL, "Illegal inheritance spec, not a constr. type but " + resolvedTSpec.getClass() + ", name " + name);
                        }
                        parser.fatal_error("Illegal inheritance spec (not a constr. type): " + this.inheritanceSpec, this.token);
                    }
                    if ((ts = (ConstrTypeSpec)resolvedTSpec).declaration() instanceof Interface || ts.declaration() instanceof ValueAbsDecl) continue;
                    parser.fatal_error("Illegal inheritance spec (not an intf. or abs. value type): " + this.inheritanceSpec, this.token);
                }
                this.body.set_ancestors(this.inheritanceSpec);
            }
            this.body.parse();
            NameTable.parsed_interfaces.put(this.full_name(), "");
        } else if (!justAnotherOne) {
            parser.set_pending(this.full_name(), this);
        }
    }

    ValueBody getBody() {
        if (parser.get_pending(this.full_name()) != null) {
            parser.fatal_error(this.full_name() + " is forward declared and still pending!", this.token);
        } else if (this.body == null) {
            if ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec != this) {
                this.body = ((ValueAbsDecl)((ConstrTypeSpec)TypeMap.map((String)this.full_name())).c_type_spec).getBody();
            }
            if (this.body == null) {
                parser.fatal_error(this.full_name() + " still has an empty body!", this.token);
            }
        }
        return this.body;
    }

    @Override
    public String getTypeCodeExpression() {
        return this.getTypeCodeExpression(new HashSet());
    }

    @Override
    public String getTypeCodeExpression(Set knownTypes) {
        if (knownTypes.contains(this)) {
            return this.getRecursiveTypeCodeExpression();
        }
        knownTypes.add(this);
        return "org.omg.CORBA.ORB.init().create_value_tc(\"" + this.id() + "\", \"" + this.name + "\", org.omg.CORBA.VM_ABSTRACT.value " + ", null, null)";
    }

    @Override
    public String printReadExpression(String streamname) {
        return "(" + this.javaName() + ")" + "((org.omg.CORBA_2_3.portable.InputStream)" + streamname + ")" + ".read_value (\"" + this.id() + "\")";
    }

    @Override
    public String printReadStatement(String var_name, String streamname) {
        return var_name + " = " + this.printReadExpression(streamname);
    }

    @Override
    public String printWriteStatement(String var_name, String streamname) {
        return "((org.omg.CORBA_2_3.portable.OutputStream)" + streamname + ")" + ".write_value (" + var_name + ");";
    }

    @Override
    public void print(PrintWriter unused) {
        if (this.included && !this.generateIncluded()) {
            return;
        }
        if (this.body != null) {
            try {
                File f;
                String path = parser.out_dir + fileSeparator + this.pack_name.replace('.', fileSeparator);
                File dir = new File(path);
                if (!dir.exists() && !dir.mkdirs()) {
                    parser.fatal_error("Unable to create " + path, null);
                }
                if (GlobalInputStream.isMoreRecentThan(f = new File(dir, this.name + ".java"))) {
                    Enumeration e;
                    PrintWriter ps = new PrintWriter(new FileWriter(f));
                    if (!this.pack_name.equals("")) {
                        ps.println("package " + this.pack_name + ";" + Environment.NL);
                    }
                    this.printClassComment("abstract value type", this.name, ps);
                    if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                        e = this.inheritanceSpec.v.elements();
                        while (e.hasMoreElements()) {
                            ScopedName sn = (ScopedName)e.nextElement();
                            if (sn.resolvedName().indexOf(46) >= 0) continue;
                            ps.println("import " + sn + "Operations;");
                        }
                    }
                    this.printImport(ps);
                    ps.println("public interface " + this.name);
                    ps.print("\textends org.omg.CORBA.portable.ValueBase ");
                    if (this.inheritanceSpec != null && this.inheritanceSpec.v.size() > 0) {
                        e = this.inheritanceSpec.v.elements();
                        while (e.hasMoreElements()) {
                            ps.print(", " + e.nextElement());
                        }
                    }
                    ps.println(Environment.NL + "{");
                    if (this.body != null) {
                        this.body.printOperationSignatures(ps);
                    }
                    ps.println("}");
                    ps.close();
                }
            }
            catch (IOException i) {
                throw new RuntimeException("File IO error" + i);
            }
        }
    }

    @Override
    public void printInsertIntoAny(PrintWriter ps, String anyname, String varname) {
        ps.println("\t\t" + anyname + ".insert_Value(" + varname + ", " + varname + "._type());");
    }

    @Override
    public void printExtractResult(PrintWriter ps, String resultname, String anyname, String resulttype) {
        ps.println("\t\t" + resultname + " = (" + resulttype + ")" + anyname + ".extract_Value();");
    }

    @Override
    public void accept(IDLTreeVisitor visitor) {
        visitor.visitValue(this);
    }
}

